/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import javax.sql.DataSource;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;

public interface JdbcHelper {
    public LikeSupport getLikeSupport();

    public boolean supportsIlike();

    public boolean supportsEscape();

    public char getEscapeChar();

    public boolean supportsTransactions();

    @Contract(value="!null, _ -> !null")
    public <T> T escapeSqlRegex(T var1, boolean var2);

    public boolean isZonedTimeColumn(@Nullable String var1);

    public boolean isZonedTimestampColumn(@Nullable String var1, int var2);

    public boolean isTimestamp(int var1);

    public boolean isZonedColumn(@Nullable String var1, int var2);

    @Nullable
    public String parseVersion(@Nullable String var1);

    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource var1);

    public void adjustType(@NotNull Type var1);

    public boolean supportsCalendarInPreparedStatement();

    public boolean supportsLimitMaxRows();

    @Nullable(value="no support at all")
    public JdbcSettings.SslMode[] supportedSslModes();

    public boolean supportsIntegratedSecurity();

    public static enum LikeSupport {
        NONE,
        SELECTS_ONLY,
        FULL;


        public boolean isSupported(boolean inUpdate) {
            switch (this) {
                case NONE: {
                    return false;
                }
                case SELECTS_ONLY: {
                    return !inUpdate;
                }
                case FULL: {
                    return true;
                }
            }
            throw new AssertionError((Object)("LikeSupport type is not known " + (Object)((Object)this)));
        }
    }

    public static class Type {
        @Nullable
        public String typeName;
        @Nullable
        public String typeSuffix;
        public int length;
        public int scale;
        public boolean nullable;
        public int type;
    }
}

