/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class GPlumJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern GPLUM_VERSION_PATTERN = Pattern.compile("greenplum database\\s+" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN, 2);

    public GPlumJdbcHelper() {
        this(null, null);
    }

    private GPlumJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Rdbms.of((String)"GREENPLUM"), version, connection);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return GPlumJdbcHelper.extractVersion(version);
    }

    @NotNull
    static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String version) {
        GPlumJdbcHelper gPlumJdbcHelper = new GPlumJdbcHelper(GPlumJdbcHelper.extractVersion(version), delegate);
        if (gPlumJdbcHelper == null) {
            GPlumJdbcHelper.$$$reportNull$$$0(0);
        }
        return gPlumJdbcHelper;
    }

    @Nullable
    private static String extractVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, GPLUM_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/GPlumJdbcHelper", "create"));
    }
}

