/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sh.ShStringUtil;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShRunConfigurationProfileState
implements RunProfileState {
    private static final String WHITESPACE = " ";
    private final Project myProject;
    private final ShRunConfiguration myRunConfiguration;

    public ShRunConfigurationProfileState(@NotNull Project project, @NotNull ShRunConfiguration runConfiguration) {
        if (project == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        ShRunner shRunner;
        if (runner == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(2);
        }
        if ((shRunner = (ShRunner)ServiceManager.getService((Project)this.myProject, ShRunner.class)) == null || !shRunner.isAvailable(this.myProject)) {
            return this.buildExecutionResult();
        }
        shRunner.run(this.buildCommand());
        return null;
    }

    private ExecutionResult buildExecutionResult() throws ExecutionException {
        GeneralCommandLine commandLine = this.createCommandLine();
        ProcessHandler processHandler = ShRunConfigurationProfileState.createProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        TerminalExecutionConsole console = new TerminalExecutionConsole(this.myProject, processHandler);
        console.attachToProcess(processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    private static ProcessHandler createProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        KillableProcessHandler killableProcessHandler = new KillableProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return BaseDataReader.SleepingPolicy.BLOCKING;
                    }

                    public boolean splitToLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sh/run/ShRunConfigurationProfileState$1", "readerOptions"));
            }
        };
        if (killableProcessHandler == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(3);
        }
        return killableProcessHandler;
    }

    @NotNull
    private GeneralCommandLine createCommandLine() throws ExecutionException {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(this.myRunConfiguration.getScriptPath());
        if (virtualFile == null || virtualFile.getParent() == null) {
            throw new ExecutionException("Cannot determine shell script parent directory");
        }
        PtyCommandLine commandLine = new PtyCommandLine();
        if (!SystemInfo.isWindows) {
            commandLine.getEnvironment().put("TERM", "xterm-256color");
        }
        commandLine.withConsoleMode(false);
        commandLine.withInitialColumns(120);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.setWorkDirectory(virtualFile.getParent().getPath());
        commandLine.setExePath(this.myRunConfiguration.getInterpreterPath());
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getInterpreterOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getInterpreterOptions()));
        }
        commandLine.addParameter(this.myRunConfiguration.getScriptPath());
        if (StringUtil.isNotEmpty((String)this.myRunConfiguration.getScriptOptions())) {
            commandLine.addParameters(ParametersListUtil.parse((String)this.myRunConfiguration.getScriptOptions()));
        }
        PtyCommandLine ptyCommandLine = commandLine;
        if (ptyCommandLine == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(4);
        }
        return ptyCommandLine;
    }

    @NotNull
    private String buildCommand() {
        String string = ShStringUtil.quote(this.myRunConfiguration.getInterpreterPath()) + WHITESPACE + this.myRunConfiguration.getInterpreterOptions() + WHITESPACE + ShStringUtil.quote(this.myRunConfiguration.getScriptPath()) + WHITESPACE + this.myRunConfiguration.getScriptOptions() + "\n";
        if (string == null) {
            ShRunConfigurationProfileState.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunConfigurationProfileState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunConfigurationProfileState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

