/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.clones;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.clones.CssDuplicateScope;
import com.intellij.psi.css.inspections.clones.CssDuplicatesConfigurable;
import com.intellij.psi.css.inspections.clones.CssDuplicatesIndexConfiguration;
import com.intellij.psi.css.inspections.clones.CssDuplicatesService;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.clones.configuration.DuplicateIndexConfiguration;
import com.jetbrains.clones.configuration.DuplicateInspectionConfiguration;
import com.jetbrains.clones.core.CommonUtilsKt;
import com.jetbrains.clones.core.LighterAstNodeHashCache;
import com.jetbrains.clones.core.NodeHash;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.languagescope.common.CommonConfigurationUIKt;
import com.jetbrains.clones.languagescope.common.CommonDuplicateInspectionConfiguration;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J.\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0016J\u0018\u00103\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00106\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u001a\u00107\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u00108\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u00109\u001a\u00020/H\u0016J\u0018\u0010:\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006;"}, d2={"Lcom/intellij/psi/css/inspections/clones/CssDuplicateScope;", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "()V", "indexConfiguration", "Lcom/intellij/psi/css/inspections/clones/CssDuplicatesIndexConfiguration;", "getIndexConfiguration", "()Lcom/intellij/psi/css/inspections/clones/CssDuplicatesIndexConfiguration;", "languageName", "", "getLanguageName", "()Ljava/lang/String;", "noiseTokens", "Lcom/intellij/psi/tree/TokenSet;", "getNoiseTokens", "()Lcom/intellij/psi/tree/TokenSet;", "noiseTokens$delegate", "Lkotlin/Lazy;", "valueTokens", "getValueTokens", "valueTokens$delegate", "acceptsFile", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "addSemicolonIfPossible", "Lcom/jetbrains/clones/structures/TextClone;", "textClone", "Lcom/jetbrains/clones/structures/TextFragment;", "fragment", "createConfigurationPanel", "Ljavax/swing/JPanel;", "state", "Lcom/jetbrains/clones/configuration/DuplicateInspectionConfiguration;", "createDefaultConfiguration", "createIndexConfigurable", "Lcom/intellij/openapi/options/Configurable;", "getIndexVersion", "", "hashOf", "", "cache", "Lcom/jetbrains/clones/core/LighterAstNodeHashCache;", "ast", "Lcom/intellij/lang/LighterAST;", "node", "Lcom/intellij/lang/LighterASTNode;", "children", "", "Lcom/jetbrains/clones/core/NodeHash;", "isAnonymized", "Lcom/intellij/lang/LighterASTTokenNode;", "isIgnoredAsDuplicate", "isNoise", "processDuplicate", "shouldAnalyzeChildSubsequences", "parent", "weightOf", "intellij.css.impl"})
public final class CssDuplicateScope
implements DuplicateScope {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final String languageName = "Style Sheets";
    @NotNull
    private final CssDuplicatesIndexConfiguration indexConfiguration = new CssDuplicatesIndexConfiguration(this.getLanguageName());
    private final Lazy noiseTokens$delegate = LazyKt.lazy((Function0)noiseTokens.2.INSTANCE);
    private final Lazy valueTokens$delegate = LazyKt.lazy((Function0)valueTokens.2.INSTANCE);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CssDuplicateScope.class), "noiseTokens", "getNoiseTokens()Lcom/intellij/psi/tree/TokenSet;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CssDuplicateScope.class), "valueTokens", "getValueTokens()Lcom/intellij/psi/tree/TokenSet;"))};
    }

    @NotNull
    public String getLanguageName() {
        return this.languageName;
    }

    @NotNull
    public CssDuplicatesIndexConfiguration getIndexConfiguration() {
        return this.indexConfiguration;
    }

    private final TokenSet getNoiseTokens() {
        Lazy lazy = this.noiseTokens$delegate;
        CssDuplicateScope cssDuplicateScope = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (TokenSet)lazy.getValue();
    }

    public boolean isNoise(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)ast, (String)"ast");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.getNoiseTokens().contains(node.getTokenType());
    }

    private final TokenSet getValueTokens() {
        Lazy lazy = this.valueTokens$delegate;
        CssDuplicateScope cssDuplicateScope = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (TokenSet)lazy.getValue();
    }

    public int getIndexVersion() {
        return 2;
    }

    public boolean acceptsFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return !CssDuplicatesService.getInstance().skipDuplicatesAnalysis(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAnonymized(@NotNull LighterAST ast, @NotNull LighterASTTokenNode node) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)ast, (String)"ast");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        LighterASTNode parent = ast.getParent((LighterASTNode)node);
        LighterASTNode lighterASTNode = parent;
        if (this.getValueTokens().contains((IElementType)(lighterASTNode != null ? lighterASTNode.getTokenType() : null))) {
            bl = this.getIndexConfiguration().getAnonymizeValues();
            return bl;
        } else {
            if (!Intrinsics.areEqual((Object)node.getTokenType(), (Object)CssElementTypes.CSS_IDENT)) return true;
            LighterASTNode lighterASTNode2 = parent;
            if (!(Intrinsics.areEqual((Object)(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null), (Object)CssElementTypes.CSS_DECLARATION_BLOCK) ^ true)) return true;
            bl = this.getIndexConfiguration().getAnonymizeNames();
        }
        return bl;
    }

    public boolean shouldAnalyzeChildSubsequences(@NotNull LighterAST ast, @NotNull LighterASTNode parent) {
        Intrinsics.checkParameterIsNotNull((Object)ast, (String)"ast");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        return Intrinsics.areEqual((Object)parent.getTokenType(), (Object)CssElementTypes.CSS_DECLARATION_BLOCK);
    }

    public boolean isIgnoredAsDuplicate(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)ast, (String)"ast");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return false;
    }

    public int weightOf(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)ast, (String)"ast");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getTokenType();
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)CssElementTypes.CSS_DECLARATION)) ? 1 : 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public long hashOf(@NotNull LighterAstNodeHashCache cache, @NotNull LighterAST ast, @NotNull LighterASTNode node, @NotNull List<? extends NodeHash> children) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        long l;
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        Intrinsics.checkParameterIsNotNull((Object)ast, (String)"ast");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(children, (String)"children");
        if (node instanceof LighterASTTokenNode) {
            l = CommonUtilsKt.hashOf((LighterASTTokenNode)((LighterASTTokenNode)node), (boolean)this.isAnonymized(ast, (LighterASTTokenNode)node));
            return l;
        }
        if (!this.getIndexConfiguration().getAnonymizeValues() && this.getValueTokens().contains(node.getTokenType())) {
            NodeHash nodeHash = (NodeHash)CollectionsKt.firstOrNull(children);
            if ((nodeHash != null ? nodeHash.getNode() : null) instanceof LighterASTTokenNode) {
                String string = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)node, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LightTreeUtil.toFilteredString(ast, node, null)");
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                l = string4.hashCode();
                return l;
            }
        }
        if (!Intrinsics.areEqual((Object)node.getTokenType(), (Object)CssElementTypes.CSS_DECLARATION_BLOCK)) {
            l = super.hashOf(cache, ast, node, children);
            return l;
        }
        Iterable $this$filter$iv = children;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv322 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodeHash it = (NodeHash)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getNode().getTokenType(), (Object)((Object)CssElementTypes.CSS_DECLARATION))) continue;
            destination$iv$iv322.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv322;
        boolean $i$f$sortedBy = false;
        $this$filterTo$iv$iv = $this$sortedBy$iv;
        boolean destination$iv$iv322 = false;
        Comparator $i$f$filterTo22 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                NodeHash it = (NodeHash)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getHash());
                it = (NodeHash)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getHash();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        List declarationNodes = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv, (Comparator)$i$f$filterTo22);
        Iterable $this$filterNot$iv = children;
        boolean $i$f$filterNot = false;
        Iterable destination$iv$iv322 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                List otherNodes = (List)destination$iv$iv;
                return (long)37 * CommonUtilsKt.nodeListHash((List)declarationNodes) + CommonUtilsKt.nodeListHash((List)otherNodes);
            }
            Object element$iv$iv = iterator.next();
            NodeHash it = (NodeHash)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getNode().getTokenType(), (Object)((Object)CssElementTypes.CSS_DECLARATION))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
    }

    @NotNull
    public JPanel createConfigurationPanel(@NotNull DuplicateInspectionConfiguration state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        CommonDuplicateInspectionConfiguration cfr_ignored_0 = (CommonDuplicateInspectionConfiguration)state;
        String string = CssBundle.message((String)"duplicate.settings.css.inspection.measure", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CssBundle.message(\"dupli\u2026.css.inspection.measure\")");
        return CommonConfigurationUIKt.createLanguageOptionsPanel((String)string, (DuplicateIndexConfiguration)this.getIndexConfiguration(), (CommonDuplicateInspectionConfiguration)((CommonDuplicateInspectionConfiguration)state));
    }

    @NotNull
    public Configurable createIndexConfigurable() {
        return new CssDuplicatesConfigurable(this.getLanguageName(), this.getIndexConfiguration());
    }

    @NotNull
    public DuplicateInspectionConfiguration createDefaultConfiguration() {
        return (DuplicateInspectionConfiguration)new CommonDuplicateInspectionConfiguration(10, true);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public TextClone processDuplicate(@NotNull Project project, @NotNull TextClone textClone) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)textClone, (String)"textClone");
        Iterable iterable = textClone.getDuplicates();
        TextFragment textFragment = textClone.getMain();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFragment it = (TextFragment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFile().getFileType(), (Object)textClone.getMain().getFile().getFileType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        TextFragment textFragment2 = textFragment;
        List list = (List)destination$iv$iv;
        List list2 = list;
        TextClone filteredTextClone = new TextClone(textFragment2, list2);
        return filteredTextClone.getDuplicates().isEmpty() ? null : this.addSemicolonIfPossible(project, filteredTextClone);
    }

    /*
     * WARNING - void declaration
     */
    private final TextClone addSemicolonIfPossible(Project project, TextClone textClone) {
        void $this$mapTo$iv$iv;
        TextFragment main = this.addSemicolonIfPossible(project, textClone.getMain());
        if (Intrinsics.areEqual((Object)main, (Object)textClone.getMain())) {
            return textClone;
        }
        Iterable $this$map$iv = textClone.getDuplicates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextFragment textFragment = (TextFragment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TextFragment textFragment2 = this.addSemicolonIfPossible(project, (TextFragment)it);
            collection.add(textFragment2);
        }
        List duplicates = (List)destination$iv$iv;
        return new TextClone(main, duplicates);
    }

    private final TextFragment addSemicolonIfPossible(Project project, TextFragment fragment) {
        TextFragment textFragment;
        Object v2;
        block3: {
            PsiFile file;
            PsiFile psiFile = file = PsiManager.getInstance((Project)project).findFile(fragment.getFile());
            PsiElement endElement = psiFile != null ? psiFile.findElementAt(fragment.getRange().getEndOffset() - 1) : null;
            PsiElement declarationElement2 = PsiTreeUtil.findFirstParent((PsiElement)endElement, (Condition)addSemicolonIfPossible.declarationElement.1.INSTANCE);
            Sequence sequence = SequencesKt.generateSequence((Object)declarationElement2, (Function1)addSemicolonIfPossible.semicolon.1.INSTANCE);
            boolean bl = false;
            Sequence sequence2 = sequence;
            boolean bl2 = false;
            for (Object e : sequence2) {
                PsiElement it = (PsiElement)e;
                boolean bl3 = false;
                ASTNode aSTNode = it.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
                if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)CssElementTypes.CSS_SEMICOLON)) continue;
                v2 = e;
                break block3;
            }
            v2 = null;
        }
        PsiElement semicolon2 = v2;
        if (semicolon2 != null) {
            VirtualFile virtualFile = fragment.getFile();
            int n = fragment.getRange().getStartOffset();
            TextRange textRange = semicolon2.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"semicolon.textRange");
            textFragment = new TextFragment(virtualFile, new TextRange(n, textRange.getEndOffset()));
        } else {
            textFragment = fragment;
        }
        return textFragment;
    }
}

