/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.variables.introspect;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u00a8\u0006\u0005"}, d2={"reformatIntrospectionText", "", "text", "removeColorCodecs", "coloredText", "intellij.python.jupyter"})
public final class JupyterIntrospectionManagerKt {
    @NotNull
    public static final String reformatIntrospectionText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String string = StringUtil.unescapeStringCharacters((String)text);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.unescapeStringCharacters(text)");
        String cleanText = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"\""), (CharSequence)"\"");
        return JupyterIntrospectionManagerKt.removeColorCodecs(cleanText);
    }

    @NotNull
    public static final String removeColorCodecs(@NotNull String coloredText) {
        Intrinsics.checkParameterIsNotNull((Object)coloredText, (String)"coloredText");
        Regex re = new Regex("\u001b\\[[;\\d]*m");
        return re.replace((CharSequence)coloredText, "");
    }
}

