/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.variables.inline;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterFrameValues;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterLineToValueMapper;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\nJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/inline/JupyterInlineVisitor;", "Lcom/jetbrains/python/psi/PyRecursiveElementVisitor;", "document", "Lcom/intellij/openapi/editor/Document;", "frameValues", "Lorg/jetbrains/plugins/notebooks/jupyter/variables/inline/JupyterFrameValues;", "(Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/plugins/notebooks/jupyter/variables/inline/JupyterFrameValues;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "myLineToValueMapper", "Lorg/jetbrains/plugins/notebooks/jupyter/variables/inline/JupyterLineToValueMapper;", "getResult", "visitPyReferenceExpression", "", "node", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "intellij.python.jupyter"})
public final class JupyterInlineVisitor
extends PyRecursiveElementVisitor {
    private final JupyterLineToValueMapper myLineToValueMapper;
    @NotNull
    private final Document document;
    private final JupyterFrameValues frameValues;

    public void visitPyReferenceExpression(@Nullable PyReferenceExpression node) {
        super.visitPyReferenceExpression(node);
        if (node == null) {
            return;
        }
        String string = node.getName();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.name ?: return");
        String nodeName = string;
        PyDebugValue pyDebugValue = this.frameValues.getValue(nodeName);
        if (pyDebugValue == null) {
            return;
        }
        PyDebugValue value = pyDebugValue;
        if (Intrinsics.areEqual((Object)ScopeUtil.getScopeOwner((PsiElement)((PsiElement)node)), (Object)this.frameValues.getScopeOwner()) ^ true) {
            return;
        }
        int textOffset = node.getTextOffset();
        int lineNumber = this.document.getLineNumber(textOffset);
        this.myLineToValueMapper.put(lineNumber, textOffset, value);
    }

    @NotNull
    public final JupyterLineToValueMapper getResult() {
        return this.myLineToValueMapper;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public JupyterInlineVisitor(@NotNull Document document, @NotNull JupyterFrameValues frameValues) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)frameValues, (String)"frameValues");
        this.document = document;
        this.frameValues = frameValues;
        this.myLineToValueMapper = new JupyterLineToValueMapper();
    }
}

