/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.PythonJupyterIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.connections.ConfiguredServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParametersSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.ManagedServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.configuration.JupyterServerConfigurable;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookOfflineSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookRuntimeSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookSessionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.ManagedJupyterServerNotebookSessionSettings;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerExecution;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerFinished;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerService;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarted;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarting;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerState;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStopped;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0014J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterServerChooserAction;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction;", "()V", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "button", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getConnectionPresentationText", "", "module", "Lcom/intellij/openapi/module/Module;", "notebookConnectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterModuleConnectionSettings;", "activeConnectionParameters", "shouldShowSwitchAction", "", "currentSettings", "moduleSettings", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.python.jupyter"})
public final class JupyterServerChooserAction
extends ComboBoxAction {
    private static final Logger LOG;
    private static final Key<Boolean> BUTTON_MODE;
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Module module;
        Module module2;
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        JupyterNotebookRuntimeSettings settings = JupyterActionsKt.getJupyterNotebookRuntimeSettings(e);
        VirtualFile virtualFile3 = virtualFile2 = JupyterActionsKt.getVirtualFile(e);
        if (virtualFile3 != null) {
            VirtualFile virtualFile4 = virtualFile3;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile4;
            boolean bl3 = false;
            module2 = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)project2);
        } else {
            module2 = module = null;
        }
        if (module == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setText("Jupyter file is outside of the module");
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(false);
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
            presentation3.setIcon((Icon)null);
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setIcon(PythonJupyterIcons.StatusBarJupyter);
        JupyterModuleConnectionSettings connectionSettings = JupyterConnectionParametersSettings.Companion.guessConnectionSettings(project2, virtualFile2);
        if (settings == null) {
            Presentation presentation4 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation4, (String)"e.presentation");
            presentation4.setText(this.getConnectionPresentationText(module, connectionSettings, connectionSettings));
            Presentation presentation5 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation5, (String)"e.presentation");
            JupyterServerChooserAction.Companion.setButtonMode(presentation5, false);
        } else {
            Presentation presentation6 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation6, (String)"e.presentation");
            JupyterServerChooserAction.Companion.setButtonMode(presentation6, false);
            settings.accept(new JupyterNotebookRuntimeSettings.Visitor<Unit>(this, e, module, connectionSettings){
                final /* synthetic */ JupyterServerChooserAction this$0;
                final /* synthetic */ AnActionEvent $e;
                final /* synthetic */ Module $module;
                final /* synthetic */ JupyterModuleConnectionSettings $connectionSettings;

                public void visit(@NotNull JupyterNotebookOfflineSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    Presentation presentation = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                    presentation.setText(JupyterServerChooserAction.access$getConnectionPresentationText(this.this$0, this.$module, settings.getConnectionSettings(), this.$connectionSettings));
                }

                public void visit(@NotNull JupyterNotebookSessionSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    Presentation presentation = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                    presentation.setText(JupyterServerChooserAction.access$getConnectionPresentationText(this.this$0, this.$module, settings.getConnectionSettings(), this.$connectionSettings));
                }

                public void visit(@NotNull ManagedJupyterServerNotebookSessionSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    Presentation presentation = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                    presentation.setText(org.jetbrains.plugins.notebooks.jupyter.editor.JupyterServerChooserAction$Companion.access$getJupyterServerExecutionStatusText(JupyterServerChooserAction.Companion, settings.getJupyterServerExecution(), this.$connectionSettings));
                }
                {
                    this.this$0 = $outer;
                    this.$e = $captured_local_variable$1;
                    this.$module = $captured_local_variable$2;
                    this.$connectionSettings = $captured_local_variable$3;
                }
            });
        }
    }

    private final String getConnectionPresentationText(Module module, JupyterModuleConnectionSettings notebookConnectionParameters, JupyterModuleConnectionSettings activeConnectionParameters) {
        String string;
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings = notebookConnectionParameters;
        if (jupyterModuleConnectionSettings instanceof ManagedServerJupyterModuleConnectionSettings) {
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            JupyterServerExecution currentExecution = JupyterServerService.Companion.getInstance(project).getCurrentExecution(module);
            string = JupyterServerChooserAction.Companion.getJupyterServerExecutionStatusText(currentExecution, activeConnectionParameters);
        } else if (jupyterModuleConnectionSettings instanceof ConfiguredServerJupyterModuleConnectionSettings) {
            string = Intrinsics.areEqual((Object)notebookConnectionParameters, (Object)activeConnectionParameters) ? ((ConfiguredServerJupyterModuleConnectionSettings)notebookConnectionParameters).getUrl() : JupyterBundle.message("Jupyter.configured.server.retained", ((ConfiguredServerJupyterModuleConnectionSettings)notebookConnectionParameters).getUrl());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2) {
        Intrinsics.checkParameterIsNotNull((Object)button2, (String)"button");
        throw (Throwable)new IllegalStateException("Should not be called");
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext dataContext) {
        Object object;
        List actionList2;
        VirtualFile virtualFile2;
        Project currentProject;
        block10: {
            block9: {
                Intrinsics.checkParameterIsNotNull((Object)button2, (String)"button");
                Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
                currentProject = JupyterActionsKt.getProject(dataContext);
                virtualFile2 = JupyterActionsKt.getVirtualFile(dataContext);
                if (currentProject == null || virtualFile2 == null) {
                    LOG.error("Illegal state: project=" + currentProject + ", virtual file=" + virtualFile2);
                    return new DefaultActionGroup();
                }
                actionList2 = CollectionsKt.mutableListOf((Object[])new AnAction[]{new AnAction(currentProject, JupyterBundle.message("Jupyter.server.configure", new Object[0])){
                    final /* synthetic */ Project $currentProject;

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        ShowSettingsUtil.getInstance().showSettingsDialog(this.$currentProject, JupyterServerConfigurable.class);
                    }
                    {
                        this.$currentProject = $captured_local_variable$0;
                        super($super_call_param$1);
                    }
                }});
                Module module = FileIndexFacade.getInstance((Project)currentProject).getModuleForFile(virtualFile2);
                object = module;
                if (object == null) break block9;
                Module module2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Module it = module2;
                boolean bl3 = false;
                object = JupyterConnectionParametersSettings.Companion.getConnectionParametersForModule(it);
                if (object != null) break block10;
            }
            object = JupyterConnectionParametersSettings.Companion.getDefaultConnectionParameters();
        }
        Object moduleConnectionParameters = object;
        JupyterRuntimeService jupyterRuntimeService = JupyterRuntimeService.Companion.getInstance(currentProject);
        JupyterNotebookRuntimeSettings runtime = jupyterRuntimeService.getRuntime(virtualFile2);
        if (runtime != null && this.shouldShowSwitchAction(runtime.getConnectionSettings(), (JupyterModuleConnectionSettings)moduleConnectionParameters)) {
            String string;
            Separator separator = Separator.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)separator, (String)"Separator.getInstance()");
            actionList2.add(separator);
            Object object2 = moduleConnectionParameters;
            if (object2 instanceof ManagedServerJupyterModuleConnectionSettings) {
                string = JupyterBundle.message("Jupyter.switch.to.current.managed.server", new Object[0]);
            } else if (object2 instanceof ConfiguredServerJupyterModuleConnectionSettings) {
                string = JupyterBundle.message("Jupyter.switch.to.current.configured.server", ((ConfiguredServerJupyterModuleConnectionSettings)moduleConnectionParameters).getUrl());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String switchActionText = string;
            actionList2.add(new AnAction(jupyterRuntimeService, virtualFile2, switchActionText, switchActionText){
                final /* synthetic */ JupyterRuntimeService $jupyterRuntimeService;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ String $switchActionText;

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.$jupyterRuntimeService.clearRuntime(this.$virtualFile);
                }
                {
                    this.$jupyterRuntimeService = $captured_local_variable$0;
                    this.$virtualFile = $captured_local_variable$1;
                    this.$switchActionText = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            });
        }
        return new DefaultActionGroup(actionList2);
    }

    private final boolean shouldShowSwitchAction(JupyterModuleConnectionSettings currentSettings, JupyterModuleConnectionSettings moduleSettings) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = CollectionsKt.listOf((Object[])new JupyterModuleConnectionSettings[]{currentSettings, moduleSettings});
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JupyterModuleConnectionSettings it = (JupyterModuleConnectionSettings)element$iv;
                    boolean bl2 = false;
                    if (it instanceof ManagedServerJupyterModuleConnectionSettings) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl ? false : Intrinsics.areEqual((Object)moduleSettings, (Object)currentSettings) ^ true;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        ComboBoxAction.ComboBoxButton button2 = new ComboBoxAction.ComboBoxButton(this, presentation, presentation){
            final /* synthetic */ JupyterServerChooserAction this$0;
            final /* synthetic */ Presentation $presentation;

            @NotNull
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = Math.max(d.width, JBUI.scale((int)75));
                Dimension dimension = d;
                Intrinsics.checkExpressionValueIsNotNull((Object)dimension, (String)"d");
                return dimension;
            }

            protected void fireActionPerformed(@NotNull ActionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)this.getText(), (Object)JupyterBundle.message("Jupyter.server.configure", new Object[0]))) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(ProjectUtil.guessCurrentProject((JComponent)((JComponent)((Object)this))), JupyterServerConfigurable.class);
                } else {
                    super.fireActionPerformed(event);
                }
            }

            protected boolean isArrowVisible(@NotNull Presentation presentation) {
                Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
                return !org.jetbrains.plugins.notebooks.jupyter.editor.JupyterServerChooserAction$Companion.access$getButtonMode(JupyterServerChooserAction.Companion, presentation);
            }
            {
                this.this$0 = $outer;
                this.$presentation = $captured_local_variable$1;
                super((ComboBoxAction)$outer, $super_call_param$2);
            }
        };
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JBEmptyBorder jBEmptyBorder = UIUtil.isUnderDefaultMacTheme() ? JBUI.Borders.empty((int)0, (int)2) : JBUI.Borders.empty((int)0, (int)5, (int)0, (int)4);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBEmptyBorder, (String)"if (UIUtil.isUnderDefaul\u2026Borders.empty(0, 5, 0, 4)");
        JBEmptyBorder border = jBEmptyBorder;
        panel2.setBorder((Border)border);
        panel2.add((Component)button2);
        return (JComponent)panel2;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(JupyterServerChooserAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Jupyt\u2026hooserAction::class.java)");
        LOG = logger2;
        Key key = Key.create((String)"ButtonMode");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"ButtonMode\")");
        BUTTON_MODE = key;
    }

    public static final /* synthetic */ String access$getConnectionPresentationText(JupyterServerChooserAction $this, Module module, JupyterModuleConnectionSettings notebookConnectionParameters, JupyterModuleConnectionSettings activeConnectionParameters) {
        return $this.getConnectionPresentationText(module, notebookConnectionParameters, activeConnectionParameters);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\f\u0010\u000e\u001a\u00020\u0005*\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterServerChooserAction$Companion;", "", "()V", "BUTTON_MODE", "Lcom/intellij/openapi/util/Key;", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getJupyterServerExecutionStatusText", "", "execution", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerExecution;", "activeConnectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterModuleConnectionSettings;", "getButtonMode", "Lcom/intellij/openapi/actionSystem/Presentation;", "setButtonMode", "", "value", "intellij.python.jupyter"})
    public static final class Companion {
        private final boolean getButtonMode(@NotNull Presentation $this$getButtonMode) {
            return Intrinsics.areEqual((Object)((Boolean)$this$getButtonMode.getClientProperty(BUTTON_MODE)), (Object)true);
        }

        private final void setButtonMode(@NotNull Presentation $this$setButtonMode, boolean value) {
            $this$setButtonMode.putClientProperty(BUTTON_MODE, (Object)value);
        }

        private final String getJupyterServerExecutionStatusText(JupyterServerExecution execution, JupyterModuleConnectionSettings activeConnectionParameters) {
            Object object = execution;
            if (object == null || (object = object.getState()) == null || (object = (String)object.accept(new JupyterServerState.Visitor<String>(activeConnectionParameters){
                final /* synthetic */ JupyterModuleConnectionSettings $activeConnectionParameters;

                @NotNull
                public String visit(@NotNull JupyterServerStopped state) {
                    Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                    return JupyterBundle.message("Jupyter.managed.server.auto.start", new Object[0]);
                }

                @NotNull
                public String visit(@NotNull JupyterServerStarting state) {
                    Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                    return JupyterBundle.message("Jupyter.managed.server.starting", new Object[0]);
                }

                @NotNull
                public String visit(@NotNull JupyterServerStarted state) {
                    Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                    String urlString = state.getConnectionParameters().getUrlString();
                    return !(this.$activeConnectionParameters instanceof ManagedServerJupyterModuleConnectionSettings) ? JupyterBundle.message("Jupyter.managed.server.running.retained", urlString) : JupyterBundle.message("Jupyter.managed.server.running", urlString);
                }

                @NotNull
                public String visit(@NotNull JupyterServerFinished state) {
                    Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                    return JupyterBundle.message("Jupyter.managed.server.auto.start", new Object[0]);
                }
                {
                    this.$activeConnectionParameters = $captured_local_variable$0;
                }
            })) == null) {
                object = JupyterBundle.message("Jupyter.managed.server.auto.start", new Object[0]);
            }
            return object;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$getButtonMode(Companion $this, Presentation $this$access_u24getButtonMode) {
            return $this.getButtonMode($this$access_u24getButtonMode);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

