/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.formatting.FormattingMode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.editor.PythonBaseFileViewProvider;
import org.jetbrains.plugins.notebooks.jupyter.python.JupyterPyDialect;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "isSuitableFor", "", "intellij.python.jupyter"})
public final class JupyterLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (language == null) {
            return null;
        }
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document2);
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
        if (!(virtualFile2 instanceof JupyterVirtualFile)) {
            virtualFile2 = null;
        }
        JupyterVirtualFile jupyterVirtualFile = (JupyterVirtualFile)virtualFile2;
        if (jupyterVirtualFile == null) {
            return null;
        }
        JupyterVirtualFile virtualFile3 = jupyterVirtualFile;
        FileViewProvider fileViewProvider = PsiManager.getInstance((Project)project).findViewProvider((VirtualFile)virtualFile3);
        if (fileViewProvider == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"PsiManager.getInstance(p\u2026rtualFile) ?: return null");
        FileViewProvider viewProvider = fileViewProvider;
        PsiFile psiFile = new PythonBaseFileViewProvider(viewProvider).getPsi(Intrinsics.areEqual((Object)language, (Object)PythonLanguage.getInstance()) ? (Language)JupyterPyDialect.INSTANCE : language);
        if (psiFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PythonBaseFileViewProvid\u2026uage\n    ) ?: return null");
        PsiFile psiFile2 = psiFile;
        return CodeStyleManager.getInstance((Project)project).getLineIndent(psiFile2, offset, FormattingMode.ADJUST_INDENT_ON_ENTER);
    }

    public boolean isSuitableFor(@Nullable Language language) {
        Language language2 = language;
        return language2 != null && language2.isKindOf((Language)PythonLanguage.INSTANCE);
    }
}

