/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.debugger;

import com.google.common.collect.Sets;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugSessionManager;", "", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "runningSessions", "", "", "awaitTermination", "", "timeout", "", "debugInSessionFinished", "path", "debugInSessionStarted", "getExecutorService", "isSessionUnderDebug", "", "Companion", "intellij.python.jupyter"})
public final class JupyterDebugSessionManager {
    private final Set<String> runningSessions;
    private ExecutorService executorService;
    public static final Companion Companion = new Companion(null);

    public final void debugInSessionStarted(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.runningSessions.add(path);
    }

    public final void debugInSessionFinished(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.runningSessions.remove(path);
    }

    public final boolean isSessionUnderDebug(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.runningSessions.contains(path);
    }

    @NotNull
    public final synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool();
        }
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Intrinsics.throwNpe();
        }
        return executorService;
    }

    public final synchronized void awaitTermination(long timeout) throws InterruptedException {
        if (this.executorService != null) {
            ExecutorService executorService = this.executorService;
            if (executorService == null) {
                Intrinsics.throwNpe();
            }
            executorService.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
    }

    public JupyterDebugSessionManager() {
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"Sets.newConcurrentHashSet()");
        this.runningSessions = set;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugSessionManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugSessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final JupyterDebugSessionManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, JupyterDebugSessionManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ssionManager::class.java)");
            return (JupyterDebugSessionManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

