/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathMapper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.profiler.CallStat;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.VirtualFilesKt;
import com.jetbrains.python.profiler.callgraph.CallGraphView;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u0019\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u001a\u001a\u0016\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0004\"\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"CALL_GRAPH_VIEW", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/jetbrains/python/profiler/callgraph/CallGraphView;", "getCALL_GRAPH_VIEW", "()Lcom/intellij/openapi/actionSystem/DataKey;", "EXEC_STAT", "", "FUNCTION_STAT", "Lcom/jetbrains/python/profiler/FunctionStat;", "getFUNCTION_STAT", "NAVIGATE_TO_SOURCE", "POPUP_ACTIONS", "SHOW_ON_CALL_GRAPH", "findNavigatables", "", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "callStat", "Lcom/jetbrains/python/profiler/CallStat;", "profileStats", "Lcom/intellij/openapi/util/UserDataHolder;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/profiler/CallStat;Lcom/intellij/openapi/util/UserDataHolder;)[Lcom/intellij/pom/Navigatable;", "navigate", "", "navigatables", "([Lcom/intellij/pom/Navigatable;)V", "tryRemap", "file", "intellij.python.profiler"})
public final class ProfilerViewKt {
    @NotNull
    public static final String POPUP_ACTIONS = "PyProfiler.Popup.Actions";
    @NotNull
    public static final String EXEC_STAT = "PyProfiler.ExecutionStats";
    @NotNull
    public static final String NAVIGATE_TO_SOURCE = "PyProfile.NavigateToSource";
    @NotNull
    public static final String SHOW_ON_CALL_GRAPH = "PyProfile.ShowOnCallGraph";
    @NotNull
    private static final DataKey<FunctionStat> FUNCTION_STAT;
    @NotNull
    private static final DataKey<CallGraphView> CALL_GRAPH_VIEW;

    @NotNull
    public static final DataKey<FunctionStat> getFUNCTION_STAT() {
        return FUNCTION_STAT;
    }

    @NotNull
    public static final DataKey<CallGraphView> getCALL_GRAPH_VIEW() {
        return CALL_GRAPH_VIEW;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Navigatable[] findNavigatables(@NotNull Project project, @NotNull CallStat callStat, @NotNull UserDataHolder profileStats) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)callStat, (String)"callStat");
        Intrinsics.checkParameterIsNotNull((Object)profileStats, (String)"profileStats");
        Iterable $this$map$iv = VirtualFilesKt.findSources(project, profileStats, callStat.getFile());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Navigatable navigatable;
            void file2;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile((VirtualFile)file2);
            if (psiFile instanceof PyFile) {
                PyFunction function;
                PyFunction pyFunction = function = ((PyFile)psiFile).findTopLevelFunction(callStat.getName());
                navigatable = pyFunction != null ? (Navigatable)pyFunction : (Navigatable)new OpenFileDescriptor(project, (VirtualFile)file2, callStat.getLine(), 0);
            } else {
                navigatable = null;
            }
            Navigatable navigatable2 = navigatable;
            collection.add(navigatable2);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Navigatable[] navigatableArray = thisCollection$iv.toArray(new Navigatable[0]);
        if (navigatableArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return navigatableArray;
    }

    @NotNull
    public static final String tryRemap(@NotNull String file2, @NotNull UserDataHolder profileStats) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)profileStats, (String)"profileStats");
        PathMapper pathMappings = (PathMapper)profileStats.getUserData(PythonRemoteInterpreterManager.PATH_MAPPING_SETTINGS_KEY);
        if (pathMappings != null) {
            String string = pathMappings.convertToLocal(file2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathMappings.convertToLocal(file)");
            return string;
        }
        return file2;
    }

    public static final void navigate(@NotNull Navigatable[] navigatables) {
        Intrinsics.checkParameterIsNotNull((Object)navigatables, (String)"navigatables");
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(navigatables){
            final /* synthetic */ Navigatable[] $navigatables;

            public final void run() {
                for (Navigatable navigatable : this.$navigatables) {
                    if (!navigatable.canNavigate()) continue;
                    navigatable.navigate(true);
                    break;
                }
            }
            {
                this.$navigatables = navigatableArray;
            }
        });
    }

    static {
        DataKey dataKey = DataKey.create((String)"FunctionStat");
        Intrinsics.checkExpressionValueIsNotNull((Object)dataKey, (String)"DataKey.create<FunctionStat>(\"FunctionStat\")");
        FUNCTION_STAT = dataKey;
        DataKey dataKey2 = DataKey.create((String)"CallGraphView");
        Intrinsics.checkExpressionValueIsNotNull((Object)dataKey2, (String)"DataKey.create<CallGraphView>(\"CallGraphView\")");
        CALL_GRAPH_VIEW = dataKey2;
    }
}

