/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.profiler.BinaryProcessHandler;
import com.jetbrains.python.profiler.BinaryProcessOutput;
import com.jetbrains.python.profiler.ProfileReaderKt;
import com.jetbrains.python.profiler.ProfileStatData;
import com.jetbrains.python.profiler.ProfileStats;
import com.jetbrains.python.profiler.ProfilerCommunicationKt;
import com.jetbrains.python.profiler.ProfilerLogKt;
import com.jetbrains.python.profiler.ProfilerResponse;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a/\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\n\u001a-\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"buildLoadPstatCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sdkPath", "", "filePath", "loadProfileFromFile", "Lcom/jetbrains/python/profiler/ProfileStatData;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/lang/String;Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/jetbrains/python/profiler/ProfileStatData;", "openProfile", "Lcom/jetbrains/python/profiler/ProfileStats;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "file", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/jetbrains/python/profiler/ProfileStats;", "intellij.python.profiler"})
public final class ProfileReaderKt {
    @Nullable
    public static final ProfileStats openProfile(@Nullable Sdk sdk, @NotNull String file2, @NotNull VirtualFile[] roots) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        if (sdk != null) {
            ProfileStatData stats = ProfileReaderKt.loadProfileFromFile(sdk.getHomePath(), file2, roots);
            if (stats != null) {
                return stats;
            }
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)openProfile.1.INSTANCE);
        }
        return null;
    }

    @Nullable
    public static final ProfileStatData loadProfileFromFile(@Nullable String sdkPath, @Nullable String filePath, @NotNull VirtualFile[] roots) {
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        if (sdkPath == null || filePath == null) {
            return null;
        }
        GeneralCommandLine cmd = ProfileReaderKt.buildLoadPstatCommandLine(sdkPath, filePath);
        PythonEnvUtil.resetHomePathChanges((String)sdkPath, (Map)cmd.getEnvironment());
        BinaryProcessHandler processHandler = new BinaryProcessHandler(cmd);
        BinaryProcessOutput po = processHandler.runProcess();
        if (po.getExitCode() == 0) {
            try {
                ProfilerResponse response = ProfilerCommunicationKt.readResponseFromArray(po.getBinaryOutput());
                return new ProfileStatData(response.getYstats(), response.getTree_stats(), roots);
            }
            catch (Exception e) {
                byte[] byArray = po.getBinaryOutput();
                Charset charset = Charsets.UTF_8;
                StringBuilder stringBuilder = new StringBuilder().append("Error parsing profiler output:\n");
                Logger logger = ProfilerLogKt.getLOG();
                boolean bl = false;
                boolean bl2 = false;
                String string = new String(byArray, charset);
                logger.error(stringBuilder.append(string).append("\n\n").toString(), (Throwable)e);
                UIUtil.invokeLaterIfNeeded((Runnable)loadProfileFromFile.1.INSTANCE);
                return null;
            }
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(po){
            final /* synthetic */ BinaryProcessOutput $po;

            public final void run() {
                String string = this.$po.getProcessOutput().getStderr();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"po.processOutput.stderr");
                String error = string;
                if (StringsKt.contains$default((CharSequence)error, (CharSequence)"ValueError: bad marshal data (unknown type code)", (boolean)false, (int)2, null)) {
                    Messages.showErrorDialog((String)"Not a snapshot file or snapshot has been probably captured using different version of Python", (String)"Incorrect Snapshot Format");
                } else {
                    ProfilerLogKt.getLOG().error(error);
                    Messages.showErrorDialog((String)("Exit code: " + this.$po.getExitCode()), (String)"Error Opening Snapshot");
                }
            }
            {
                this.$po = binaryProcessOutput;
            }
        });
        return null;
    }

    private static final GeneralCommandLine buildLoadPstatCommandLine(String sdkPath, String filePath) {
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{sdkPath});
        ParamsGroup paramsGroup = cmd.getParametersList().addParamsGroup("Script");
        Intrinsics.checkExpressionValueIsNotNull((Object)paramsGroup, (String)"cmd.parametersList.addPa\u2026ndLineState.GROUP_SCRIPT)");
        ParamsGroup scriptParamsGroup = paramsGroup;
        PythonHelper.LOAD_PSTAT.addToGroup(scriptParamsGroup, cmd);
        scriptParamsGroup.addParameter(filePath);
        boolean bl = false;
        Map map = cmd.getEnvironment();
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList();
        PythonSdkFlavor.initPythonPath((Map)map, (boolean)bl, (Collection)arrayList);
        PythonSdkType.patchCommandLineForVirtualenv((GeneralCommandLine)cmd, (String)sdkPath, (boolean)true);
        return cmd;
    }
}

