/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class ModuleFixtureBuilderImpl<T extends ModuleFixture>
implements ModuleFixtureBuilder<T> {
    private static int ourIndex;
    private final NotNullProducer<? extends ModuleType> myModuleTypeProducer;
    protected final List<String> myContentRoots;
    protected final List<String> mySourceRoots;
    protected final TestFixtureBuilder<? extends IdeaProjectTestFixture> myFixtureBuilder;
    private T myModuleFixture;
    protected String myOutputPath;
    protected String myTestOutputPath;

    public ModuleFixtureBuilderImpl(@NotNull ModuleType moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        if (moduleType == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(0);
        }
        this.myContentRoots = new SmartList();
        this.mySourceRoots = new SmartList();
        this.myModuleTypeProducer = () -> moduleType;
        this.myFixtureBuilder = fixtureBuilder;
    }

    public ModuleFixtureBuilderImpl(@NotNull NotNullProducer<? extends ModuleType> moduleTypeProducer, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        if (moduleTypeProducer == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(1);
        }
        this.myContentRoots = new SmartList();
        this.mySourceRoots = new SmartList();
        this.myModuleTypeProducer = moduleTypeProducer;
        this.myFixtureBuilder = fixtureBuilder;
    }

    @Override
    @NotNull
    public ModuleFixtureBuilder<T> addContentRoot(@NotNull String contentRootPath) {
        if (contentRootPath == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(2);
        }
        this.myContentRoots.add(contentRootPath);
        ModuleFixtureBuilderImpl moduleFixtureBuilderImpl = this;
        if (moduleFixtureBuilderImpl == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(3);
        }
        return moduleFixtureBuilderImpl;
    }

    @Override
    @NotNull
    public ModuleFixtureBuilder<T> addSourceRoot(@NotNull String sourceRootPath) {
        if (sourceRootPath == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(4);
        }
        Assert.assertFalse((String)"content root should be added first", (boolean)this.myContentRoots.isEmpty());
        this.mySourceRoots.add(sourceRootPath);
        ModuleFixtureBuilderImpl moduleFixtureBuilderImpl = this;
        if (moduleFixtureBuilderImpl == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(5);
        }
        return moduleFixtureBuilderImpl;
    }

    @Override
    public void setOutputPath(@NotNull String outputPath) {
        if (outputPath == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(6);
        }
        this.myOutputPath = outputPath;
    }

    @Override
    public void setTestOutputPath(@NotNull String outputPath) {
        if (outputPath == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(7);
        }
        this.myTestOutputPath = outputPath;
    }

    @NotNull
    protected Module createModule() {
        Project project2 = this.myFixtureBuilder.getFixture().getProject();
        Assert.assertNotNull((Object)project2);
        String moduleFilePath = PathUtil.getParentPath((String)project2.getBasePath()) + "/" + ModuleFixtureBuilderImpl.getNextIndex() + ".iml";
        Module module2 = ModuleManager.getInstance((Project)project2).newModule(moduleFilePath, ((ModuleType)this.myModuleTypeProducer.produce()).getId());
        if (module2 == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(8);
        }
        return module2;
    }

    private static int getNextIndex() {
        return ourIndex++;
    }

    @Override
    @NotNull
    public synchronized T getFixture() {
        if (this.myModuleFixture == null) {
            this.myModuleFixture = this.instantiateFixture();
        }
        T t = this.myModuleFixture;
        if (t == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(9);
        }
        return t;
    }

    @Override
    public void addSourceContentRoot(@NotNull String path) {
        if (path == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(10);
        }
        this.addContentRoot(path);
        this.addSourceRoot(path);
    }

    @NotNull
    protected abstract T instantiateFixture();

    @NotNull
    Module buildModule() {
        Module[] module2 = new Module[1];
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myFixtureBuilder.getFixture().getProject()).mergeRootsChangesDuring(() -> {
            module2[0] = this.createModule();
            this.initModule(module2[0]);
        }));
        Module module3 = module2[0];
        if (module3 == null) {
            ModuleFixtureBuilderImpl.$$$reportNull$$$0(11);
        }
        return module3;
    }

    protected void initModule(Module module2) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        try {
            for (String contentRoot : this.myContentRoots) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(contentRoot);
                Assert.assertNotNull((String)("cannot find content root: " + contentRoot), (Object)virtualFile);
                ContentEntry contentEntry = rootModel.addContentEntry(virtualFile);
                for (String sourceRoot : this.mySourceRoots) {
                    VirtualFile file;
                    String s = contentRoot + "/" + sourceRoot;
                    VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(s);
                    if (vf == null && (file = LocalFileSystem.getInstance().refreshAndFindFileByPath(sourceRoot)) != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)false)) {
                        vf = file;
                    }
                    if (vf != null) {
                        contentEntry.addSourceFolder(vf, false);
                        continue;
                    }
                    contentEntry.addSourceFolder(VfsUtilCore.pathToUrl((String)s), false);
                }
            }
            this.setupRootModel(rootModel);
        }
        catch (Throwable e) {
            rootModel.dispose();
            throw e;
        }
        rootModel.commit();
    }

    protected void setupRootModel(ModifiableRootModel rootModel) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypeProducer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootPath";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/ModuleFixtureBuilderImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/ModuleFixtureBuilderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addContentRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixture";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addContentRoot";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setOutputPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTestOutputPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addSourceContentRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

