/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.coffeescript.CoffeeScriptDocStringUtil;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptInjectionUtil {
    public static void injectInDocString(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element, @NotNull Language language) {
        if (registrar == null) {
            CoffeeScriptInjectionUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CoffeeScriptInjectionUtil.$$$reportNull$$$0(1);
        }
        if (language == null) {
            CoffeeScriptInjectionUtil.$$$reportNull$$$0(2);
        }
        List<TextRange> ranges = CoffeeScriptDocStringUtil.getDocStringValue(element.getText());
        registrar = registrar.startInjecting(language);
        for (TextRange range : ranges) {
            registrar = registrar.addPlace(null, null, (PsiLanguageInjectionHost)element, range);
        }
        registrar.doneInjecting();
        InjectedLanguageUtil.putInjectedFileUserData((PsiElement)element, (Language)language, (Key)InjectedLanguageUtil.FRANKENSTEIN_INJECTION, (Object)Boolean.TRUE);
    }

    public static void injectInString(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element, @NotNull Language language) {
        if (registrar == null) {
            CoffeeScriptInjectionUtil.$$$reportNull$$$0(3);
        }
        if (element == null) {
            CoffeeScriptInjectionUtil.$$$reportNull$$$0(4);
        }
        if (language == null) {
            CoffeeScriptInjectionUtil.$$$reportNull$$$0(5);
        }
        registrar = registrar.startInjecting(language);
        ASTNode node = element.getNode();
        boolean inInterpolation = false;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == CoffeeScriptTokenTypes.INTERPOLATION_START) {
                inInterpolation = true;
            }
            if (!inInterpolation) {
                int startOffsetInParent = child.getStartOffset() - element.getNode().getStartOffset();
                TextRange range = new TextRange(startOffsetInParent, startOffsetInParent + child.getTextLength());
                registrar = registrar.addPlace(null, null, (PsiLanguageInjectionHost)element, range);
            }
            if (child.getElementType() != CoffeeScriptTokenTypes.INTERPOLATION_END) continue;
            inInterpolation = false;
        }
        registrar.doneInjecting();
        InjectedLanguageUtil.putInjectedFileUserData((PsiElement)element, (Language)language, (Key)InjectedLanguageUtil.FRANKENSTEIN_INJECTION, (Object)Boolean.TRUE);
    }

    public static boolean willInjectSql(@NotNull PsiElement element) {
        String text;
        if (element == null) {
            CoffeeScriptInjectionUtil.$$$reportNull$$$0(6);
        }
        return (text = StringUtil.toLowerCase((String)element.getText().trim())).contains("select") && text.contains("from") || text.contains("update") && text.contains("set") && PsiTreeUtil.getChildrenOfType((PsiElement)element, OuterLanguageElement.class) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "org/coffeescript/lang/injection/CoffeeScriptInjectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "injectInDocString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "injectInString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "willInjectSql";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

