/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.storage;

import com.intellij.openapi.application.PathManager;
import com.intellij.stats.storage.FilePathProvider;
import com.intellij.stats.storage.UniqueFilesProvider;
import java.io.File;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f*\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000bH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/stats/storage/UniqueFilesProvider;", "Lcom/intellij/stats/storage/FilePathProvider;", "baseFileName", "", "rootDirectoryPath", "logsDirectoryName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "cleanupOldFiles", "", "getDataFiles", "", "Ljava/io/File;", "getStatsDataDirectory", "getUniqueFile", "filesOnly", "Lkotlin/sequences/Sequence;", "getChunkNumber", "", "isIntConvertable", "", "Companion", "intellij.statsCollector"})
public class UniqueFilesProvider
extends FilePathProvider {
    private final String baseFileName;
    private final String rootDirectoryPath;
    private final String logsDirectoryName;
    public static final int MAX_ALLOWED_SEND_SIZE = 0x200000;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanupOldFiles() {
        void $this$fold$iv;
        List<File> files2 = this.getDataFiles();
        Iterable iterable = files2;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void file;
            File file2 = (File)element$iv;
            long totalSize = accumulator$iv;
            boolean bl = false;
            accumulator$iv = totalSize + file.length();
        }
        long sizeToSend = accumulator$iv;
        if (sizeToSend > (long)0x200000) {
            long fileSize;
            Iterator<File> iterator = files2.iterator();
            for (long currentSize = sizeToSend; iterator.hasNext() && currentSize > (long)0x200000; currentSize -= fileSize) {
                File file = iterator.next();
                fileSize = file.length();
                Files.delete(file.toPath());
            }
        }
    }

    @Override
    @NotNull
    public File getUniqueFile() {
        File dir = this.getStatsDataDirectory();
        Integer currentMaxIndex2 = (Integer)SequencesKt.max((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(this.filesOnly(dir), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ UniqueFilesProvider this$0;

            public final boolean invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                return StringsKt.startsWith$default((String)string, (String)UniqueFilesProvider.access$getBaseFileName$p(this.this$0), (boolean)false, (int)2, null);
            }
            {
                this.this$0 = uniqueFilesProvider;
                super(1);
            }
        })), (Function1)getUniqueFile.currentMaxIndex.2.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ UniqueFilesProvider this$0;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return UniqueFilesProvider.access$isIntConvertable(this.this$0, it);
            }
            {
                this.this$0 = uniqueFilesProvider;
                super(1);
            }
        })), (Function1)getUniqueFile.currentMaxIndex.4.INSTANCE));
        int newIndex = currentMaxIndex2 != null ? currentMaxIndex2 + 1 : 0;
        return new File(dir, this.baseFileName + '_' + newIndex);
    }

    @Override
    @NotNull
    public List<File> getDataFiles() {
        File dir = this.getStatsDataDirectory();
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.filter(this.filesOnly(dir), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ UniqueFilesProvider this$0;

            public final boolean invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                return StringsKt.startsWith$default((String)string, (String)UniqueFilesProvider.access$getBaseFileName$p(this.this$0), (boolean)false, (int)2, null);
            }
            {
                this.this$0 = uniqueFilesProvider;
                super(1);
            }
        })), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ UniqueFilesProvider this$0;

            public final boolean invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                return UniqueFilesProvider.access$isIntConvertable(this.this$0, StringsKt.substringAfter$default((String)string, (char)'_', null, (int)2, null));
            }
            {
                this.this$0 = uniqueFilesProvider;
                super(1);
            }
        }));
        boolean $i$f$sortedBy = false;
        Sequence sequence = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(this){
            final /* synthetic */ UniqueFilesProvider this$0;
            {
                this.this$0 = uniqueFilesProvider;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(UniqueFilesProvider.access$getChunkNumber(this.this$0, it));
                it = (File)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = UniqueFilesProvider.access$getChunkNumber(this.this$0, it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator));
    }

    @Override
    @NotNull
    public File getStatsDataDirectory() {
        File dir = new File(this.rootDirectoryPath, this.logsDirectoryName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private final int getChunkNumber(@NotNull File $this$getChunkNumber) {
        String string = $this$getChunkNumber.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.name");
        String string2 = StringsKt.substringAfter$default((String)string, (char)'_', null, (int)2, null);
        boolean bl = false;
        return Integer.parseInt(string2);
    }

    private final boolean isIntConvertable(@NotNull String $this$isIntConvertable) {
        boolean bl;
        try {
            String string = $this$isIntConvertable;
            boolean bl2 = false;
            Integer.parseInt(string);
            bl = true;
        }
        catch (NumberFormatException e) {
            bl = false;
        }
        return bl;
    }

    private final Sequence<File> filesOnly(@NotNull File $this$filesOnly) {
        Object[] files2 = $this$filesOnly.listFiles(filesOnly.files.1.INSTANCE);
        if (files2 == null) {
            String diagnostics = !$this$filesOnly.exists() ? "file does not exist" : (!$this$filesOnly.isDirectory() ? "file is not a directory" : ($this$filesOnly.isFile() ? "file should be a directory but it is a file" : "unknown error"));
            throw (Throwable)new Exception("Invalid directory path: " + FilesKt.relativeTo((File)$this$filesOnly, (File)new File(PathManager.getSystemPath())) + ". Info: " + diagnostics);
        }
        return ArraysKt.asSequence((Object[])files2);
    }

    public UniqueFilesProvider(@NotNull String baseFileName, @NotNull String rootDirectoryPath, @NotNull String logsDirectoryName) {
        Intrinsics.checkParameterIsNotNull((Object)baseFileName, (String)"baseFileName");
        Intrinsics.checkParameterIsNotNull((Object)rootDirectoryPath, (String)"rootDirectoryPath");
        Intrinsics.checkParameterIsNotNull((Object)logsDirectoryName, (String)"logsDirectoryName");
        this.baseFileName = baseFileName;
        this.rootDirectoryPath = rootDirectoryPath;
        this.logsDirectoryName = logsDirectoryName;
    }

    public static final /* synthetic */ String access$getBaseFileName$p(UniqueFilesProvider $this) {
        return $this.baseFileName;
    }

    public static final /* synthetic */ boolean access$isIntConvertable(UniqueFilesProvider $this, String $this$access_u24isIntConvertable) {
        return $this.isIntConvertable($this$access_u24isIntConvertable);
    }

    public static final /* synthetic */ int access$getChunkNumber(UniqueFilesProvider $this, File $this$access_u24getChunkNumber) {
        return $this.getChunkNumber($this$access_u24getChunkNumber);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/stats/storage/UniqueFilesProvider$Companion;", "", "()V", "MAX_ALLOWED_SEND_SIZE", "", "intellij.statsCollector"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

