/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.openapi.Disposable;
import com.intellij.stats.completion.CompletionFileLogger;
import com.intellij.stats.completion.CompletionFileLoggerProviderKt;
import com.intellij.stats.completion.CompletionLogger;
import com.intellij.stats.completion.CompletionLoggerProvider;
import com.intellij.stats.completion.InstallationIdProvider;
import com.intellij.stats.logger.ClientSessionValidator;
import com.intellij.stats.logger.EventLoggerWithValidation;
import com.intellij.stats.logger.LogFileManager;
import com.intellij.stats.storage.FilePathProvider;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/stats/completion/CompletionFileLoggerProvider;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/stats/completion/CompletionLoggerProvider;", "filePathProvider", "Lcom/intellij/stats/storage/FilePathProvider;", "installationIdProvider", "Lcom/intellij/stats/completion/InstallationIdProvider;", "(Lcom/intellij/stats/storage/FilePathProvider;Lcom/intellij/stats/completion/InstallationIdProvider;)V", "eventLogger", "Lcom/intellij/stats/logger/EventLoggerWithValidation;", "dispose", "", "newCompletionLogger", "Lcom/intellij/stats/completion/CompletionLogger;", "intellij.statsCollector"})
public final class CompletionFileLoggerProvider
extends CompletionLoggerProvider
implements Disposable {
    private final EventLoggerWithValidation eventLogger;
    private final InstallationIdProvider installationIdProvider;

    @Override
    public void dispose() {
        this.eventLogger.dispose();
    }

    @Override
    @NotNull
    public CompletionLogger newCompletionLogger() {
        String installationUID = this.installationIdProvider.installationId();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        String completionUID = string;
        return new CompletionFileLogger(CompletionFileLoggerProviderKt.access$shortedUUID(installationUID), CompletionFileLoggerProviderKt.access$shortedUUID(completionUID), this.eventLogger);
    }

    public CompletionFileLoggerProvider(@NotNull FilePathProvider filePathProvider, @NotNull InstallationIdProvider installationIdProvider) {
        Intrinsics.checkParameterIsNotNull((Object)filePathProvider, (String)"filePathProvider");
        Intrinsics.checkParameterIsNotNull((Object)installationIdProvider, (String)"installationIdProvider");
        this.installationIdProvider = installationIdProvider;
        this.eventLogger = new EventLoggerWithValidation(new LogFileManager(filePathProvider), new ClientSessionValidator());
    }
}

