/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency;

import com.intellij.util.containers.hash.HashMap;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyConcurrencyService;
import com.jetbrains.python.debugger.concurrency.PyConcurrencySessionData;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphModel;
import org.jetbrains.annotations.NotNull;

public class PyConcurrencyServiceImpl
extends PyConcurrencyService {
    @NotNull
    private final HashMap<XDebugSession, PyConcurrencySessionData> mySessions;
    @NotNull
    private final Object mySessionsObject = new Object();

    private PyConcurrencyServiceImpl() {
        this.mySessions = new HashMap();
    }

    public ConcurrencyGraphModel getThreadingInstance(@NotNull XDebugSession session) {
        if (session == null) {
            PyConcurrencyServiceImpl.$$$reportNull$$$0(0);
        }
        return this.getSessionData(session).getThreadingGraphModel();
    }

    public ConcurrencyGraphModel getAsyncioInstance(@NotNull XDebugSession session) {
        if (session == null) {
            PyConcurrencyServiceImpl.$$$reportNull$$$0(1);
        }
        return this.getSessionData(session).getAsyncioGraphModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PyConcurrencySessionData getSessionData(@NotNull XDebugSession session) {
        if (session == null) {
            PyConcurrencyServiceImpl.$$$reportNull$$$0(2);
        }
        Object object = this.mySessionsObject;
        // MONITORENTER : object
        if (!this.mySessions.containsKey((Object)session)) {
            this.initSession(session);
        }
        PyConcurrencySessionData pyConcurrencySessionData = (PyConcurrencySessionData)this.mySessions.get((Object)session);
        // MONITOREXIT : object
        if (pyConcurrencySessionData != null) return pyConcurrencySessionData;
        PyConcurrencyServiceImpl.$$$reportNull$$$0(3);
        return pyConcurrencySessionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSession(@NotNull XDebugSession session) {
        if (session == null) {
            PyConcurrencyServiceImpl.$$$reportNull$$$0(4);
        }
        PyConcurrencySessionData sessionData = new PyConcurrencySessionData();
        sessionData.getThreadingGraphModel().initNewSession(session);
        sessionData.getAsyncioGraphModel().initNewSession(session);
        Object object = this.mySessionsObject;
        synchronized (object) {
            this.mySessions.put((Object)session, (Object)sessionData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(@NotNull XDebugSession session) {
        if (session == null) {
            PyConcurrencyServiceImpl.$$$reportNull$$$0(5);
        }
        Object object = this.mySessionsObject;
        synchronized (object) {
            this.mySessions.remove((Object)session);
        }
    }

    public void recordEvent(@NotNull XDebugSession session, @NotNull PyConcurrencyEvent event, boolean isAsyncIo) {
        if (session == null) {
            PyConcurrencyServiceImpl.$$$reportNull$$$0(6);
        }
        if (event == null) {
            PyConcurrencyServiceImpl.$$$reportNull$$$0(7);
        }
        PyConcurrencySessionData data = this.getSessionData(session);
        if (!isAsyncIo) {
            data.getThreadingGraphModel().recordEvent(event);
        } else {
            data.getAsyncioGraphModel().recordEvent(event);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/concurrency/PyConcurrencyServiceImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/concurrency/PyConcurrencyServiceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThreadingInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncioInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSessionData";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initSession";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeSession";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "recordEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

