/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project.roots;

import com.intellij.lang.puppet.project.PuppetProjectModel;
import com.intellij.lang.puppet.project.roots.PuppetDirectoryInfo;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetRootIndex {
    private final InfoCache myInfoCache;
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();

    public PuppetRootIndex(@NotNull Project project) {
        if (project == null) {
            PuppetRootIndex.$$$reportNull$$$0(0);
        }
        this.myInfoCache = new InfoCache();
        DirectoryIndex directoryIndex = DirectoryIndex.getInstance((Project)project);
        for (VirtualFile root : PuppetProjectModel.getInstance(project).getAllRoots()) {
            this.cacheInfos(root, root, PuppetRootIndex.calcDirectoryInfo(directoryIndex, root));
        }
    }

    @NotNull
    private static PuppetDirectoryInfo calcDirectoryInfo(@NotNull DirectoryIndex directoryIndex, @NotNull VirtualFile virtualFile) {
        DirectoryInfo baseDirectoryInfo;
        if (directoryIndex == null) {
            PuppetRootIndex.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            PuppetRootIndex.$$$reportNull$$$0(2);
        }
        if (!(baseDirectoryInfo = directoryIndex.getInfoForFile(virtualFile)).isInProject(virtualFile) || baseDirectoryInfo.isIgnored() || baseDirectoryInfo.isExcluded(virtualFile)) {
            PuppetDirectoryInfo puppetDirectoryInfo = PuppetDirectoryInfo.UNAVAILABLE;
            if (puppetDirectoryInfo == null) {
                PuppetRootIndex.$$$reportNull$$$0(3);
            }
            return puppetDirectoryInfo;
        }
        PuppetDirectoryInfo puppetDirectoryInfo = new PuppetDirectoryInfo(virtualFile);
        if (puppetDirectoryInfo == null) {
            PuppetRootIndex.$$$reportNull$$$0(4);
        }
        return puppetDirectoryInfo;
    }

    boolean resetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PuppetRootIndex.$$$reportNull$$$0(5);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file != null && !file.isDirectory()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PuppetDirectoryInfo getInfoForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            PuppetRootIndex.$$$reportNull$$$0(6);
        }
        if (!file.isValid()) {
            PuppetDirectoryInfo puppetDirectoryInfo = PuppetDirectoryInfo.UNAVAILABLE;
            if (puppetDirectoryInfo == null) {
                PuppetRootIndex.$$$reportNull$$$0(7);
            }
            return puppetDirectoryInfo;
        }
        if (!file.isDirectory()) {
            PuppetDirectoryInfo info = this.myInfoCache.getCachedInfo(file);
            if (info != null) {
                PuppetDirectoryInfo puppetDirectoryInfo = info;
                if (puppetDirectoryInfo == null) {
                    PuppetRootIndex.$$$reportNull$$$0(8);
                }
                return puppetDirectoryInfo;
            }
            if (ourFileTypes.isFileIgnored(file)) {
                PuppetDirectoryInfo puppetDirectoryInfo = PuppetDirectoryInfo.UNAVAILABLE;
                if (puppetDirectoryInfo == null) {
                    PuppetRootIndex.$$$reportNull$$$0(9);
                }
                return puppetDirectoryInfo;
            }
            dir = file.getParent();
        } else {
            dir = file;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            PuppetDirectoryInfo info = this.myInfoCache.getCachedInfo(root);
            if (info != null) {
                if (!dir.equals(root)) {
                    this.cacheInfos(dir, root, info);
                }
                PuppetDirectoryInfo puppetDirectoryInfo = info;
                if (puppetDirectoryInfo == null) {
                    PuppetRootIndex.$$$reportNull$$$0(10);
                }
                return puppetDirectoryInfo;
            }
            if (!ourFileTypes.isFileIgnored(root)) continue;
            PuppetDirectoryInfo puppetDirectoryInfo = this.cacheInfos(dir, root, PuppetDirectoryInfo.UNAVAILABLE);
            if (puppetDirectoryInfo == null) {
                PuppetRootIndex.$$$reportNull$$$0(11);
            }
            return puppetDirectoryInfo;
        }
        PuppetDirectoryInfo puppetDirectoryInfo = this.cacheInfos(dir, null, PuppetDirectoryInfo.UNAVAILABLE);
        if (puppetDirectoryInfo == null) {
            PuppetRootIndex.$$$reportNull$$$0(12);
        }
        return puppetDirectoryInfo;
    }

    @NotNull
    private PuppetDirectoryInfo cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull PuppetDirectoryInfo info) {
        if (info == null) {
            PuppetRootIndex.$$$reportNull$$$0(13);
        }
        while (dir != null) {
            this.myInfoCache.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        PuppetDirectoryInfo puppetDirectoryInfo = info;
        if (puppetDirectoryInfo == null) {
            PuppetRootIndex.$$$reportNull$$$0(14);
        }
        return puppetDirectoryInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/roots/PuppetRootIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/roots/PuppetRootIndex";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDirectoryInfo";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcDirectoryInfo";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resetOnEvents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cacheInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InfoCache {
        private final IntObjectMap<PuppetDirectoryInfo> myInfoCache = ContainerUtil.createConcurrentIntObjectMap();

        private InfoCache() {
        }

        public void cacheInfo(@NotNull VirtualFile dir, @NotNull PuppetDirectoryInfo info) {
            if (dir == null) {
                InfoCache.$$$reportNull$$$0(0);
            }
            if (info == null) {
                InfoCache.$$$reportNull$$$0(1);
            }
            this.myInfoCache.put(((NewVirtualFile)dir).getId(), (Object)info);
        }

        public PuppetDirectoryInfo getCachedInfo(@NotNull VirtualFile dir) {
            if (dir == null) {
                InfoCache.$$$reportNull$$$0(2);
            }
            return (PuppetDirectoryInfo)this.myInfoCache.get(((NewVirtualFile)dir).getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/puppet/project/roots/PuppetRootIndex$InfoCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cacheInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCachedInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

