/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactory;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.VagrantSupport;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsManager;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserForm;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.remote.PyCreateRemoteInterpreterDialog;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyDeploymentBasedProjectSynchronizer;
import com.jetbrains.python.remote.PyEditRemoteInterpreterDialog;
import com.jetbrains.python.remote.PyHelpersDownload;
import com.jetbrains.python.remote.PyHelpersUpload;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyProjectSynchronizerProvider;
import com.jetbrains.python.remote.PyRemoteFilesChooser;
import com.jetbrains.python.remote.PyRemoteInterpreterFactory;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteProcessUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PyRemoteSdkEditor;
import com.jetbrains.python.remote.PyRemoteSkeletonGeneratorFactory;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProviderFactory;
import com.jetbrains.python.remote.PySshCommandLineStateUtil;
import com.jetbrains.python.remote.PySshProjectSynchronizer;
import com.jetbrains.python.remote.PyUnknownProjectSynchronizer;
import com.jetbrains.python.remote.PyVagrantProjectSynchronizer;
import com.jetbrains.python.remote.PyWebDeploymentProjectSynchronizer;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.remote.console.PyRemoteConsoleProcessHandler;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import java.awt.Component;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRemoteInterpreterManagerImpl
extends PythonRemoteInterpreterManager
implements RemoteSdkFactory<PyRemoteSdkAdditionalData> {
    public static final String PYTHON_PREFIX = "python";
    private final PyRemoteInterpreterFactory myRemoteInterpreterFactory = new PyRemoteInterpreterFactory();

    public ProcessHandler startRemoteProcess(@Nullable Project project, @NotNull PyRemoteSdkCredentials data, @NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper) throws RemoteSdkException {
        if (data == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        return PyRemoteInterpreterManagerImpl.startRemoteProcessImpl(project, data, commandLine, pathMapper);
    }

    @NotNull
    private static PyRemoteProcessHandler startRemoteProcessImpl(@Nullable Project project, @NotNull PyRemoteSdkCredentials data, @NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper) throws RemoteSdkException {
        if (data == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        if (commandLine == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
        }
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)project);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)project);
        PyRemoteProcessUtil.uploadAllHelpers((RemoteSdkCredentials)data, project);
        PyRemoteSocketToLocalHostProvider sshRemoteSocketProvider = PyRemoteSocketToLocalHostProviderFactory.ssh(connectionBuilder, data);
        PySshCommandLineStateUtil.patchCommandLineForSshSession(commandLine, data, pathMapper, sshRemoteSocketProvider);
        commandLine.setExePath(data.getInterpreterPath());
        SshExecProcess process = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(true).start();
        PyRemoteProcessHandler pyRemoteProcessHandler = PyRemoteProcessHandler.createProcessHandler((RemoteProcess)process, (RemoteSdkCredentials)data, commandLine, pathMapper, sshRemoteSocketProvider);
        if (pyRemoteProcessHandler == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
        }
        return pyRemoteProcessHandler;
    }

    @Nullable
    public Pair<Supplier<String>, JPanel> createServerBrowserForm(@NotNull Sdk remoteSdk) throws ExecutionException, InterruptedException {
        PyDeploymentBasedProjectSynchronizer synchronizer;
        if (remoteSdk == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        if ((synchronizer = (PyDeploymentBasedProjectSynchronizer)PyUtil.as((Object)this.getSynchronizer(remoteSdk), PyDeploymentBasedProjectSynchronizer.class)) == null) {
            return null;
        }
        Deployable deployable = synchronizer.createDeployable();
        ServerBrowserForm form = new ServerBrowserForm(deployable, true, FileTransferConfig.Origin.Default, null, null, true);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)form);
        return Pair.create(() -> {
            WebServerConfig.RemotePath selection = form.getSelection();
            return selection != null ? selection.path : "";
        }, (Object)form.getContentPane());
    }

    public ListenableFuture<?> uploadHelpersAsync(@Nullable Sdk sdk, @Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials credentials, boolean uploadOnSnapshot) {
        if (credentials == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
        }
        return PyHelpersUpload.uploadAllHelpers(project, component, credentials, uploadOnSnapshot);
    }

    @NotNull
    public PyRemotePathMapper setupMappings(@Nullable Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @Nullable PyRemotePathMapper pathMapper) {
        if (data == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        PyRemotePathMapper pyRemotePathMapper = PyRemoteInterpreterManagerImpl.appendBasicMappings(project, pathMapper, (RemoteSdkAdditionalData)data);
        if (pyRemotePathMapper == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
        }
        return pyRemotePathMapper;
    }

    @NotNull
    public SdkAdditionalData loadRemoteSdkData(Sdk sdk, Element additional) {
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = PyRemoteSdkAdditionalData.loadRemote((Sdk)sdk, (Element)additional);
        if (pyRemoteSdkAdditionalData == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        return pyRemoteSdkAdditionalData;
    }

    public PyConsoleProcessHandler createConsoleProcessHandler(@NotNull Process process, PythonConsoleView view, PydevConsoleCommunication consoleCommunication, @NotNull String commandLine, Charset charset, PyRemotePathMapper pathMapper, PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        if (process == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
        }
        if (commandLine == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        return new PyRemoteConsoleProcessHandler(process, view, consoleCommunication, commandLine, charset, pathMapper, remoteSocketProvider);
    }

    @NotNull
    public RemoteSdkCredentialsProducer<PyRemoteSdkCredentials> getRemoteSdkCredentialsProducer(Function<RemoteCredentials, PyRemoteSdkCredentials> credentialsTransformer, RemoteConnectionCredentialsWrapper connectionWrapper) {
        RemoteSdkCredentialsProducerImpl remoteSdkCredentialsProducerImpl = new RemoteSdkCredentialsProducerImpl(credentialsTransformer, connectionWrapper, true);
        if (remoteSdkCredentialsProducerImpl == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
        }
        return remoteSdkCredentialsProducerImpl;
    }

    public Sdk createRemoteSdk(@Nullable Project project, @NotNull PyRemoteSdkAdditionalData data, @Nullable String sdkName, Collection<Sdk> existingSdks) throws RemoteSdkException {
        if (data == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        return this.myRemoteInterpreterFactory.createRemoteSdk(project, (RemoteSdkAdditionalData)data, sdkName, existingSdks);
    }

    public String generateSdkHomePath(@NotNull PyRemoteSdkAdditionalData data) {
        if (data == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(16);
        }
        return this.myRemoteInterpreterFactory.generateSdkHomePath((RemoteSdkAdditionalData)data);
    }

    public Sdk createUnfinished(PyRemoteSdkAdditionalData data, Collection<Sdk> existingSdks) {
        return this.myRemoteInterpreterFactory.createUnfinished((RemoteSdkAdditionalData)data, existingSdks);
    }

    public String getDefaultUnfinishedName() {
        return this.myRemoteInterpreterFactory.getDefaultUnfinishedName();
    }

    @NotNull
    public String sdkName() {
        String string = this.myRemoteInterpreterFactory.sdkName();
        if (string == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    public boolean canSaveUnfinished() {
        return this.myRemoteInterpreterFactory.canSaveUnfinished();
    }

    public void initSdk(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) throws RemoteSdkException {
        if (sdk == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(18);
        }
        this.myRemoteInterpreterFactory.initSdk(sdk, project, ownerComponent);
    }

    @NotNull
    public static PyRemotePathMapper appendBasicMappings(@Nullable Project project, @Nullable PyRemotePathMapper pathMapper, RemoteSdkAdditionalData data) {
        PyRemotePathMapper newPathMapper = PyRemotePathMapper.cloneMapper((PyRemotePathMapper)pathMapper);
        PyRemoteInterpreterManagerImpl.addHelpersMapping((RemoteSdkProperties)data, (PyRemotePathMapper)newPathMapper);
        newPathMapper.addAll((Collection)data.getPathMappings().getPathMappings(), PyRemotePathMapper.PyPathMappingType.SYS_PATH);
        if (project != null) {
            RemoteMappingsManager.Mappings mappings = RemoteMappingsManager.getInstance((Project)project).getForServer(PYTHON_PREFIX, data.getSdkId());
            if (mappings != null) {
                newPathMapper.addAll((Collection)mappings.getSettings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
            }
            for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)data)) {
                PathMappingSettings settings = mappingProvider.getPathMappingSettings(project, data);
                newPathMapper.addAll((Collection)settings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.REPLICATED_FOLDER);
            }
        }
        PyRemotePathMapper pyRemotePathMapper = newPathMapper;
        if (pyRemotePathMapper == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(19);
        }
        return pyRemotePathMapper;
    }

    public void addRemoteSdk(Project project, Component parentComponent, Collection<Sdk> existingSdks, NullableConsumer<Sdk> sdkCallback) {
        PyCreateRemoteInterpreterDialog dialog = project != null ? new PyCreateRemoteInterpreterDialog(project, existingSdks) : new PyCreateRemoteInterpreterDialog(parentComponent, existingSdks);
        if (dialog.showAndGet()) {
            Sdk sdk = dialog.getSdk();
            sdkCallback.consume((Object)sdk);
        }
    }

    public boolean editSdk(@NotNull Project project, @NotNull SdkModificator sdkModificator, Collection<Sdk> existingSdks) {
        if (project == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(20);
        }
        if (sdkModificator == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(21);
        }
        if (sdkModificator.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalData) {
            Sdk newSdk;
            PyRemoteSdkAdditionalData newData;
            PyRemoteSdkAdditionalData data = (PyRemoteSdkAdditionalData)sdkModificator.getSdkAdditionalData();
            CredentialsType credentialsType = data.connectionCredentials().getRemoteConnectionType();
            if (!RemoteSdkUtil.isCredentialsTypeSupportedForLanguage((CredentialsType)credentialsType, PyCredentialsContribution.class)) {
                RemoteSdkUtil.showCannotLoadCredentialsErrorDialog((Project)project, (String)StringUtil.notNullize((String)sdkModificator.getName()), (CredentialsType)credentialsType);
                return false;
            }
            PyEditRemoteInterpreterDialog dialog = PyRemoteSdkEditor.Companion.sdkEditor(data, project, existingSdks);
            if (dialog == null) {
                dialog = new PyCreateRemoteInterpreterDialog(project, existingSdks);
            }
            dialog.setEditing(data);
            dialog.setSdkName(sdkModificator.getName());
            if (!(!dialog.showAndGet() || (newData = (PyRemoteSdkAdditionalData)(newSdk = dialog.getSdk()).getSdkAdditionalData()) == null || newData.equals(data) && newSdk.getName().equals(sdkModificator.getName()))) {
                newData.copyTo(data);
                sdkModificator.setName(newSdk.getName());
                sdkModificator.setHomePath(newSdk.getHomePath());
                return true;
            }
        } else {
            throw new IllegalStateException("Not implemented yet");
        }
        return false;
    }

    public PySkeletonGenerator createRemoteSkeletonGenerator(@Nullable Project project, Component ownerComponent, @NotNull Sdk sdk, String skeletonsPath) throws ExecutionException {
        if (sdk == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(22);
        }
        PyRemoteSdkAdditionalData sdkAdditionalData = (PyRemoteSdkAdditionalData)sdk.getSdkAdditionalData();
        return PyRemoteSkeletonGeneratorFactory.getInstance((PyRemoteSdkAdditionalDataBase)sdkAdditionalData).createRemoteSkeletonGenerator(project, ownerComponent, sdk, skeletonsPath);
    }

    public boolean ensureCanWrite(RemoteSdkCredentials data, String path) {
        return RemoteSdkUtil.ensureCanWriteFile((ConnectionOwner)ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages(null), (RemoteSdkCredentials)data, (String)path);
    }

    @Nullable
    public PyProjectSynchronizer getSynchronizer(@NotNull Sdk sdk) {
        PyRemoteSdkAdditionalData remoteSdkAdditionalData;
        if (sdk == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(23);
        }
        if ((remoteSdkAdditionalData = (PyRemoteSdkAdditionalData)PyUtil.as((Object)sdk.getSdkAdditionalData(), PyRemoteSdkAdditionalData.class)) == null) {
            return null;
        }
        CredentialsType type = remoteSdkAdditionalData.getRemoteConnectionType();
        if (type.equals(CredentialsType.SSH_HOST)) {
            return new PySshProjectSynchronizer(sdk);
        }
        if (type.equals(CredentialsType.WEB_DEPLOYMENT)) {
            return PyWebDeploymentProjectSynchronizer.newInstance(sdk);
        }
        if (type.equals(CredentialsType.VAGRANT)) {
            return new PyVagrantProjectSynchronizer(sdk);
        }
        PyProjectSynchronizer synchronizer = PyProjectSynchronizerProvider.Companion.find(type, sdk);
        if (synchronizer != null) {
            return synchronizer;
        }
        return PyUnknownProjectSynchronizer.INSTANCE;
    }

    public void copyFromRemote(Sdk sdk, @NotNull Project project, RemoteSdkCredentials data, List<PathMappingSettings.PathMapping> mappings) {
        if (project == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(24);
        }
        PyHelpersDownload.downloadFromRemote(project, null, data, mappings);
    }

    public void runVagrant(@NotNull String vagrantFolder, @Nullable String machineName) throws ExecutionException {
        VagrantSupport vs;
        if (vagrantFolder == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(25);
        }
        if ((vs = VagrantSupport.getInstance()) == null) {
            throw new IllegalStateException("Vagrant Support unavailable");
        }
        vs.runVagrant(vagrantFolder, machineName);
    }

    public String getInterpreterVersion(@Nullable Project project, PyRemoteSdkAdditionalDataBase data) throws RemoteSdkException {
        return PyRemoteInterpreterUtil.getInterpreterVersion(project, (PyRemoteSdkAdditionalData)data, true);
    }

    @NotNull
    public String[] chooseRemoteFiles(@NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, boolean foldersOnly) throws ExecutionException, InterruptedException {
        WebServerConfig.RemotePath path;
        PyRemoteFilesChooser chooser;
        if (project == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(26);
        }
        if (data == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(27);
        }
        if (data instanceof PyRemoteSdkAdditionalData && (chooser = PyRemoteSdkEditor.Companion.filesChooser((PyRemoteSdkAdditionalData)data)) != null) {
            String[] stringArray = chooser.chooseRemoteFiles(project, data, foldersOnly);
            if (stringArray == null) {
                PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(28);
            }
            return stringArray;
        }
        CredentialsDeployable deployable = RemoteSdkUtil.createDeployable((RemoteCredentials)data.getRemoteSdkCredentials(false));
        ServerBrowserDialog d = new ServerBrowserDialog(project, (Deployable)deployable, "Choose Remote Path", foldersOnly, FileTransferConfig.Origin.Default, null);
        d.show();
        if (d.isOK() && (path = d.getPath()) != null) {
            String[] stringArray = new String[]{path.path};
            if (stringArray == null) {
                PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(29);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(30);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteInterpreterManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteInterpreterManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcessImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setupMappings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemoteSdkData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkCredentialsProducer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "appendBasicMappings";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseRemoteFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcessImpl";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createServerBrowserForm";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uploadHelpersAsync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupMappings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandler";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteSdk";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateSdkHomePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "editSdk";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteSkeletonGenerator";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSynchronizer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyFromRemote";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "runVagrant";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "chooseRemoteFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

