/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ssh.SshSessionKey;
import com.intellij.ssh.SshTransportException;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteUpload;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionServiceUtil;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.helpersPro.PyHelpersProLocator;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyHelpersUpload
extends RemoteUpload {
    private static final Logger LOG = Logger.getInstance(PyHelpersUpload.class);
    private static final Object myAsyncTransferLock = new Object();
    private static final ConcurrentMap<SshSessionKey, ListenableFuture<?>> myHelpersTransferSessionMap = Maps.newConcurrentMap();
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("PyCharm Helpers Upload", NotificationDisplayType.BALLOON, true);

    private PyHelpersUpload(@Nullable Project project, @Nullable Component component, @NotNull RemoteCredentials remoteCredentials, boolean isModal, @NotNull Collection<String> helpersPaths, @NotNull String remotePath) {
        if (remoteCredentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(0);
        }
        if (helpersPaths == null) {
            PyHelpersUpload.$$$reportNull$$$0(1);
        }
        if (remotePath == null) {
            PyHelpersUpload.$$$reportNull$$$0(2);
        }
        super(remoteCredentials, project, component, "Uploading PyCharm helpers...", false, isModal, helpersPaths, remotePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ListenableFuture<?> uploadAllHelpers(@Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials credentials, boolean uploadOnSnapshot) {
        if (credentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(3);
        }
        HashSet helperRoots = Sets.newHashSet((Object[])new String[]{PythonHelpersLocator.getHelpersRoot().getPath(), PyHelpersProLocator.Companion.getHelpersProRoot().getPath()});
        Object object = myAsyncTransferLock;
        synchronized (object) {
            SshSessionKey key = SshConnectionServiceUtil.remoteCredentialsToSessionKey((RemoteCredentials)credentials);
            PyHelpersUpload transfer = (PyHelpersUpload)((Object)UIUtil.invokeAndWaitIfNeeded(() -> new PyHelpersUpload(project, component, (RemoteCredentials)credentials, false, helperRoots, credentials.getHelpersPath())));
            transfer.setUploadOnSnapshot(uploadOnSnapshot);
            Callable<Object> transferTask2 = () -> {
                ListenableFuture f = JdkFutureAdapters.listenInPoolThread((Future)transfer.upload());
                f.addListener(() -> {
                    ListenableFuture cfr_ignored_0 = (ListenableFuture)myHelpersTransferSessionMap.remove(key);
                }, (Executor)ourExecutorService);
                myHelpersTransferSessionMap.put(key, f);
                if (f.isDone()) {
                    myHelpersTransferSessionMap.remove(key);
                }
                return f.get();
            };
            ListenableFuture future = (ListenableFuture)myHelpersTransferSessionMap.get(key);
            if (future != null) {
                return Futures.transform((ListenableFuture)future, input -> {
                    try {
                        return transferTask2.call();
                    }
                    catch (Exception e) {
                        LOG.error("Error from future", (Throwable)e);
                        return false;
                    }
                }, (Executor)ourExecutorService);
            }
            return ourExecutorService.submit(transferTask2);
        }
    }

    public static void uploadHelpersSync(@Nullable Project project, @NotNull RemoteSdkCredentials credentials, Set<String> filesToUpload) {
        if (credentials == null) {
            PyHelpersUpload.$$$reportNull$$$0(4);
        }
        PyHelpersUpload transfer = new PyHelpersUpload(project, null, (RemoteCredentials)credentials, true, filesToUpload, credentials.getHelpersPath()){

            @Override
            protected boolean helpersArchiveCopyEnabled() {
                return false;
            }
        };
        File root = PythonHelpersLocator.getHelpersRoot();
        ImmutableMap map = Maps.toMap(filesToUpload, path -> FileUtil.getRelativePath((File)root, (File)new File(Objects.requireNonNull(path))));
        transfer.setRelativePathsMap((Map)map);
        ListenableFuture future = JdkFutureAdapters.listenInPoolThread((Future)transfer.upload());
        try {
            future.get();
        }
        catch (Exception e) {
            LOG.error("Helpers upload failed", (Throwable)e);
        }
    }

    protected boolean helpersArchiveCopyEnabled() {
        return true;
    }

    @NotNull
    protected List<ExcludedPath> getExcludedHelpersPaths(@NotNull Collection<String> helpersPaths) {
        if (helpersPaths == null) {
            PyHelpersUpload.$$$reportNull$$$0(5);
        }
        Set<String> pathsToExclude = PyHelpersUpload.getPathsToExclude();
        ArrayList result = Lists.newArrayList();
        for (String path : helpersPaths) {
            for (String subPath : pathsToExclude) {
                File helper = new File(path, subPath);
                if (!helper.exists()) continue;
                result.add(new ExcludedPath(helper.getPath(), true));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            PyHelpersUpload.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static Set<String> getPathsToExclude() {
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{"docutils", "epydoc", "process", "pydev/pydevd_attach_to_process", "pydev/test_pydevd_reload", "pydev/tests", "pydev/tests_mainloop", "pydev/tests_python", "pydev/tests_runfiles", "pydev/third_party", "python-skeletons", "tools", "MathJax", "py2only", "py3only", "python-skeletons", "typeshed"});
        if (hashSet == null) {
            PyHelpersUpload.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    protected Predicate<String> createFileFilter() {
        Set<String> pathsToExclude = PyHelpersUpload.getPathsToExclude();
        Predicate predicate = path -> path != null && !pathsToExclude.contains(path) && !path.endsWith(".pyc") && !path.endsWith(".class");
        if (predicate == null) {
            PyHelpersUpload.$$$reportNull$$$0(8);
        }
        return predicate;
    }

    protected void onUploadError(@NotNull SshTransportException e) {
        if (e == null) {
            PyHelpersUpload.$$$reportNull$$$0(9);
        }
        NOTIFICATION_GROUP.createNotification("Couldn't upload helpers for remote interpreter", e.getLocalizedMessage(), NotificationType.WARNING, null).notify(this.getProject());
    }

    public static synchronized void shutDownService() {
        ourExecutorService.shutdownNow();
        try {
            ourExecutorService.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to stop threads", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyHelpersUpload";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyHelpersUpload";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedHelpersPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToExclude";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uploadAllHelpers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uploadHelpersSync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedHelpersPaths";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onUploadError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

