/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.increment;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSExpressionWithOperationNode;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NotNull;

public class JSExtractIncrementIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        return this.getText(((JSExpressionWithOperationNode)element).getOperationNode().getText());
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ExtractIncrementPredicate extractIncrementPredicate = new ExtractIncrementPredicate();
        if (extractIncrementPredicate == null) {
            JSExtractIncrementIntention.$$$reportNull$$$0(0);
        }
        return extractIncrementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean isPostfix;
        JSExpression operand;
        if (element == null) {
            JSExtractIncrementIntention.$$$reportNull$$$0(1);
        }
        JSExpression jSExpression = operand = (isPostfix = element instanceof JSPostfixExpression) ? ((JSPostfixExpression)element).getExpression() : ((JSPrefixExpression)element).getExpression();
        if (operand == null) {
            return;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        assert (statement != null);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)element.getContainingFile());
        JSStatement statementNode = JSPsiElementFactory.createJSStatement((String)(element.getText() + semicolon), (PsiElement)element);
        if (isPostfix) {
            statement.addStatementAfter(statementNode);
        } else {
            statement.addStatementBefore(statementNode);
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)((JSExpression)element), (String)operand.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExtractIncrementPredicate
    implements JSElementPredicate {
        private ExtractIncrementPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ExtractIncrementPredicate.$$$reportNull$$$0(0);
            }
            if (!ExpressionUtil.isIncrementDecrementExpression((PsiElement)element)) {
                return false;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSExpressionStatement) {
                return false;
            }
            JSStatement containingStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
            if (element instanceof JSPostfixExpression && containingStatement instanceof JSFunctionExitPoint) {
                return false;
            }
            return containingStatement != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention$ExtractIncrementPredicate", "satisfiedBy"));
        }
    }
}

