/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.htmltools.xml.util.HtmlReferenceProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckImageSizeInspection
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance(CheckImageSizeInspection.class);

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CheckImageSizeInspection.$$$reportNull$$$0(0);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                XmlAttributeValue value;
                XmlTag parent = attribute.getParent();
                if (!(parent instanceof HtmlTag) || XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)parent)) {
                    return;
                }
                String name = attribute.getName();
                if (("height".equalsIgnoreCase(name) || "width".equalsIgnoreCase(name)) && (value = attribute.getValueElement()) != null && value.getTextLength() > 0) {
                    HtmlReferenceProvider.SizeReference sizeReference;
                    PsiElement element;
                    PsiReference[] refs = value.getReferences();
                    boolean isHeight = "height".equalsIgnoreCase(name);
                    if (refs.length == 1 && refs[0] instanceof HtmlReferenceProvider.SizeReference && refs[0].getRangeInElement().getLength() >= 2 && (element = (sizeReference = (HtmlReferenceProvider.SizeReference)refs[0]).resolve()) == null) {
                        ImageInfoReader.Info imageInfo = sizeReference.getImageInfo();
                        if (imageInfo == null || imageInfo.height == 0 || imageInfo.width == 0 || imageInfo.isSvg()) {
                            return;
                        }
                        String adequateValue = String.valueOf(isHeight ? imageInfo.height : imageInfo.width);
                        String message = XmlBundle.message((String)(isHeight ? "html.inspections.check.image.height.fix.message" : "html.inspections.check.image.width.fix.message"), (Object[])new Object[]{adequateValue});
                        MyFix fix = new MyFix(message, adequateValue);
                        holder.registerProblem((PsiElement)value, XmlBundle.message((String)(isHeight ? "html.inspections.check.image.height.message" : "html.inspections.check.image.width.message"), (Object[])new Object[]{adequateValue}), new LocalQuickFix[]{fix});
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            CheckImageSizeInspection.$$$reportNull$$$0(1);
        }
        return xmlElementVisitor;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.HTML_INSPECTIONS;
        if (string == null) {
            CheckImageSizeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.image.size", (Object[])new Object[0]);
        if (string == null) {
            CheckImageSizeInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckImageSize" == null) {
            CheckImageSizeInspection.$$$reportNull$$$0(4);
        }
        return "CheckImageSize";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/xml/util/CheckImageSizeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/xml/util/CheckImageSizeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFix
    implements LocalQuickFix {
        private final String myMessage;
        private final String myAdequateValue;

        private MyFix(String message, String adequateValue) {
            this.myMessage = message;
            this.myAdequateValue = adequateValue;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                MyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlAttributeValue value;
            if (project == null) {
                MyFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyFix.$$$reportNull$$$0(2);
            }
            if ((value = (XmlAttributeValue)descriptor.getPsiElement()) == null) {
                return;
            }
            try {
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)value);
                assert (manipulator != null);
                PsiReference[] refs = value.getReferences();
                if (refs.length != 1) {
                    return;
                }
                manipulator.handleContentChange((PsiElement)value, refs[0].getRangeInElement(), this.myAdequateValue);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/htmltools/xml/util/CheckImageSizeInspection$MyFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/htmltools/xml/util/CheckImageSizeInspection$MyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

