/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a&\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0002\u001a \u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"PREDEFINED_MAPPINGS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "createUrlToLocalMap", "mappings", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "findByMappings", "parsedUrl", "Lcom/intellij/util/Url;", "findByName", "filename", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
public final class RemoteDebuggingFileFinderKt {
    private static final Key<BiMap<String, VirtualFile>> PREDEFINED_MAPPINGS_KEY;

    @NotNull
    public static final BiMap<String, VirtualFile> createUrlToLocalMap(@NotNull List<? extends RemoteUrlMappingBean> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        if (mappings.isEmpty()) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableBiMap, (String)"ImmutableBiMap.of()");
            return (BiMap)immutableBiMap;
        }
        HashBiMap map = HashBiMap.create((int)mappings.size());
        for (RemoteUrlMappingBean remoteUrlMappingBean : mappings) {
            VirtualFile file = LocalFileFinder.findFile((String)remoteUrlMappingBean.localFilePath);
            if (file == null) continue;
            map.forcePut((Object)remoteUrlMappingBean.getRemoteUrl(), (Object)file);
        }
        HashBiMap hashBiMap = map;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashBiMap, (String)"map");
        return (BiMap)hashBiMap;
    }

    @Nullable
    public static final List<VirtualFile> findByName(@NotNull String filename, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (List)DumbService.getInstance((Project)project).tryRunReadActionInSmartMode((Computable)new Computable<List<? extends VirtualFile>>(project, filename){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $filename;

            @NotNull
            public final List<VirtualFile> compute() {
                GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"ProjectScope.getContentScope(project)");
                GlobalSearchScope scope = globalSearchScope;
                CharSequence charSequence = this.$filename;
                Project project = this.$project;
                boolean bl = false;
                boolean bl2 = charSequence.length() == 0;
                Collection collection = FilenameIndex.getVirtualFilesByName((Project)project, (String)(bl2 ? "index.html" : this.$filename), (GlobalSearchScope)scope);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FilenameIndex.getVirtual\u2026ml\" else filename, scope)");
                Collection files2 = collection;
                if (files2.isEmpty()) {
                    charSequence = this.$filename;
                    bl = false;
                    if (charSequence.length() == 0) {
                        Collection collection2 = FilenameIndex.getVirtualFilesByName((Project)this.$project, (String)"index.xhtml", (GlobalSearchScope)scope);
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"FilenameIndex.getVirtual\u2026ct, \"index.xhtml\", scope)");
                        files2 = collection2;
                    }
                }
                if (files2.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                ProjectFileIndex projectFileIndex2 = projectFileIndex;
                SmartList result2 = new SmartList();
                for (VirtualFile file : files2) {
                    if (projectFileIndex2.isInLibrary(file)) continue;
                    result2.add((Object)file);
                }
                return (List)result2;
            }
            {
                this.$project = project;
                this.$filename = string;
            }
        }, "Smart remote file mapping is not possible during index update");
    }

    private static final VirtualFile findByMappings(Url parsedUrl, BiMap<String, VirtualFile> mappings) {
        if (mappings.isEmpty()) {
            return null;
        }
        String url = parsedUrl.trimParameters().toDecodedForm();
        int i = url.length();
        while (i != -1) {
            String prefix;
            String string;
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"url");
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, i), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            VirtualFile file = (VirtualFile)mappings.get((Object)prefix);
            if (file != null) {
                if (i == url.length()) {
                    return file;
                }
                if (i + 1 == url.length()) {
                    VirtualFile indexFile = BuiltInWebServerKt.findIndexFile((VirtualFile)file);
                    if (indexFile == null) break;
                    return indexFile;
                }
                String string3 = url;
                int n2 = i + 1;
                boolean bl2 = false;
                String string4 = string3.substring(n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                String filename = string4;
                VirtualFile child = file.findFileByRelativePath(filename);
                if (child == null) break;
                return child;
            }
            i = StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)(i - 1), (boolean)false, (int)4, null);
        }
        return null;
    }

    static {
        Key key = Key.create((String)"js.debugger.predefined.mappings");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"js.debugger.predefined.mappings\")");
        PREDEFINED_MAPPINGS_KEY = key;
    }

    public static final /* synthetic */ VirtualFile access$findByMappings(Url parsedUrl, BiMap mappings) {
        return RemoteDebuggingFileFinderKt.findByMappings(parsedUrl, (BiMap<String, VirtualFile>)mappings);
    }

    public static final /* synthetic */ Key access$getPREDEFINED_MAPPINGS_KEY$p() {
        return PREDEFINED_MAPPINGS_KEY;
    }
}

