/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KdbxGroupKt;
import com.intellij.credentialStore.kdbx.KdbxHeader;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.credentialStore.kdbx.ProtectedXmlWriter;
import com.intellij.credentialStore.kdbx.StringProtectedByStreamCipher;
import com.intellij.util.JdomKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Base64;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "", "rootElement", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "<set-?>", "", "isDirty", "()Z", "setDirty$intellij_platform_credentialStore", "(Z)V", "rootGroup", "Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "getRootGroup$intellij_platform_credentialStore", "()Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "secureStringCipher", "Lkotlin/Lazy;", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "createEntry", "Lcom/intellij/credentialStore/kdbx/KdbxEntry;", "title", "", "createEntry$intellij_platform_credentialStore", "protectValue", "Lcom/intellij/credentialStore/kdbx/StringProtectedByStreamCipher;", "value", "", "protectValue$intellij_platform_credentialStore", "save", "", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "outputStream", "Ljava/io/OutputStream;", "secureRandom", "Ljava/security/SecureRandom;", "save$intellij_platform_credentialStore", "intellij.platform.credentialStore"})
public final class KeePassDatabase {
    private Lazy<? extends SkippingStreamCipher> secureStringCipher;
    private volatile boolean isDirty;
    @NotNull
    private final KdbxGroup rootGroup;
    private final Element rootElement;

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty$intellij_platform_credentialStore(boolean bl) {
        this.isDirty = bl;
    }

    @NotNull
    public final KdbxGroup getRootGroup$intellij_platform_credentialStore() {
        return this.rootGroup;
    }

    @NotNull
    public final StringProtectedByStreamCipher protectValue$intellij_platform_credentialStore(@NotNull CharSequence value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return new StringProtectedByStreamCipher(value, (SkippingStreamCipher)this.secureStringCipher.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void save$intellij_platform_credentialStore(@NotNull KeePassCredentials credentials2, @NotNull OutputStream outputStream, @NotNull SecureRandom secureRandom2) {
        Intrinsics.checkParameterIsNotNull((Object)credentials2, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Intrinsics.checkParameterIsNotNull((Object)secureRandom2, (String)"secureRandom");
        KdbxHeader kdbxHeader = new KdbxHeader(secureRandom2);
        kdbxHeader.writeKdbxHeader(outputStream);
        Element metaElement = JdomKt.getOrCreate((Element)this.rootElement, (String)"Meta");
        JdomKt.getOrCreate((Element)metaElement, (String)"HeaderHash").setText(Base64.getEncoder().encodeToString(kdbxHeader.getHeaderHash()));
        JdomKt.getOrCreate((Element)JdomKt.getOrCreate((Element)metaElement, (String)"MemoryProtection"), (String)"ProtectPassword").setText("True");
        Closeable closeable = kdbxHeader.createEncryptedStream(credentials2.getKey(), outputStream);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl3 = false;
            new ProtectedXmlWriter(KdbxKt.createSalsa20StreamCipher(kdbxHeader.getProtectedStreamKey())).printElement(it, this.rootElement, 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (this.secureStringCipher.isInitialized()) {
            KeePassDatabaseKt.access$initCipherRandomly(secureRandom2, (SkippingStreamCipher)this.secureStringCipher.getValue());
        } else {
            this.secureStringCipher = LazyKt.lazyOf((Object)KeePassDatabaseKt.access$createRandomlyInitializedChaCha7539Engine(secureRandom2));
        }
        this.isDirty = false;
    }

    @NotNull
    public final KdbxEntry createEntry$intellij_platform_credentialStore(@NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Element element = new Element("Entry");
        KeePassDatabaseKt.ensureElements(element, KeePassDatabaseKt.access$getMandatoryEntryElements$p());
        KdbxEntry result = new KdbxEntry(element, this, null);
        result.setTitle(title);
        return result;
    }

    public KeePassDatabase(@NotNull Element rootElement) {
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        this.rootElement = rootElement;
        this.secureStringCipher = LazyKt.lazy((Function0)secureStringCipher.1.INSTANCE);
        Element rootElement2 = JdomKt.getOrCreate((Element)this.rootElement, (String)"Root");
        Element groupElement = rootElement2.getChild("Group");
        if (groupElement == null) {
            this.rootGroup = KdbxGroupKt.createGroup(this, null);
            this.rootGroup.setName("Root");
            rootElement2.addContent(this.rootGroup.getElement$intellij_platform_credentialStore());
        } else {
            this.rootGroup = new KdbxGroup(groupElement, this, null);
        }
    }

    public /* synthetic */ KeePassDatabase(Element element, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            element = KeePassDatabaseKt.access$createEmptyDatabase();
        }
        this(element);
    }

    public KeePassDatabase() {
        this(null, 1, null);
    }
}

