/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.util.io.DigestUtil;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class HashedBlockInputStream
extends InputStream {
    private static final int HASH_SIZE = 32;
    private static final byte[] ZERO_HASH = new byte[32];
    private long expectedSequenceNumber;
    private boolean done;
    private final InputStream inputStream;
    private ByteArrayInputStream blockInputStream;
    private final MessageDigest md;

    HashedBlockInputStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            HashedBlockInputStream.$$$reportNull$$$0(0);
        }
        this.expectedSequenceNumber = 0L;
        this.done = false;
        this.blockInputStream = new ByteArrayInputStream(new byte[0]);
        this.md = DigestUtil.sha256();
        this.inputStream = inputStream;
    }

    @Override
    public int read(@NotNull byte[] b, int offset, int length) throws IOException {
        if (b == null) {
            HashedBlockInputStream.$$$reportNull$$$0(1);
        }
        return this.get(b, offset, length);
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        if (this.get(buffer, 0, 1) != 1) {
            throw new IOException("Could not read int");
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private int get(byte[] b, int offset, int length) throws IOException {
        int bytesRead;
        if (this.done) {
            return -1;
        }
        int totalBytesRead = 0;
        while ((bytesRead = this.blockInputStream.read(b, offset, length)) < length && !this.done) {
            if (bytesRead == -1) {
                this.load();
                continue;
            }
            offset += bytesRead;
            length -= bytesRead;
            totalBytesRead += bytesRead;
        }
        return bytesRead > 0 ? totalBytesRead + bytesRead : totalBytesRead;
    }

    private void load() throws IOException {
        long sequenceNumber = this.readUInt();
        if (sequenceNumber != this.expectedSequenceNumber) {
            throw new IllegalStateException("Expected sequence number " + this.expectedSequenceNumber + " got " + sequenceNumber);
        }
        ++this.expectedSequenceNumber;
        byte[] hash = new byte[32];
        this.readFully(hash);
        long readLength = this.readUInt();
        if (readLength < 0L) {
            throw new IllegalStateException("Got negative length for block");
        }
        if (readLength == 0L) {
            if (!Arrays.equals(hash, ZERO_HASH)) {
                throw new IllegalStateException("Block hash was not zero on final block");
            }
            this.done = true;
            return;
        }
        byte[] readBuffer = new byte[(int)readLength];
        this.readFully(readBuffer);
        this.md.update(readBuffer);
        if (!Arrays.equals(this.md.digest(), hash)) {
            throw new IllegalStateException("MD5 check failed while reading HashBlock");
        }
        this.blockInputStream = new ByteArrayInputStream(readBuffer);
    }

    private long readUInt() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf);
        return buf[3] << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    private void readFully(byte[] buffer) throws IOException {
        int bytesToRead = buffer.length;
        int bytesSoFar = 0;
        while (bytesSoFar < buffer.length) {
            int bytesRead = this.inputStream.read(buffer, bytesSoFar, bytesToRead);
            if (bytesRead <= 0) {
                throw new EOFException();
            }
            bytesSoFar += bytesRead;
            bytesToRead -= bytesRead;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "com/intellij/credentialStore/kdbx/HashedBlockInputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

