/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.fs;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.File;
import java.util.Collections;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SaveDiagramAction
extends DiagramAction {
    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        DiagramBuilder builder = SaveDiagramAction.getBuilder((AnActionEvent)e);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (project == null || builder == null || !(fileEditor instanceof DiagramFileEditor)) {
            return;
        }
        String filename = "diagram.uml";
        VirtualFile baseDir = null;
        DiagramFileEditor editor = (DiagramFileEditor)fileEditor;
        VirtualFile vf = editor.getOriginalVirtualFile();
        if (vf != null && vf.getFileSystem() instanceof LocalFileSystem) {
            filename = vf.getName();
            baseDir = vf.getParent();
        } else {
            String fqn;
            Object original = builder.getGraph().getDataProvider((Object)"ORIGINAL_ELEMENT").get((Object)"");
            if (original != null) {
                fqn = builder.getProvider().getExtras().suggestDiagramFileName(original);
                if (fqn == null && (fqn = builder.getProvider().getVfsResolver().getQualifiedName(original)) != null && fqn.contains(".") && !fqn.endsWith(".")) {
                    fqn = fqn.substring(fqn.lastIndexOf(46) + 1);
                }
            } else {
                fqn = builder.getProvider().getElementManager().getElementTitle(editor.getOriginalElement());
            }
            if (fqn != null) {
                filename = fqn + ".uml";
            }
        }
        VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save File", "Save UML class diagram as .uml", new String[]{"uml"}), project).save(baseDir == null ? project.getBaseDir() : baseDir, filename);
        if (wrapper == null) {
            return;
        }
        Document xml = new Document(new Element("Diagram"));
        DiagramState state = (DiagramState)editor.getState(FileEditorStateLevel.FULL);
        state.write(xml.getRootElement());
        wrapper = SaveDiagramAction.getWrapperWithUmlExtension(wrapper);
        VirtualFile file = wrapper.getVirtualFile(true);
        if (file == null || !state.saveTo(file, project)) {
            String msg = "Can't save diagram to " + wrapper.getFile().getPath();
            if (file != null && ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(file)).hasReadonlyFiles()) {
                msg = msg + " File is Read-Only.";
            }
            Messages.showErrorDialog((Project)project, (String)msg, (String)"Error");
        }
    }

    @NotNull
    public static VirtualFileWrapper getWrapperWithUmlExtension(@NotNull VirtualFileWrapper wrapper) {
        File file;
        if (wrapper == null) {
            SaveDiagramAction.$$$reportNull$$$0(1);
        }
        if ("uml".equalsIgnoreCase(FileUtilRt.getExtension((String)(file = wrapper.getFile()).getName()))) {
            VirtualFileWrapper virtualFileWrapper = wrapper;
            if (virtualFileWrapper == null) {
                SaveDiagramAction.$$$reportNull$$$0(2);
            }
            return virtualFileWrapper;
        }
        VirtualFileWrapper virtualFileWrapper = new VirtualFileWrapper(new File(file.getPath() + ".uml"));
        if (virtualFileWrapper == null) {
            SaveDiagramAction.$$$reportNull$$$0(3);
        }
        return virtualFileWrapper;
    }

    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(4);
        }
        return e.getProject() != null && e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DiagramFileEditor;
    }

    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveDiagramAction.$$$reportNull$$$0(5);
        }
        return false;
    }

    public String getActionName() {
        return "Save Diagram";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/fs/SaveDiagramAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/fs/SaveDiagramAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperWithUmlExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperWithUmlExtension";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

