/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramScopeManager<T> {
    private final Project myProject;
    private NamedScope currentScope;

    public DiagramScopeManager(Project project) {
        this.myProject = project;
        this.currentScope = this.fromName(DiagramConfiguration.getConfiguration().defaultScope);
        if (this.currentScope == null) {
            this.currentScope = this.fromName("All");
        }
    }

    public NamedScope[] getScopes() {
        List allCustomScopes = CustomScopesAggregator.getAllCustomScopes((Project)this.myProject);
        allCustomScopes.addAll(Arrays.asList(NamedScopeManager.getInstance((Project)this.myProject).getEditableScopes()));
        return allCustomScopes.toArray(NamedScope.EMPTY_ARRAY);
    }

    public abstract boolean contains(T var1);

    public NamedScope getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(NamedScope currentScope) {
        this.currentScope = currentScope;
    }

    @Nullable
    public NamedScope fromName(String name) {
        for (NamedScope scope : this.getScopes()) {
            if (!scope.getName().equals(name)) continue;
            return scope;
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setCurrentScope(String scopeName) {
        for (NamedScope scope : this.getScopes()) {
            if (!scope.getName().equals(scopeName)) continue;
            this.currentScope = scope;
            break;
        }
    }
}

