/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JRadioButton myShelveChangesRadioButton;
    private JRadioButton myMoveChangesToActiveRadioButton;
    private JRadioButton mySwitchToChangelistRadioButton;
    private JRadioButton myIgnoreRadioButton;
    private JLabel myListTitle;
    private JList<VirtualFile> myFileList;
    private final Project myProject;

    public ChangelistConflictDialog(Project project, List<ChangeList> changeLists, List<VirtualFile> conflicts) {
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle("Resolve Changelist Conflict");
        this.myListTitle.setText(StringUtil.capitalize((String)ReadOnlyStatusDialog.getTheseFilesMessage(conflicts)) + " " + (conflicts.size() > 1 ? "do" : "does") + " not belong to the active changelist:");
        this.myFileList.setCellRenderer((ListCellRenderer<VirtualFile>)new FileListRenderer());
        this.myFileList.setModel((ListModel<VirtualFile>)new CollectionListModel(conflicts));
        ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        ChangelistConflictResolution resolution = manager.getConflictTracker().getOptions().LAST_RESOLUTION;
        if (changeLists.size() > 1) {
            this.mySwitchToChangelistRadioButton.setEnabled(false);
            if (resolution == ChangelistConflictResolution.SWITCH) {
                resolution = ChangelistConflictResolution.IGNORE;
            }
        }
        this.mySwitchToChangelistRadioButton.setText(VcsBundle.message((String)"switch.to.changelist", (Object[])new Object[]{changeLists.iterator().next().getName()}));
        this.myMoveChangesToActiveRadioButton.setText(VcsBundle.message((String)"move.to.changelist", (Object[])new Object[]{manager.getDefaultChangeList().getName()}));
        switch (resolution) {
            case SHELVE: {
                this.myShelveChangesRadioButton.setSelected(true);
                break;
            }
            case MOVE: {
                this.myMoveChangesToActiveRadioButton.setSelected(true);
                break;
            }
            case SWITCH: {
                this.mySwitchToChangelistRadioButton.setSelected(true);
                break;
            }
            case IGNORE: {
                this.myIgnoreRadioButton.setSelected(true);
            }
        }
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public ChangelistConflictResolution getResolution() {
        if (this.myShelveChangesRadioButton.isSelected()) {
            return ChangelistConflictResolution.SHELVE;
        }
        if (this.myMoveChangesToActiveRadioButton.isSelected()) {
            return ChangelistConflictResolution.MOVE;
        }
        if (this.mySwitchToChangelistRadioButton.isSelected()) {
            return ChangelistConflictResolution.SWITCH;
        }
        return ChangelistConflictResolution.IGNORE;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{new AbstractAction("&Configure..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(ChangelistConflictDialog.this.myProject);
                ShowSettingsUtil.getInstance().editConfigurable((Component)ChangelistConflictDialog.this.myPanel, (Configurable)new ChangelistConflictConfigurable(manager));
            }
        }};
        if (actionArray == null) {
            ChangelistConflictDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected String getHelpId() {
        return "project.propVCSSupport.ChangelistConflict";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictDialog", "createLeftSideActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        this.myShelveChangesRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        jRadioButton4.setText("Shelve changes");
        jRadioButton4.setMnemonic('S');
        jRadioButton4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMoveChangesToActiveRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/VcsBundle").getString("move.to.changelist"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoreRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Ignore");
        jRadioButton2.setMnemonic('I');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySwitchToChangelistRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/VcsBundle").getString("switch.to.changelist"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myListTitle = jLabel = new JLabel();
        jLabel.setText("list title");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFileList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

