/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.highlighting.StylusHighlighterLexer;
import org.jetbrains.plugins.stylus.psi.StylusTokenTypes;

public class StylusSyntaxHighlighter
extends CssHighlighter {
    public static final TextAttributesKey VARIABLE = TextAttributesKey.createTextAttributesKey((String)"STYLUS_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"STYLUS_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"STYLUS_IDENT", (TextAttributesKey)CssHighlighter.CSS_IDENT);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"STYLUS_STRING", (TextAttributesKey)CssHighlighter.CSS_STRING);
    public static final TextAttributesKey IMPORTANT = TextAttributesKey.createTextAttributesKey((String)"STYLUS_IMPORTANT", (TextAttributesKey)CssHighlighter.CSS_IMPORTANT);
    public static final TextAttributesKey PROPERTY_NAME = TextAttributesKey.createTextAttributesKey((String)"STYLUS_PROPERTY_NAME", (TextAttributesKey)CssHighlighter.CSS_PROPERTY_NAME);
    public static final TextAttributesKey PROPERTY_VALUE = TextAttributesKey.createTextAttributesKey((String)"STYLUS_PROPERTY_VALUE", (TextAttributesKey)CssHighlighter.CSS_PROPERTY_VALUE);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"STYLUS_NUMBER", (TextAttributesKey)CssHighlighter.CSS_NUMBER);
    public static final TextAttributesKey COLOR = TextAttributesKey.createTextAttributesKey((String)"STYLUS_COLOR", (TextAttributesKey)CssHighlighter.CSS_COLOR);
    public static final TextAttributesKey PSEUDO = TextAttributesKey.createTextAttributesKey((String)"STYLUS_PSEUDO", (TextAttributesKey)CssHighlighter.CSS_PSEUDO);
    public static final TextAttributesKey COMMENT = TextAttributesKey.createTextAttributesKey((String)"STYLUS_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey TAG_NAME = TextAttributesKey.createTextAttributesKey((String)"STYLUS_TAG_NAME", (TextAttributesKey)CssHighlighter.CSS_TAG_NAME);
    public static final TextAttributesKey ID_SELECTOR = TextAttributesKey.createTextAttributesKey((String)"STYLUS_ID_SELECTOR", (TextAttributesKey)CssHighlighter.CSS_ID_SELECTOR);
    public static final TextAttributesKey CLASS_NAME = TextAttributesKey.createTextAttributesKey((String)"STYLUS_CLASS_NAME", (TextAttributesKey)CssHighlighter.CSS_CLASS_NAME);
    public static final TextAttributesKey ATTRIBUTE_NAME = TextAttributesKey.createTextAttributesKey((String)"STYLUS_ATTRIBUTE_NAME", (TextAttributesKey)CssHighlighter.CSS_ATTRIBUTE_NAME);
    public static final TextAttributesKey OPERATOR = TextAttributesKey.createTextAttributesKey((String)"STYLUS_OPERATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey FUNCTION_NAME = TextAttributesKey.createTextAttributesKey((String)"STYLUS_FUNCTION_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        StylusHighlighterLexer stylusHighlighterLexer = new StylusHighlighterLexer(CssElementDescriptorFactory2.getInstance().getValueIdentifiers());
        if (stylusHighlighterLexer == null) {
            StylusSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return stylusHighlighterLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (ATTRIBUTES.containsKey(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = StylusSyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
            if (textAttributesKeyArray == null) {
                StylusSyntaxHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            StylusSyntaxHighlighter.$$$reportNull$$$0(2);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
        MultiMap map = MultiMap.create();
        map.putAllValues(ATTRIBUTES);
        MultiMap multiMap = map;
        if (multiMap == null) {
            StylusSyntaxHighlighter.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    static {
        ATTRIBUTES.put(StylusTokenTypes.LINE_COMMENT, COMMENT);
        ATTRIBUTES.put(StylusTokenTypes.LOUD_COMMENT, COMMENT);
        ATTRIBUTES.put(CssElementTypes.CSS_COMMENT, COMMENT);
        ATTRIBUTES.put(CssElementTypes.CSS_HACK, COMMENT);
        ATTRIBUTES.put(CssElementTypes.CSS_HASH, ID_SELECTOR);
        ATTRIBUTES.put(CssElementTypes.CSS_CLASS_NAME, CLASS_NAME);
        ATTRIBUTES.put(CssElementTypes.CSS_ATTRIBUTE_NAME, ATTRIBUTE_NAME);
        ATTRIBUTES.put(CssElementTypes.CSS_IDENT, IDENTIFIER);
        ATTRIBUTES.put(StylusTokenTypes.AMPERSAND, IDENTIFIER);
        ATTRIBUTES.put(CssElementTypes.CSS_STRING_TOKEN, STRING);
        ATTRIBUTES.put(CssElementTypes.CSS_NUMBER, NUMBER);
        ATTRIBUTES.put(CssElementTypes.CSS_IMPORTANT, IMPORTANT);
        ATTRIBUTES.put(CssElementTypes.CSS_PROPERTY_NAME, PROPERTY_NAME);
        ATTRIBUTES.put(CssElementTypes.CSS_PROPERTY_VALUE, PROPERTY_VALUE);
        ATTRIBUTES.put(CssElementTypes.CSS_TAG_NAME, TAG_NAME);
        ATTRIBUTES.put(CssElementTypes.CSS_COLOR, COLOR);
        ATTRIBUTES.put(CssElementTypes.CSS_PSEUDO, PSEUDO);
        ATTRIBUTES.put(StylusTokenTypes.VARIABLE_TOKEN, VARIABLE);
        ATTRIBUTES.put(StylusTokenTypes.FOR_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.IN_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.IF_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.AND_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.ONLY_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.OR_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.EQ_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.NEQ_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.EXTEND_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.CSS_BLOCK_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.RETURN_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.ELSE_KEYWORD, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.SCOPE_TOKEN, KEYWORD);
        ATTRIBUTES.put(StylusTokenTypes.BLOCK_KEYWORD, KEYWORD);
        ATTRIBUTES.put(CssElementTypes.CSS_KEYWORD, KEYWORD);
        ATTRIBUTES.put(CssElementTypes.CSS_URI_START, KEYWORD);
        ATTRIBUTES.put(CssElementTypes.CSS_KEYFRAMES_SYM, KEYWORD);
        ATTRIBUTES.put(CssElementTypes.CSS_FUNCTION_TOKEN, FUNCTION_NAME);
        ATTRIBUTES.put(CssElementTypes.CSS_EQ, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.EQQ, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.GE, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.LE, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.LT, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_GT, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.NEQ, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.AND, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_PLUS, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_MINUS, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_ASTERISK, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_SLASH, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.NOT, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.OR, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.POWER, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.SPLAT, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.PLUS_EQ, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.MINUS_EQ, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.CONDITIONAL_EQ, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.DIV_EQ, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.PERCENT_EQ, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_CONTAINS, OPERATOR);
        ATTRIBUTES.put(StylusTokenTypes.QUESTION, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_PERCENT, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_TILDA, OPERATOR);
        ATTRIBUTES.put(CssElementTypes.CSS_COLON, OPERATOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/stylus/StylusSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedTokenAttributes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

