/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.services;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.intellij.datalore.models.SyncEntity;
import com.jetbrains.intellij.datalore.models.WorkbookInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/intellij/datalore/services/SyncService;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "commitChanges", "", "info", "Lcom/jetbrains/intellij/datalore/models/WorkbookInfo;", "createSync", "getChanges", "", "getEntity", "Lcom/jetbrains/intellij/datalore/models/SyncEntity;", "updateCommitHash", "", "Companion", "datalore-intellij-plugin"})
public final class SyncService {
    private final Project myProject;
    private static final Logger LOG;
    public static final Companion Companion;

    public final boolean createSync(@NotNull WorkbookInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)info), (String)"info");
        SyncEntity syncEntity = this.getEntity(info);
        return syncEntity != null ? syncEntity.applyAllFiles() : false;
    }

    @Nullable
    public final String getChanges(@NotNull WorkbookInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)info), (String)"info");
        SyncEntity syncEntity = this.getEntity(info);
        return syncEntity != null ? syncEntity.getDiff() : null;
    }

    public final boolean commitChanges(@NotNull WorkbookInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)info), (String)"info");
        SyncEntity syncEntity = this.getEntity(info);
        return syncEntity != null ? syncEntity.applyChanges() : false;
    }

    public final void updateCommitHash(@NotNull WorkbookInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)info), (String)"info");
        SyncEntity syncEntity = this.getEntity(info);
        info.setHeadHash(syncEntity != null ? syncEntity.getHeadHash() : null);
    }

    private final SyncEntity getEntity(WorkbookInfo info) {
        return SyncEntity.Companion.createEntity(this.myProject, info);
    }

    private SyncService(Project myProject) {
        this.myProject = myProject;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SyncService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(SyncService::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/intellij/datalore/services/SyncService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/intellij/datalore/services/SyncService;", "project", "Lcom/intellij/openapi/project/Project;", "datalore-intellij-plugin"})
    public static final class Companion {
        @NotNull
        public final SyncService getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, SyncService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026 SyncService::class.java)");
            return (SyncService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

