/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.services;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.intellij.datalore.services.FiltersKt;
import com.jetbrains.python.psi.PyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0010\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nH\u0002J\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/intellij/datalore/services/ProjectService;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "containsIPythonNotebookFiles", "", "createProjectMeta", "", "filesToVisit", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filterProjectFiles", "shouldInclude", "Lkotlin/Function1;", "getBase64Content", "file", "getBase64Map", "", "getIPythonNotebookFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getIPythonNotebookFiles", "getProjectFiles", "getProjectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getRelativePath", "getRelativeSourcePaths", "getRootPath", "getWorkbookDirectoryPath", "Ljava/nio/file/Path;", "Companion", "datalore-intellij-plugin"})
public final class ProjectService {
    private final Project myProject;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final Path getWorkbookDirectoryPath() {
        Path path = Paths.get(this.getRootPath(), ".datalore").toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(getRootPath(),\u2026_FOLDER).toAbsolutePath()");
        return path;
    }

    @Nullable
    public final Sdk getProjectSdk() {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(myProject)");
        return projectRootManager.getProjectSdk();
    }

    @NotNull
    public final Collection<VirtualFile> getProjectFiles() {
        return this.filterProjectFiles((Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(this){
            final /* synthetic */ ProjectService this$0;

            public final boolean invoke(@NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                return !FiltersKt.isIgnoredFile(ProjectService.access$getMyProject$p(this.this$0), file);
            }
            {
                this.this$0 = projectService;
                super(1);
            }
        }));
    }

    @NotNull
    public final Map<String, String> getBase64Map() {
        boolean bl = false;
        Map result = new LinkedHashMap();
        Iterable $this$forEach$iv = this.getProjectFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String content;
            String path;
            VirtualFile file = (VirtualFile)element$iv;
            boolean bl2 = false;
            if (this.getBase64Content(file) == null) {
                continue;
            }
            if (this.getRelativePath(file) == null) {
                continue;
            }
            result.put(path, content);
        }
        return result;
    }

    @Nullable
    public final String getRelativePath(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getContentRootForFile(file);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"ProjectFileIndex.SERVICE\u2026File(file) ?: return null");
        VirtualFile contentRootForFile = virtualFile;
        return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRootForFile);
    }

    @NotNull
    public final String getRootPath() {
        VirtualFile virtualFile = this.myProject.getBaseDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"myProject.baseDir");
        String string = virtualFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myProject.baseDir.path");
        return string;
    }

    @NotNull
    public final String createProjectMeta() {
        Object object;
        block5: {
            block4: {
                object = this.getRelativeSourcePaths();
                if (object == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)":", null, null, (int)0, null, null, (int)62, null)) == null) break block4;
                Object object2 = object;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Object object3 = object2;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object3).getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object = byArray;
                if (byArray == null) break block4;
                object2 = object;
                boolean bl2 = false;
                bl = false;
                Object it = object2;
                boolean bl3 = false;
                object = Base64.getEncoder().encodeToString((byte[])it);
                if (object != null) break block5;
            }
            object = "";
        }
        return object;
    }

    public final boolean containsIPythonNotebookFiles() {
        return FileTypeIndex.containsFileOfType((FileType)this.getIPythonNotebookFileType(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
    }

    @NotNull
    public final Collection<VirtualFile> getIPythonNotebookFiles() {
        Collection collection = FileTypeIndex.getFiles((FileType)this.getIPythonNotebookFileType(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FileTypeIndex.getFiles(g\u2026.projectScope(myProject))");
        return collection;
    }

    private final FileType getIPythonNotebookFileType() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension("ipynb");
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"FileTypeManager.getInsta\u2026eTypeByExtension(\"ipynb\")");
        return fileType;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFile> filesToVisit() {
        void $this$flatMapTo$iv$iv;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstanc\u2026oject)\n          .modules");
        Module[] $this$flatMap$iv = moduleArray;
        boolean $i$f$flatMap = false;
        Module[] moduleArray2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var6_6 = $this$flatMapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void module = element$iv$iv = var6_6[i];
            boolean bl = false;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            Object[] objectArray = moduleRootManager.getContentRoots();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ModuleRootManager.getInstance(module).contentRoots");
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Collection<VirtualFile> filterProjectFiles(Function1<? super VirtualFile, Boolean> shouldInclude) {
        boolean bl = false;
        List result = new ArrayList();
        Iterable $this$forEach$iv = this.filesToVisit();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file = (VirtualFile)element$iv;
            boolean bl2 = false;
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0], shouldInclude, result){
                final /* synthetic */ Function1 $shouldInclude$inlined;
                final /* synthetic */ List $result$inlined;
                {
                    this.$shouldInclude$inlined = function1;
                    this.$result$inlined = list;
                    super($super_call_param$1);
                }

                public boolean visitFile(@NotNull VirtualFile file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    if (((Boolean)this.$shouldInclude$inlined.invoke((Object)file)).booleanValue()) {
                        this.$result$inlined.add(file);
                    }
                    return true;
                }
            }));
        }
        return result;
    }

    private final String getBase64Content(VirtualFile file) {
        String string;
        try {
            string = Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)file.getInputStream()));
        }
        catch (IOException e) {
            LOG.error("Could not encode file " + file.getName() + ": " + e.getMessage());
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> getRelativeSourcePaths() {
        void $this$flatMapTo$iv$iv;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstanc\u2026oject)\n          .modules");
        Module[] $this$flatMap$iv = moduleArray;
        boolean $i$f$flatMap = false;
        Module[] moduleArray2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var6_6 = $this$flatMapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void $this$mapNotNullTo$iv$iv;
            void element$iv$iv;
            void module = element$iv$iv = var6_6[i];
            boolean bl = false;
            Collection collection = PyUtil.getSourceRoots((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"PyUtil.getSourceRoots(module)");
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                VirtualFile it = (VirtualFile)element$iv$iv2;
                boolean bl3 = false;
                VirtualFile virtualFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                if (this.getRelativePath(virtualFile) == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                String it$iv$iv = string;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private ProjectService(Project myProject) {
        this.myProject = myProject;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ProjectService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(ProjectService::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Project access$getMyProject$p(ProjectService $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/intellij/datalore/services/ProjectService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getFileContent", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lcom/jetbrains/intellij/datalore/services/ProjectService;", "project", "Lcom/intellij/openapi/project/Project;", "saveAllFiles", "", "datalore-intellij-plugin"})
    public static final class Companion {
        @NotNull
        public final ProjectService getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, ProjectService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ojectService::class.java)");
            return (ProjectService)object;
        }

        @Nullable
        public final String getFileContent(@NotNull VirtualFile file) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            try {
                byte[] byArray = file.contentsToByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray()");
                object = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                boolean bl = false;
                object = new String((byte[])object, charset2);
            }
            catch (IOException e) {
                LOG.error("Couldn't read file " + file.getName() + ": " + e.getMessage());
                object = null;
            }
            return object;
        }

        public final void saveAllFiles() {
            FileDocumentManager.getInstance().saveAllDocuments();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

