/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.api;

import com.jetbrains.intellij.datalore.config.DataloreEndpoint;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/intellij/datalore/api/AbstractRequests;", "", "()V", "buildUrl", "", "endpoint", "Lcom/jetbrains/intellij/datalore/config/DataloreEndpoint;", "getBinaryEntity", "Lorg/apache/http/HttpEntity;", "content", "", "getBinaryMultipartEntity", "name", "filename", "getJsonEntity", "json", "Companion", "datalore-intellij-plugin"})
public abstract class AbstractRequests {
    private static final List<Integer> STANDARD_PORTS;
    public static final Companion Companion;

    @NotNull
    public final String buildUrl(@NotNull DataloreEndpoint endpoint) {
        Intrinsics.checkParameterIsNotNull((Object)endpoint, (String)"endpoint");
        return STANDARD_PORTS.contains(endpoint.getPort()) ? endpoint.getUrl() : endpoint.getUrl() + ':' + endpoint.getPort();
    }

    @NotNull
    public final HttpEntity getJsonEntity(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        HttpEntity httpEntity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(json).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"EntityBuilder.create()\n \u2026(json)\n          .build()");
        return httpEntity;
    }

    @NotNull
    public final HttpEntity getBinaryEntity(@NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        HttpEntity httpEntity = EntityBuilder.create().setBinary(content).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"EntityBuilder.create()\n \u2026ntent)\n          .build()");
        return httpEntity;
    }

    @NotNull
    public final HttpEntity getBinaryMultipartEntity(@NotNull String name, @NotNull byte[] content, @NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        HttpEntity httpEntity = MultipartEntityBuilder.create().addBinaryBody(name, content, ContentType.DEFAULT_BINARY, filename).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"MultipartEntityBuilder.c\u2026ename)\n          .build()");
        return httpEntity;
    }

    static {
        Companion = new Companion(null);
        STANDARD_PORTS = CollectionsKt.listOf((Object[])new Integer[]{80, 443});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/intellij/datalore/api/AbstractRequests$Companion;", "", "()V", "STANDARD_PORTS", "", "", "datalore-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

