/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.publishing.handlers;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.GetMetaException;
import com.jetbrains.intellij.datalore.api.InvalidTokenException;
import com.jetbrains.intellij.datalore.api.NotExistingNotebookException;
import com.jetbrains.intellij.datalore.forms.PublishingShareSettingsDialog;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.PublishingService;
import com.jetbrains.intellij.datalore.util.BackgroundableCancellableTaskWithTimer;
import com.jetbrains.intellij.datalore.util.DataloreIconsKt;
import com.jetbrains.intellij.datalore.util.NotificationUtil;
import com.jetbrains.intellij.datalore.util.StringUtilKt;
import com.jetbrains.intellij.datalore.util.VirtualFileUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/handlers/PublishingManageAccessRightsHandler;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myNotebook", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "myAuthService", "Lcom/jetbrains/intellij/datalore/services/AuthService;", "myPublishingService", "Lcom/jetbrains/intellij/datalore/services/PublishingService;", "fireDeleted", "", "handle", "onFail", "onNoState", "datalore-intellij-plugin"})
public class PublishingManageAccessRightsHandler {
    private final PublishingService myPublishingService;
    private final AuthService myAuthService;
    private final Project myProject;
    private final VirtualFile myNotebook;

    public final void handle() {
        if (!VirtualFileUtilKt.isIPython(this.myNotebook)) {
            return;
        }
        CloseableHttpClient client = HttpClients.createDefault();
        BackgroundableCancellableTaskWithTimer checkStatusTask2 = new BackgroundableCancellableTaskWithTimer(this, client, this.myProject, DataloreBundle.INSTANCE.message("datalore.publishing.common.getting_meta.progress", new Object[0])){
            final /* synthetic */ PublishingManageAccessRightsHandler this$0;
            final /* synthetic */ CloseableHttpClient $client;

            protected void doRun(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                try {
                    PublishingService publishingService = PublishingManageAccessRightsHandler.access$getMyPublishingService$p(this.this$0);
                    VirtualFile virtualFile = PublishingManageAccessRightsHandler.access$getMyNotebook$p(this.this$0);
                    CloseableHttpClient closeableHttpClient = this.$client;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"client");
                    if (publishingService.fetchAndUpdateNotebookStatus(virtualFile, (HttpClient)closeableHttpClient) == null) {
                        throw (Throwable)new GetMetaException();
                    }
                }
                catch (NotExistingNotebookException e) {
                    PublishingManageAccessRightsHandler.access$fireDeleted(this.this$0);
                    this.this$0.onNoState();
                    throw (Throwable)e;
                }
                catch (InvalidTokenException e) {
                    AuthService authService = PublishingManageAccessRightsHandler.access$getMyAuthService$p(this.this$0);
                    Project project = this.myProject;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                    authService.fireInvalidTokenNotification(project);
                    throw (Throwable)e;
                }
            }

            protected void doOnCancel() {
                this.$client.close();
            }

            public void onSuccess() {
                PublishingService.PublishedNotebookState state = PublishingManageAccessRightsHandler.access$getMyPublishingService$p(this.this$0).getNotebookState(PublishingManageAccessRightsHandler.access$getMyNotebook$p(this.this$0));
                if (state == null) {
                    PublishingManageAccessRightsHandler.access$fireDeleted(this.this$0);
                    this.this$0.onNoState();
                } else {
                    Project project = this.myProject;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myProject");
                    PublishingShareSettingsDialog shareSettingDialog = new PublishingShareSettingsDialog(project, PublishingManageAccessRightsHandler.access$getMyNotebook$p(this.this$0), state);
                    shareSettingDialog.show();
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                if (error instanceof GetMetaException) {
                    PublishingManageAccessRightsHandler.access$onFail(this.this$0);
                }
                super.onThrowable(error);
            }
            {
                this.this$0 = $outer;
                this.$client = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, 0L, 0L, false, 28, null);
            }
        };
        checkStatusTask2.queue();
    }

    protected void onNoState() {
    }

    private final void onFail() {
        new Notification(NotificationUtil.INSTANCE.getDATALORE_NOTIFICATION_GROUP().getDisplayId(), DataloreIconsKt.getFAIL_ICON(), DataloreBundle.INSTANCE.message("datalore.publishing.manage_access_rights.notification.error.title", StringUtilKt.trimInMiddle(this.myNotebook, 23)), null, DataloreBundle.INSTANCE.message("datalore.publishing.common.notification.getting_meta.fail", new Object[0]), NotificationType.ERROR, null).notify(this.myProject);
    }

    private final void fireDeleted() {
        this.myPublishingService.fireNotebookDeletedNotification(this.myNotebook, DataloreBundle.INSTANCE.message("datalore.publishing.manage_access_rights.notification.error.title", StringUtilKt.trimInMiddle(this.myNotebook, 23)));
    }

    public PublishingManageAccessRightsHandler(@NotNull Project myProject, @NotNull VirtualFile myNotebook) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)myNotebook, (String)"myNotebook");
        this.myProject = myProject;
        this.myNotebook = myNotebook;
        this.myPublishingService = PublishingService.Companion.getInstance(this.myProject);
        this.myAuthService = AuthService.Companion.getInstance();
    }

    public static final /* synthetic */ PublishingService access$getMyPublishingService$p(PublishingManageAccessRightsHandler $this) {
        return $this.myPublishingService;
    }

    public static final /* synthetic */ VirtualFile access$getMyNotebook$p(PublishingManageAccessRightsHandler $this) {
        return $this.myNotebook;
    }

    public static final /* synthetic */ void access$fireDeleted(PublishingManageAccessRightsHandler $this) {
        $this.fireDeleted();
    }

    public static final /* synthetic */ AuthService access$getMyAuthService$p(PublishingManageAccessRightsHandler $this) {
        return $this.myAuthService;
    }

    public static final /* synthetic */ void access$onFail(PublishingManageAccessRightsHandler $this) {
        $this.onFail();
    }
}

