/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.publishing;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.AuthorizedPublishingAction;
import com.jetbrains.intellij.datalore.actions.publishing.PublishingCopyLinkAction;
import com.jetbrains.intellij.datalore.actions.publishing.PublishingManageAccessRightsAction;
import com.jetbrains.intellij.datalore.actions.publishing.PublishingOpenLinkAction;
import com.jetbrains.intellij.datalore.actions.publishing.PublishingUpdateAction;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.PublishingService;
import com.jetbrains.intellij.datalore.util.DataloreIconsKt;
import com.jetbrains.intellij.datalore.util.VirtualFileUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/PublishingContextMenuAction;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "()V", "myAuthService", "Lcom/jetbrains/intellij/datalore/services/AuthService;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "", "datalore-intellij-plugin"})
public final class PublishingContextMenuAction
extends ActionGroup {
    private final AuthService myAuthService = AuthService.Companion.getInstance();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        VirtualFile virtualFile = VirtualFileUtilKt.getVirtualFile(e);
        if (virtualFile == null) {
            return;
        }
        VirtualFile notebook = virtualFile;
        PublishingService publishingService = PublishingService.Companion.getInstance(project2);
        boolean shouldShow = this.myAuthService.isPublishedSignedIn() ? publishingService.isUploadedForOwner(notebook) : publishingService.isUploadedBySomeone(notebook);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(VirtualFileUtilKt.isIPython(notebook) && shouldShow);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        AnAction[] uploadedActions = new AnAction[]{new PublishingUpdateAction(), new PublishingOpenLinkAction(), new PublishingCopyLinkAction(), new PublishingManageAccessRightsAction()};
        if (this.myAuthService.isPublishedSignedIn()) {
            anActionArray = uploadedActions;
        } else {
            SpreadBuilder spreadBuilder = new SpreadBuilder(3);
            spreadBuilder.add((Object)new AuthorizedPublishingAction(DataloreBundle.INSTANCE.message("datalore.publishing.action.sign_in.title", new Object[0]), DataloreBundle.INSTANCE.message("datalore.publishing.action.sign_in.description", new Object[0]), DataloreIconsKt.getCOMMON_ICON()){});
            spreadBuilder.add((Object)((AnAction)new Separator()));
            spreadBuilder.addSpread((Object)uploadedActions);
            anActionArray = (AnAction[])spreadBuilder.toArray((Object[])new AnAction[spreadBuilder.size()]);
        }
        return anActionArray;
    }

    public PublishingContextMenuAction() {
        super(DataloreBundle.INSTANCE.message("datalore.publishing.action.context.title", new Object[0]), DataloreBundle.INSTANCE.message("datalore.publishing.action.context.description", new Object[0]), DataloreIconsKt.getCOMMON_ICON());
    }
}

