/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.publishing;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.publishing.AuthorizedPublishingAction;
import com.jetbrains.intellij.datalore.actions.publishing.handlers.PublishingUploadHandler;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.ProjectService;
import com.jetbrains.intellij.datalore.services.PublishingService;
import com.jetbrains.intellij.datalore.util.DataloreIconsKt;
import com.jetbrains.intellij.datalore.util.VirtualFileUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/intellij/datalore/actions/publishing/PublishJupyterNotebookAction;", "Lcom/jetbrains/intellij/datalore/actions/publishing/AuthorizedPublishingAction;", "()V", "myAuthService", "Lcom/jetbrains/intellij/datalore/services/AuthService;", "doAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "datalore-intellij-plugin"})
public final class PublishJupyterNotebookAction
extends AuthorizedPublishingAction {
    private final AuthService myAuthService = AuthService.Companion.getInstance();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        VirtualFile virtualFile = VirtualFileUtilKt.getVirtualFile(e);
        if (virtualFile == null) {
            return;
        }
        VirtualFile notebook = virtualFile;
        PublishingService publishingService = PublishingService.Companion.getInstance(project2);
        boolean shouldShow = this.myAuthService.isPublishedSignedIn() ? !publishingService.isUploadedForOwner(notebook) : !publishingService.isUploadedBySomeone(notebook);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(VirtualFileUtilKt.isIPython(notebook) && shouldShow);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        Presentation presentation3 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
        presentation2.setEnabled(presentation3.isEnabled() && !publishingService.isLocked(notebook));
    }

    @Override
    protected void doAction(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        VirtualFile virtualFile = VirtualFileUtilKt.getVirtualFile(e);
        if (virtualFile == null) {
            return;
        }
        VirtualFile notebook = virtualFile;
        ProjectService.Companion.saveAllFiles();
        new PublishingUploadHandler(project2, notebook).handle();
    }

    public PublishJupyterNotebookAction() {
        super(DataloreBundle.INSTANCE.message("datalore.publishing.action.upload.title", new Object[0]), DataloreBundle.INSTANCE.message("datalore.publishing.action.upload.description", new Object[0]), DataloreIconsKt.getUPLOAD_ICON(), false, 8, null);
    }
}

