/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions.handlers;

import com.intellij.openapi.project.Project;
import com.jetbrains.intellij.datalore.api.DataloreController;
import com.jetbrains.intellij.datalore.models.DataloreCreateWorkbookContext;
import com.jetbrains.intellij.datalore.models.DataloreCreateWorkbookResponse;
import com.jetbrains.intellij.datalore.models.WorkbookInfo;
import com.jetbrains.intellij.datalore.models.notebooks.DataloreWorkbookSheet;
import com.jetbrains.intellij.datalore.services.AuthService;
import com.jetbrains.intellij.datalore.services.SyncService;
import com.jetbrains.intellij.datalore.services.WorkbookService;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/intellij/datalore/actions/handlers/CreateDataloreWorkbookActionHandler;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "mySyncService", "Lcom/jetbrains/intellij/datalore/services/SyncService;", "myWorkbookService", "Lcom/jetbrains/intellij/datalore/services/WorkbookService;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "notebooks", "", "Lcom/jetbrains/intellij/datalore/models/notebooks/DataloreWorkbookSheet;", "getNotebooks", "()Ljava/util/List;", "setNotebooks", "(Ljava/util/List;)V", "createWorkbook", "Lcom/jetbrains/intellij/datalore/models/WorkbookInfo;", "datalore-intellij-plugin"})
public final class CreateDataloreWorkbookActionHandler {
    @Nullable
    private String name;
    @NotNull
    private List<DataloreWorkbookSheet> notebooks;
    private final WorkbookService myWorkbookService;
    private final SyncService mySyncService;
    private final Project myProject;

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @NotNull
    public final List<DataloreWorkbookSheet> getNotebooks() {
        return this.notebooks;
    }

    public final void setNotebooks(@NotNull List<DataloreWorkbookSheet> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.notebooks = list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final WorkbookInfo createWorkbook() {
        if (this.name == null) {
            return null;
        }
        String string = AuthService.Companion.getInstance().getToken();
        if (string == null) return null;
        String token = string;
        String string2 = this.name;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String string3 = DataloreController.INSTANCE.callCreateWorkbook(DataloreCreateWorkbookContext.Companion.create(this.myProject, string2, (Collection<DataloreWorkbookSheet>)this.notebooks), token);
        Object object = string3;
        if (string3 == null) return null;
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        String it = object2;
        boolean bl3 = false;
        DataloreCreateWorkbookResponse dataloreCreateWorkbookResponse = DataloreCreateWorkbookResponse.Companion.fromString(it);
        object = dataloreCreateWorkbookResponse;
        if (dataloreCreateWorkbookResponse == null) return null;
        object2 = object;
        bl = false;
        bl2 = false;
        Object response = object2;
        boolean bl4 = false;
        WorkbookInfo info = new WorkbookInfo(((DataloreCreateWorkbookResponse)response).getRootId(), ((DataloreCreateWorkbookResponse)response).getFileId());
        info.setName(this.name);
        this.mySyncService.createSync(info);
        this.mySyncService.updateCommitHash(info);
        this.myWorkbookService.addWorkbook(info);
        WorkbookInfo workbookInfo = info;
        return workbookInfo;
    }

    public CreateDataloreWorkbookActionHandler(@NotNull Project myProject) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.notebooks = CollectionsKt.emptyList();
        this.myWorkbookService = WorkbookService.Companion.getInstance(this.myProject);
        this.mySyncService = SyncService.Companion.getInstance(this.myProject);
    }
}

