/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class MultiUploadRequest
implements AutoCloseable {
    private final Map<String, InputStream> uploads = new HashMap<String, InputStream>();

    public MultiUploadRequest addFile(String name, InputStream in) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        this.uploads.put(name, in);
        return this;
    }

    public MultiUploadRequest addFiles(String prefix, File ... files) throws FileNotFoundException {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        for (File file : files) {
            this.addFile(prefix + file.getName(), new FileInputStream(file));
        }
        return this;
    }

    public Map<String, InputStream> getUploads() {
        return this.uploads;
    }

    @Override
    public void close() throws Exception {
        for (Map.Entry<String, InputStream> entry : this.uploads.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                System.err.println("Error closing resource for file: " + entry.getKey());
                e.printStackTrace();
            }
        }
    }
}

