/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.inline;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.sql.refactoring.inline.SqlInlineActionHandler;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCteInlineHandler
extends SqlInlineActionHandler {
    private static final String REFACTORING_NAME = "Inline CTE";
    private static final String HELP_ID = null;

    public boolean canInlineElement(PsiElement element2) {
        SqlNamedQueryDefinitionImpl q = SqlCteInlineHandler.resolveToNamedQueryDefinition(element2);
        if (q == null) {
            return false;
        }
        SqlWithClause with2 = (SqlWithClause)ObjectUtils.tryCast((Object)q.getParent(), SqlWithClause.class);
        return with2 != null && !with2.isRecursive();
    }

    public void inlineElement(@NotNull Project project, Editor editor, PsiElement element2) {
        SqlNamedQueryDefinitionImpl query;
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(0);
        }
        if ((query = SqlCteInlineHandler.resolveToNamedQueryDefinition(element2)) == null) {
            return;
        }
        Collection refs = ReferencesSearch.search((PsiElement)query, (SearchScope)query.getUseScope(), (boolean)false).findAll();
        if (refs.size() < 2) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"No usages found", (String)REFACTORING_NAME, (String)HELP_ID);
            return;
        }
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)REFACTORING_NAME, (String)REFACTORING_NAME, () -> SqlCteInlineHandler.inlineOp(project, editor, refs, query), (PsiFile[])new PsiFile[]{element2.getContainingFile()}));
    }

    @NotNull
    private static List<PsiElement> inlineSubQuery(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2, @NotNull Collection<PsiElement> alias, @NotNull SqlNamedQueryDefinitionImpl query) {
        SqlAsExpression asExpression;
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(3);
        }
        if (alias == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(4);
        }
        if (query == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(5);
        }
        SqlExpression expression = query.getExpression();
        assert (expression != null);
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        String subQueryAlias = query.getName();
        if (StringUtil.isEmpty((String)subQueryAlias)) {
            subQueryAlias = "cte_alias";
        }
        if ((asExpression = (SqlAsExpression)ObjectUtils.tryCast((Object)element2.getParent(), SqlAsExpression.class)) != null) {
            subQueryAlias = asExpression.getName();
            element2.replace((PsiElement)SqlSubqueryUtils.parenthesized(expression));
            result2.add((PsiElement)asExpression);
        } else {
            result2.add(element2.replace((PsiElement)SqlSubqueryUtils.aliased(expression, subQueryAlias)));
        }
        for (PsiElement a : alias) {
            SqlReferenceExpression identifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)a, SqlReferenceExpression.class);
            if (identifier == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Alias is not identifier", (String)REFACTORING_NAME, (String)HELP_ID);
                continue;
            }
            identifier.setName(subQueryAlias);
            result2.add((PsiElement)identifier);
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void inlineOp(@NotNull Project project, @NotNull Editor editor, @NotNull Collection<PsiReference> refs, @NotNull SqlNamedQueryDefinitionImpl query) {
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(8);
        }
        if (refs == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(9);
        }
        if (query == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(10);
        }
        ArrayList<PsiElement> substitute = new ArrayList<PsiElement>();
        ArrayList<PsiElement> alias = new ArrayList<PsiElement>();
        SqlCteInlineHandler.classifyRefs(project, editor, (PsiElement)query, refs, substitute, alias);
        if (!SqlCteInlineHandler.checkCanInline(project, editor, query, substitute)) {
            return;
        }
        List<PsiElement> res2 = SqlCteInlineHandler.inlineSubQuery(project, editor, (PsiElement)substitute.get(0), alias, query);
        SqlExpression ex = SqlCteInlineHandler.getQueryExpression(project, editor, query);
        if (ex == null) {
            return;
        }
        int offset = res2.get(0).getTextOffset() - ex.getTextRange().getStartOffset();
        ex = SqlSubqueryUtils.removeCteDefinition(query);
        ex = SqlCteInlineHandler.getExpressionFromExOrWithEx(ex);
        int caretOffset = ex.getTextRange().getStartOffset() + offset;
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(caretOffset);
        TextRange range = ex.getTextRange();
        CodeStyleManager.getInstance((Project)project).reformatText(ex.getContainingFile(), range.getStartOffset(), range.getEndOffset());
    }

    private static SqlExpression getExpressionFromExOrWithEx(SqlExpression ex) {
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)ex, SqlWithQueryExpression.class);
        SqlExpression ex2 = withEx != null ? withEx.getExpression() : null;
        return ex2 != null ? ex2 : ex;
    }

    private static SqlExpression getQueryExpression(Project project, Editor editor, SqlNamedQueryDefinitionImpl el) {
        SqlWithQueryExpression with2 = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)el.getParent().getParent(), SqlWithQueryExpression.class);
        if (with2 == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Failed to find with expression", (String)REFACTORING_NAME, (String)HELP_ID);
            return null;
        }
        return with2.getExpression();
    }

    private static void classifyRefs(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement exclude, @NotNull Collection<PsiReference> refs, @NotNull Collection<PsiElement> substitute, @NotNull Collection<PsiElement> alias) {
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(12);
        }
        if (exclude == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(13);
        }
        if (refs == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(14);
        }
        if (substitute == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(15);
        }
        if (alias == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(16);
        }
        for (PsiReference ref : refs) {
            PsiElement el = ref.getElement();
            if (el == exclude) continue;
            if (el.getNode().getElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || el.getNode().getElementType() == SqlCompositeElementTypes.SQL_REFERENCE) {
                alias.add(el);
                continue;
            }
            if (el.getNode().getElementType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
                substitute.add(el);
                continue;
            }
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Unexpected reference type", (String)REFACTORING_NAME, (String)HELP_ID);
        }
    }

    @Nullable
    private static SqlNamedQueryDefinitionImpl resolveToNamedQueryDefinition(@Nullable PsiElement element2) {
        return (SqlNamedQueryDefinitionImpl)((Object)ObjectUtils.tryCast((Object)element2, SqlNamedQueryDefinitionImpl.class));
    }

    private static boolean checkCanInline(@NotNull Project project, @NotNull Editor editor, @NotNull SqlNamedQueryDefinitionImpl query, @NotNull List<PsiElement> substitute) {
        String error2;
        if (project == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(18);
        }
        if (query == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(19);
        }
        if (substitute == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(20);
        }
        if ((error2 = SqlCteInlineHandler.getError(query, substitute)) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)error2, (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        return true;
    }

    @Nullable
    private static String getError(@NotNull SqlNamedQueryDefinitionImpl query, @NotNull List<PsiElement> substitute) {
        if (query == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(21);
        }
        if (substitute == null) {
            SqlCteInlineHandler.$$$reportNull$$$0(22);
        }
        if (substitute.size() != 1) {
            return substitute.isEmpty() ? "Nothing to inline" : "Too many places to inline";
        }
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)query.getParent().getParent(), SqlWithQueryExpression.class);
        if (withEx == null) {
            return "With clause can not be found";
        }
        if (withEx.getWithClause().isRecursive()) {
            return "Can not inline recursive CTE";
        }
        if (withEx.getExpression() == null || query.getExpression() == null) {
            return "With clause without query";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 5: 
            case 10: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/refactoring/inline/SqlCteInlineHandler";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exclude";
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/refactoring/inline/SqlCteInlineHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineSubQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inlineElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inlineSubQuery";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inlineOp";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "classifyRefs";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkCanInline";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

