/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase$smartChooseExpression$;
import com.intellij.sql.refactoring.SqlIntroduceHelper;
import com.intellij.util.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0011H$\u00a2\u0006\u0002\u0010\u0012J+\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0086\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\nH$J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u001dH\u0002J \u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0005H\u0004J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J-\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010&\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u0004\u0018\u00010\u001d*\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"Lcom/intellij/sql/refactoring/SqlIntroduceHandlerBase;", "Helper", "Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getExpressionBySelection", "Lcom/intellij/sql/psi/SqlExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/sql/psi/SqlFile;", "getHelper", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "expression", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isCalleeExpression", "", "e", "showError", "message", "showNoContainerError", "smartChooseExpression", "helper", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/sql/psi/SqlFile;Lcom/intellij/sql/refactoring/SqlIntroduceHelper;)V", "getPossiblyInjectedElement", "offset", "", "intellij.database.sql.impl"})
public abstract class SqlIntroduceHandlerBase<Helper extends SqlIntroduceHelper>
implements RefactoringActionHandler {
    @NotNull
    private final String name;

    @Nullable
    protected abstract Helper getHelper(@NotNull SqlLanguageDialectEx var1);

    protected abstract void invoke(@NotNull Project var1, @NotNull Editor var2, @NotNull SqlExpression var3);

    protected final void showError(@NotNull Project project, @NotNull Editor editor, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)"Cannot Perform Refactoring", null);
    }

    public final void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
    }

    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)((PsiElement)file))) {
            return;
        }
        if (!(file instanceof SqlFile)) {
            return;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Helper helper = this.getHelper(dialect);
        if (helper == null) {
            this.showError(project, editor, this.name + " is not supported for " + dialect.getDisplayName());
            return;
        }
        if (editor.getSelectionModel().hasSelection()) {
            SqlExpression expression = this.getExpressionBySelection(editor, (SqlFile)file);
            if (expression == null) {
                this.showError(project, editor, "Selected fragment must be a valid expression");
                return;
            }
            if (helper.findTopmostBlock((PsiElement)expression) == null) {
                this.showNoContainerError(project, editor);
                return;
            }
            this.invoke(project, editor, expression);
        } else {
            this.smartChooseExpression(project, editor, (SqlFile)file, helper);
        }
    }

    private final void showNoContainerError(Project project, Editor editor) {
        this.showError(project, editor, this.name + " is not available in this context");
    }

    private final boolean isCalleeExpression(PsiElement e) {
        return e instanceof SqlReferenceExpression && ((SqlReferenceExpression)e).getReferenceElementType() == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE;
    }

    private final PsiElement getPossiblyInjectedElement(@NotNull SqlFile $this$getPossiblyInjectedElement, int offset) {
        PsiElement psiElement = InjectedLanguageManager.getInstance((Project)$this$getPossiblyInjectedElement.getProject()).findInjectedElementAt((PsiFile)$this$getPossiblyInjectedElement, offset);
        if (psiElement == null) {
            psiElement = $this$getPossiblyInjectedElement.findElementAt(offset);
        }
        return psiElement;
    }

    private final SqlExpression getExpressionBySelection(Editor editor, SqlFile file) {
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"editor.selectionModel");
        PsiElement element1 = this.getPossiblyInjectedElement(file, selectionModel.getSelectionStart());
        SelectionModel selectionModel2 = editor.getSelectionModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel2, (String)"editor.selectionModel");
        PsiElement element2 = this.getPossiblyInjectedElement(file, selectionModel2.getSelectionEnd() - 1);
        if (element1 instanceof PsiWhiteSpace) {
            TextRange textRange = element1.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element1.getTextRange()");
            element1 = file.findElementAt(textRange.getEndOffset());
        }
        if (element2 instanceof PsiWhiteSpace) {
            TextRange textRange = element2.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element2.getTextRange()");
            element2 = file.findElementAt(textRange.getStartOffset() - 1);
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"PsiTreeUtil.findCommonPa\u2026 element2) ?: return null");
        PsiElement parent2 = psiElement;
        return (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)parent2, SqlExpression.class, (boolean)false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void smartChooseExpression(Project project, Editor editor, SqlFile file, Helper helper) {
        Sequence parents2;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement currentElement = file.findElementAt(offset);
        if (helper.findTopmostBlock(currentElement) == null) {
            this.showNoContainerError(project, editor);
            return;
        }
        Sequence $this$filterIsInstance$iv = parents2 = SequencesKt.generateSequence((Object)currentElement, (Function1)smartChooseExpression.parents.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)smartChooseExpression$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        List expressions2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<SqlExpression, Boolean>(this){
            final /* synthetic */ SqlIntroduceHandlerBase this$0;

            public final boolean invoke(@NotNull SqlExpression it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                return !SqlIntroduceHandlerBase.access$isCalleeExpression(this.this$0, (PsiElement)it2);
            }
            {
                this.this$0 = sqlIntroduceHandlerBase;
                super(1);
            }
        })));
        if (expressions2.isEmpty()) {
            this.showError(project, editor, "No valid expressions were found");
            return;
        }
        if (expressions2.size() != 1) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions2, (Pass)((Pass)new Pass<SqlExpression>(this, project, editor){
                    final /* synthetic */ SqlIntroduceHandlerBase this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Editor $editor;

                    public void pass(@NotNull SqlExpression expression) {
                        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                        this.this$0.invoke(this.$project, this.$editor, expression);
                    }
                    {
                        this.this$0 = $outer;
                        this.$project = $captured_local_variable$1;
                        this.$editor = $captured_local_variable$2;
                    }
                }), (Function)smartChooseExpression.2.INSTANCE);
                return;
            }
        }
        this.invoke(project, editor, (SqlExpression)CollectionsKt.first((List)expressions2));
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public SqlIntroduceHandlerBase(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        this.name = name2;
    }

    public static final /* synthetic */ boolean access$isCalleeExpression(SqlIntroduceHandlerBase $this, PsiElement e) {
        return $this.isCalleeExpression(e);
    }
}

