/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbColumnImpl;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.Version;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlValuesParameterInfoHandler;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.dialects.SqlDataSourceMappings;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlAnnotator;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCodeBlockElement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlImplicitDeclarationsProvider;
import com.intellij.sql.psi.SqlImplicitTarget;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlDeclareStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.psi.stubs.SqlLazyParseablePsiElement;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImplUtil {
    public static final String NULL_STRING = DasUtil.NO_NAME;
    public static final DasTable NO_TABLE = new EmptyTable();
    public static final Function<StubElement, PsiElement> STUB_TO_PSI = element2 -> element2.getPsi();
    public static final Function<SqlNameElement, String> IDENT_TO_NAME = element2 -> element2.getName();
    private static final Key<PsiElement> CURRENT_QUALIFIER = Key.create((String)"CURRENT_QUALIFIER");
    private static final Key<PsiElement> IMMEDIATE_QUALIFIER = Key.create((String)"IMMEDIATE_QUALIFIER");
    private static final Key<PsiElement> IMMEDIATE_TARGET = Key.create((String)"IMMEDIATE_TARGET");
    private static final Logger LOG = Logger.getInstance(SqlImplUtil.class);

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser() {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK));
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(0);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser(PsiElement element2) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoot((Object)element2);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(1);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlRevTraverser(PsiElement element2) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.revPsiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)).withRoot((Object)element2);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(2);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static Condition<PsiElement> byElementType(IElementType ... types) {
        if (types == null) {
            SqlImplUtil.$$$reportNull$$$0(3);
        }
        Condition condition = element2 -> ArrayUtil.contains((Object)element2.getNode().getElementType(), (Object[])types);
        if (condition == null) {
            SqlImplUtil.$$$reportNull$$$0(4);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildren(@Nullable PsiElement element2) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(element2).expandAndSkip(Conditions.is((Object)element2))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlRevChildren(@Nullable PsiElement element2) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlRevTraverser(element2).expandAndSkip(Conditions.is((Object)element2))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<SqlElement> sqlElements(@Nullable PsiElement root2) {
        SyntaxTraverser s = SqlImplUtil.sqlTraverser(root2).filterTypes(Conditions.notInstanceOf(SqlKeywordTokenType.class));
        JBIterable jBIterable = ((SyntaxTraverser)s.expand(Conditions.or((Condition)Conditions.is((Object)root2), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK))))).filter(SqlElement.class);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Nullable
    public static PsiElement sqlParent(@Nullable PsiElement e) {
        PsiElement tmp;
        PsiElement psiElement = tmp = e == null ? null : e.getParent();
        while (tmp != null) {
            if (PsiUtilCore.getElementType((PsiElement)tmp) != SqlElementTypes.SQL_DUMMY_BLOCK) {
                return tmp;
            }
            tmp = tmp.getParent();
        }
        return null;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlParents(@Nullable PsiElement e) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterable jBIterable = api.parents((Object)e).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.notEqualTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> revSiblings(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(9);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApiReversed();
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoots((Iterable)api.siblings((Object)e))).expand(Conditions.alwaysFalse())).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    public static PsiElement getBlockContentElement(@NotNull PsiElement block) {
        if (block == null) {
            SqlImplUtil.$$$reportNull$$$0(11);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (PsiElement)api.children((Object)block).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK))).first();
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element2) {
        ASTNode node = element2 == null ? null : element2.getNode();
        return node == null ? null : node.getElementType();
    }

    @NotNull
    private static <T> ResolveState getModifiedState(@NotNull ResolveState state2, Key<T> key2, T value) {
        Object qual;
        if (state2 == null) {
            SqlImplUtil.$$$reportNull$$$0(12);
        }
        if ((qual = state2.get(key2)) != null || value == null) {
            ResolveState resolveState = state2;
            if (resolveState == null) {
                SqlImplUtil.$$$reportNull$$$0(13);
            }
            return resolveState;
        }
        ResolveState resolveState = state2.put(key2, value);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(14);
        }
        return resolveState;
    }

    @NotNull
    public static ResolveState setQualifier(@NotNull ResolveState state2, @Nullable PsiElement qualifier) {
        if (state2 == null) {
            SqlImplUtil.$$$reportNull$$$0(15);
        }
        ResolveState resolveState = SqlImplUtil.getModifiedState(state2, CURRENT_QUALIFIER, qualifier);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(16);
        }
        return resolveState;
    }

    @NotNull
    public static ResolveState setImmediateQualifier(@NotNull ResolveState state2, @Nullable PsiElement qualifier) {
        if (state2 == null) {
            SqlImplUtil.$$$reportNull$$$0(17);
        }
        ResolveState resolveState = SqlImplUtil.getModifiedState(state2, IMMEDIATE_QUALIFIER, qualifier);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(18);
        }
        return resolveState;
    }

    @Nullable
    public static PsiElement getImmediateTarget(@NotNull ResolveState state2) {
        if (state2 == null) {
            SqlImplUtil.$$$reportNull$$$0(19);
        }
        return (PsiElement)state2.get(IMMEDIATE_TARGET);
    }

    @Nullable
    public static PsiElement getImmediateQualifier(@NotNull ResolveState state2) {
        if (state2 == null) {
            SqlImplUtil.$$$reportNull$$$0(20);
        }
        return (PsiElement)state2.get(IMMEDIATE_QUALIFIER);
    }

    @NotNull
    public static ResolveState setImmediateTarget(@NotNull ResolveState state2, @Nullable PsiElement immediateTarget) {
        if (state2 == null) {
            SqlImplUtil.$$$reportNull$$$0(21);
        }
        ResolveState resolveState = SqlImplUtil.getModifiedState(state2, IMMEDIATE_TARGET, immediateTarget);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(22);
        }
        return resolveState;
    }

    @Nullable
    public static PsiElement getQualifier(@NotNull ResolveState state2) {
        if (state2 == null) {
            SqlImplUtil.$$$reportNull$$$0(23);
        }
        return (PsiElement)state2.get(CURRENT_QUALIFIER);
    }

    @Nullable
    public static PsiElement getQualifier(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getQualifier() : null;
    }

    @Nullable
    public static PsiElement getImmediateTarget(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getImmediateTarget() : null;
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> resolveQualified(@Nullable SqlReferenceExpression ref) {
        ResolveResult[] results2;
        ResolveResult[] resolveResultArray = results2 = ref == null ? null : ref.multiResolve(false);
        if (results2 == null || results2.length == 0) {
            List<Pair<PsiElement, PsiElement>> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(24);
            }
            return list;
        }
        ArrayList<Pair<PsiElement, PsiElement>> res2 = new ArrayList<Pair<PsiElement, PsiElement>>();
        for (ResolveResult result2 : results2) {
            res2.add((Pair<PsiElement, PsiElement>)Pair.create((Object)SqlImplUtil.getQualifier(result2), (Object)result2.getElement()));
        }
        ArrayList<Pair<PsiElement, PsiElement>> arrayList = res2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    public static int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, @NotNull Set<ObjectKind> ignored, Set<? super ObjectKind> result2) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(26);
        }
        if (ignored == null) {
            SqlImplUtil.$$$reportNull$$$0(27);
        }
        if (maxLevel > 0 && minLevel > maxLevel) {
            throw new IllegalArgumentException();
        }
        if (minLevel <= 0) {
            result2.add((ObjectKind)type);
        }
        if (maxLevel == 0) {
            return 0;
        }
        LinkedList queue = new LinkedList();
        dialect.getParentDbTypes(queue, type);
        queue.removeAll(ignored);
        int curLevel = 0;
        int curSize = queue.size();
        LinkedHashSet<ObjectKind> levelSet = new LinkedHashSet<ObjectKind>();
        while (!queue.isEmpty()) {
            ObjectKind cur = (ObjectKind)queue.removeFirst();
            boolean isAdded = levelSet.add(cur);
            if (--curSize == 0) {
                if (minLevel <= ++curLevel && (maxLevel < 0 || curLevel <= maxLevel) && !result2.addAll(levelSet)) break;
                levelSet.clear();
            }
            if (maxLevel > -1 && curLevel == maxLevel) break;
            if (isAdded) {
                dialect.getParentDbTypes(queue, cur);
            }
            if (curSize != 0) continue;
            curSize = queue.size();
        }
        return curLevel;
    }

    @NotNull
    public static CasingProvider getCasingProvider(@NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<? extends DbDataSource> dataSources2) {
        DbDataSource dataSource;
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(28);
        }
        if (dataSources2 == null) {
            SqlImplUtil.$$$reportNull$$$0(29);
        }
        DasModel model = (dataSource = (DbDataSource)Iterables.getFirst(dataSources2, null)) == null ? DasUtil.emptyModel() : dataSource.getModel();
        SqlLanguageDialectEx sqlLanguageDialectEx = model == DasUtil.emptyModel() ? dialect : model;
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(30);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheLeftOfType(@Nullable PsiElement element2, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(31);
        }
        if (element2 == null) {
            return null;
        }
        for (PsiElement psiElement = element2.getPrevSibling(); psiElement != null; psiElement = psiElement.getPrevSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element2, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(32);
        }
        return SqlImplUtil.getSiblingToTheRightOfType(element2, strict, null, classes);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element2, boolean strict, @Nullable Condition<? super PsiElement> skip, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(33);
        }
        if (element2 == null) {
            return null;
        }
        for (PsiElement psiElement = element2.getNextSibling(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement || skip != null && skip.value((Object)psiElement)) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    public static Collection<PsiElement> getReferencedElements(@NotNull SqlDefinition o) {
        SqlNameElement nameElement;
        PsiReference reference;
        SqlFileImpl.FakeDefinition mirror;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(34);
        }
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        Couple<SqlFileImpl.FakeDefinition> mirrorPair = SqlImplUtil.getMirror(o);
        SqlFileImpl.FakeDefinition fakeDefinition = mirrorPair.second != null ? (SqlFileImpl.FakeDefinition)((Object)mirrorPair.second) : (mirror = o.getKind() == ObjectKind.BODY ? (SqlFileImpl.FakeDefinition)((Object)mirrorPair.first) : null);
        if (mirror != null) {
            result2.add((PsiElement)mirror);
            mirror.delegates().addAllTo(result2);
        }
        PsiReference psiReference = reference = (nameElement = o.getNameElement()) != null && nameElement.getTextLength() > 0 ? nameElement.findReferenceAt(nameElement.getTextLength() - 1) : null;
        if (reference != null) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results2;
                for (ResolveResult resolveResult : results2 = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element2 = resolveResult.getElement();
                    result2.add(element2);
                }
            } else {
                PsiElement element3 = reference.resolve();
                result2.add(element3);
            }
        }
        return result2;
    }

    @NotNull
    public static Couple<SqlFileImpl.FakeDefinition> getMirror(@NotNull SqlDefinition o) {
        PsiFile file;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(35);
        }
        if ((file = o.getContainingFile()) instanceof SqlFileImpl) {
            Couple<SqlFileImpl.FakeDefinition> couple = ((SqlFileImpl)file).getMirror(o);
            if (couple == null) {
                SqlImplUtil.$$$reportNull$$$0(36);
            }
            return couple;
        }
        Couple couple = Couple.getEmpty();
        if (couple == null) {
            SqlImplUtil.$$$reportNull$$$0(37);
        }
        return couple;
    }

    public static boolean processObjectParents(PsiElement object, PsiScopeProcessor processor, ResolveState resolveState) {
        while (object != null) {
            if (!processor.execute(object, resolveState)) {
                return false;
            }
            if (!(object instanceof DasObject)) break;
            object = (PsiElement)ObjectUtils.tryCast((Object)((DasObject)object).getDasParent(), PsiElement.class);
        }
        return true;
    }

    public static boolean processQualifier(SqlReferenceExpression reference, PsiScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            return true;
        }
        ObjectKind kind = reference.getReferenceElementType().getTargetKind();
        if (kind != SqlDbElementType.ANY) {
            if (!SqlImplUtil.isProcessingChildOf(processor, kind)) {
                return true;
            }
        } else {
            ObjectKind expected;
            boolean found = false;
            Iterator<ObjectKind> iterator = ((SqlReferenceImpl)reference.getReference()).getExpectedTypes(true).iterator();
            while (iterator.hasNext() && !(found = SqlImplUtil.isProcessingChildOf(processor, expected = iterator.next()))) {
            }
            if (!found) {
                return true;
            }
        }
        if (PsiTreeUtil.isContextAncestor((PsiElement)reference, (PsiElement)place, (boolean)false)) {
            return true;
        }
        try {
            return SqlImplUtil.processQualifierImpl(reference, processor, resolveState, place);
        }
        catch (StackOverflowError e) {
            PsiElement placeParent = place.getParent();
            PsiElement referenceParent = reference.getParent();
            LOG.error("SOE while processing qualifier", (Throwable)e, new Attachment[]{new Attachment("place parent", SqlImplUtil.getInfo(placeParent) + "\n" + SqlImplUtil.getInfo(placeParent == null ? null : placeParent.getParent())), new Attachment("reference parent", SqlImplUtil.getInfo(referenceParent) + "\n" + SqlImplUtil.getInfo(referenceParent == null ? null : referenceParent.getParent()))});
            return true;
        }
    }

    @NotNull
    private static String getInfo(PsiElement placeParent) {
        String string = placeParent == null ? "" : placeParent.getText() + "\n" + PsiUtilCore.getElementType((PsiElement)placeParent);
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    static boolean processQualifierImpl(@NotNull SqlReferenceExpression reference, PsiScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            SqlImplUtil.$$$reportNull$$$0(39);
        }
        ResolveResult[] results2 = reference.multiResolve(false);
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class);
        PsiElement immediateQualifier = reference.getReference().resolveImmediate();
        ResolveState immediateQualifiedState = SqlImplUtil.setImmediateQualifier(resolveState, immediateQualifier);
        if (!SqlImplUtil.processDeclarationsInType((SqlExpression)reference, processor, immediateQualifiedState, place)) {
            return false;
        }
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(sqlProcessor);
        for (ResolveResult result2 : results2) {
            DbNamespaceImpl schemaElement;
            PsiElement qualifier = result2.getElement();
            ResolveState qualifiedState = SqlImplUtil.setQualifier(resolveState, qualifier);
            processor.handleEvent(SqlScopeProcessor.RESOLVE_CONTEXT, (Object)qualifier);
            if (qualifier == null || !qualifier.isValid() || qualifier instanceof DasSynonym && ((qualifier = (PsiElement)DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)qualifier))) == null || !qualifier.isValid())) continue;
            if (qualifier != reference && !qualifier.processDeclarations(processor, qualifiedState, null, place)) {
                return false;
            }
            if (qualifier instanceof DasTable) {
                if (!SqlImplUtil.processAlterStatements(processor, qualifiedState, place, (DasObject)qualifier)) {
                    return false;
                }
                PsiFile qualFile = qualifier.getContainingFile();
                PsiFile placeFile = place.getContainingFile();
                if (!SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifier, qualFile)) {
                    return false;
                }
                if (qualFile != placeFile && !SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifier, placeFile)) {
                    return false;
                }
            }
            if ((schemaElement = (DbNamespaceImpl)((Object)ObjectUtils.tryCast((Object)qualifier, DbNamespaceImpl.class))) == null || schemaElement.getKind() != ObjectKind.SCHEMA || !majorChildExpected || SqlImplUtil.processSchemaMajorChildren(sqlProcessor, schemaElement.createDeclarationProcessor(processor, qualifiedState, null, place), schemaElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMajorChildExpected(@Nullable PsiScopeProcessor processor) {
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class);
        if (sqlProcessor == null) {
            return false;
        }
        Set<ObjectKind> expectedTypes = sqlProcessor.getExpectedTypes();
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        for (ObjectKind type : expectedTypes) {
            if (!sqlProcessor.dialect.isMajorChild(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean processOnTableCreateStatements(PsiScopeProcessor processor, ResolveState resolveState, PsiElement qualifier, PsiFile containingFile) {
        PsiFile psiFile = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
        if (containingFile instanceof SqlFile) {
            for (SqlElement statement : ((SqlFile)containingFile).getDdl()) {
                SqlReferenceExpression ref;
                if (!(statement instanceof SqlTargetContextProvider) || (ref = ((SqlTargetContextProvider)statement).getTargetContextExpression()) == null || !ref.getReference().isReferenceTo(qualifier) || processor.execute((PsiElement)statement, resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processAlterStatements(PsiScopeProcessor processor, ResolveState resolveState, PsiElement place, DasObject qualifier) {
        return SqlImplUtil.processAlterStatements(place.getContainingFile(), place, qualifier, (Processor<? super SqlAlterInstruction>)((Processor)instruction2 -> instruction2.processDeclarations(processor, resolveState, null, place)));
    }

    public static boolean processAlterStatements(PsiFile file, PsiElement place, DasObject qualifierTarget, Processor<? super SqlAlterInstruction> processor) {
        if (!(file instanceof SqlFile)) {
            return true;
        }
        SqlFile original = (SqlFile)ObjectUtils.tryCast((Object)file.getOriginalFile(), SqlFile.class);
        if (original == null) {
            return true;
        }
        NameChecker checker = new NameChecker(qualifierTarget, original.getSqlLanguage());
        for (SqlElement ddl : original.getDdl()) {
            SqlReferenceExpression target2;
            SqlAlterStatement statement = (SqlAlterStatement)ObjectUtils.tryCast((Object)ddl, SqlAlterStatement.class);
            if (statement == null || place != null && PsiTreeUtil.isContextAncestor((PsiElement)statement, (PsiElement)place, (boolean)false) || (target2 = statement.getAlterTargetReference()) == null || !checker.checkName(target2, null) || !(qualifierTarget instanceof PsiElement) || !target2.getReference().isReferenceTo((PsiElement)qualifierTarget) || ContainerUtil.process((Object[])statement.getAlterInstructions(), processor)) continue;
            return false;
        }
        return true;
    }

    public static List<PsiColumn> createColumnInfos(DasTable tableInfo, SqlTableType tableType) {
        assert (tableInfo instanceof PsiElement);
        int count2 = tableType.getColumnCount();
        ArrayList<PsiColumn> result2 = new ArrayList<PsiColumn>(count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            result2.add(new MyColumnInfo(tableInfo, i2, tableType));
        }
        return result2;
    }

    public static boolean processFromReferences(PsiScopeProcessor processor, ResolveState state2, SqlExpression fromExpression, PsiElement place, PsiElement lastParent) {
        SqlType type;
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.COLUMN, ObjectKind.TABLE)) {
            return true;
        }
        SqlType sqlType = type = fromExpression == null ? null : SqlImplUtil.getTypeLateralAware(fromExpression, place);
        if (!(type instanceof SqlTableType)) {
            return true;
        }
        ResolveState newState = state2;
        if (SqlImplUtil.isProcessingOneOf(processor, ObjectKind.COLUMN)) {
            newState = SqlImplUtil.setImmediateQualifier(newState, (PsiElement)fromExpression);
        }
        if (SqlImplUtil.isProcessingOneOf(processor, ObjectKind.TABLE)) {
            newState = SqlImplUtil.setImmediateTarget(newState, (PsiElement)fromExpression);
        }
        return SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, newState, place);
    }

    @NotNull
    public static SqlType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement end) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(40);
        }
        Object object = expression instanceof SqlLateralAwareExpression ? ((SqlLateralAwareExpression)expression).getSqlType(end) : (end != null && PsiTreeUtil.isContextAncestor((PsiElement)expression, (PsiElement)end, (boolean)false) ? SqlTableTypeBase.EMPTY_TABLE : expression.getSqlType());
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(41);
        }
        return object;
    }

    @NotNull
    public static SqlTableType createType(@NotNull List<? extends Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(42);
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(null, result2, qualifier);
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(43);
        }
        return sqlTableType;
    }

    @NotNull
    public static SqlTableType createType(final String name2, final @NotNull List<? extends Column> result2, final @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(44);
        }
        StringBuilder args2 = new StringBuilder();
        for (Column column2 : result2) {
            if (args2.length() != 0) {
                args2.append(",");
            }
            if (column2.name != null) {
                args2.append(column2.name).append(" ");
            }
            args2.append(column2.type.getDataType().getSpecification());
        }
        final DataType dataType = DataTypeFactory.ofArgs(null, "table", args2.toString(), false);
        Object object = result2.isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new SqlTableTypeBase(){

            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            @NotNull
            public List<PsiObject> getMethods() {
                List<PsiObject> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            @Nullable
            public String getTypeName() {
                return name2;
            }

            public int getColumnCount() {
                return result2.size();
            }

            public String getColumnName(int i2) {
                return ((Column)result2.get((int)i2)).name;
            }

            public boolean isColumnQuoted(int i2) {
                Column column2 = (Column)result2.get(i2);
                Boolean quoted = 1.isQuoted(column2.element);
                return quoted == null ? Boolean.TRUE.equals(1.isQuoted(column2.sourceElement)) : quoted.booleanValue();
            }

            public SqlType getColumnType(int i2) {
                return ((Column)result2.get((int)i2)).type;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                PsiElement psiElement = ((Column)result2.get((int)i2)).element;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return ((Column)result2.get((int)i2)).sourceElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(45);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static SqlTableType getSelectType(@NotNull List<? extends SqlExpression> list, @Nullable PsiElement qualifier) {
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(46);
        }
        SqlTableType result2 = SqlTableTypeBase.EMPTY_TABLE;
        for (SqlExpression sqlExpression : list) {
            boolean flatten;
            void var4_4;
            void var4_7;
            SqlColumnAliasListImpl aliasList;
            if (sqlExpression instanceof SqlAsExpression && (aliasList = (SqlColumnAliasListImpl)PsiTreeUtil.getChildOfType((PsiElement)sqlExpression, SqlColumnAliasListImpl.class)) != null) {
                for (SqlDefinition alias : aliasList.getColumnAliasList()) {
                    result2 = result2.add(SqlTableTypeBase.ensureTableType(aliasList.getAliasedSqlType(alias), (SqlElement)alias, qualifier));
                }
                continue;
            }
            Object type = sqlExpression.getSqlType();
            SqlTypeCastExpression cast = (SqlTypeCastExpression)ObjectUtils.tryCast((Object)sqlExpression, SqlTypeCastExpression.class);
            String name2 = null;
            boolean quoted = false;
            if (cast != null) {
                SqlExpression sqlExpression2 = cast.getExpression();
                SqlTypeElement element2 = cast.getTypeElement();
                if (element2 != null) {
                    name2 = element2.getDisplayName();
                }
            }
            if (var4_7 instanceof SqlFunctionCallExpression) {
                String fooName;
                SqlReferenceExpression fooRef = ((SqlFunctionCallExpression)var4_7).getNameElement();
                String string = fooName = fooRef == null ? null : fooRef.getName();
                if (fooName != null && fooName.equalsIgnoreCase("cast")) {
                    List args2;
                    SqlExpressionList params = ((SqlFunctionCallExpression)var4_7).getParameterList();
                    List list2 = args2 = params == null ? null : params.getExpressionList();
                    if (!ContainerUtil.isEmpty((Collection)args2)) {
                        SqlExpression sqlExpression3 = (SqlExpression)args2.get(0);
                    }
                }
            }
            if (name2 == null) {
                String string = var4_4 instanceof SqlNameElement ? var4_4.getName() : (name2 = var4_4 instanceof SqlDefinition ? var4_4.getName() : var4_4.getText());
                quoted = var4_4 instanceof SqlNameElement ? ((SqlNameElement)var4_4).isQuotedIdentifier() : var4_4 instanceof SqlDefinition && ((SqlDefinition)var4_4).isNameQuoted();
            }
            boolean bl = flatten = "*".equals(name2) || list.size() == 1 && SqlImplUtil.getSqlDialectSafe((PsiElement)var4_4).getDbms() != Dbms.CLICKHOUSE;
            type = flatten && type instanceof SqlTableType ? (name2 == null ? type : ((SqlTableType)type).flattenedAlias(name2, qualifier, (SqlElement)var4_4)) : SqlTableTypeBase.createType((SqlElement)var4_4, type, name2, quoted, qualifier);
            result2 = result2.add(SqlTableTypeBase.ensureTableType(type, (SqlElement)var4_4, qualifier));
        }
        if (result2 != SqlTableTypeBase.EMPTY_TABLE) {
            result2 = result2.alias(null, qualifier, Collections.emptyList());
        }
        SqlTableType sqlTableType = result2;
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(47);
        }
        return sqlTableType;
    }

    public static boolean processPositionalDeclarationInType(SqlType sqlType, PsiScopeProcessor processor, ResolveState state2, SqlPositionalReference place) {
        if (!(sqlType instanceof SqlTableType)) {
            return true;
        }
        SqlTableType tableType = (SqlTableType)sqlType;
        if (tableType instanceof SqlTableTypeBase.UnresolvedRefType) {
            processor.execute((PsiElement)place, state2);
        } else {
            int position = place.getPosition();
            if (position < 1 || position > tableType.getColumnCount()) {
                return false;
            }
            PsiElement columnSource = tableType.getSourceColumnElement(position - 1);
            PsiElement columnImmediateSource = tableType.getImmediateSourceColumnElement(position - 1);
            if (columnSource != null) {
                processor.execute(columnSource, SqlImplUtil.setImmediateTarget(state2, columnImmediateSource));
            }
        }
        return false;
    }

    public static boolean processDeclarationsInType(SqlExpression expression, PsiScopeProcessor processor, ResolveState state2, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.COLUMN, ObjectKind.TABLE, ObjectKind.ROUTINE, ObjectKind.METHOD)) {
            return true;
        }
        SqlType t = expression.getSqlType();
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)t, SqlTableType.class);
        return type == null || SqlImplUtil.processDeclarationsInType(type, processor, state2, place);
    }

    public static boolean processDeclarationsInType(SqlTableType tableType, PsiScopeProcessor processor, ResolveState state2, PsiElement place) {
        if (SqlImplUtil.isProcessingOneOf(processor, ObjectKind.ROUTINE, ObjectKind.METHOD)) {
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state2, tableType.getTypeElement());
            for (PsiObject m : tableType.getMethods()) {
                if (processor.execute((PsiElement)m, qualifiedState)) continue;
                return false;
            }
        }
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.COLUMN, ObjectKind.TABLE, ObjectKind.OBJECT_ATTRIBUTE)) {
            return true;
        }
        if (SqlImplUtil.isAsteriskRef(place)) {
            PsiElement immediateTypeElement = tableType.getImmediateTypeElement();
            PsiElement context = immediateTypeElement != null ? immediateTypeElement : place;
            PsiElement target2 = PomService.convertToPsi((Project)context.getProject(), (PomTarget)new SqlAsteriskSymbol(context, tableType));
            return processor.execute(place, SqlImplUtil.setImmediateTarget(state2, target2));
        }
        int columnCount = tableType.getColumnCount();
        if (place instanceof SqlPositionalReference) {
            return SqlImplUtil.processPositionalDeclarationInType((SqlType)tableType, processor, state2, (SqlPositionalReference)place);
        }
        PsiElement prevQualifier = null;
        for (int i2 = 0; i2 < columnCount; ++i2) {
            ResolveResult[] results2;
            PsiElement columnQualifier = tableType.getColumnQualifier(i2);
            PsiElement immediateSource = tableType.getImmediateSourceColumnElement(i2);
            ResolveState qualifiedState = SqlImplUtil.setImmediateTarget(SqlImplUtil.setQualifier(state2, columnQualifier), immediateSource);
            processor.handleEvent(SqlScopeProcessor.RESOLVE_CONTEXT, (Object)columnQualifier);
            PsiElement element2 = tableType.getColumnElement(i2);
            PsiElement sourceElement = tableType.getSourceColumnElement(i2);
            PsiElement source = element2 instanceof SqlDefinition || sourceElement == null ? element2 : sourceElement;
            ResolveResult[] resolveResultArray = results2 = source instanceof SqlReferenceExpression ? ((SqlReferenceExpression)source).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
            if (results2.length > 0) {
                for (ResolveResult result2 : results2) {
                    PsiElement target3 = result2.getElement();
                    if (target3 == null || processor.execute(target3, qualifiedState)) continue;
                    return false;
                }
            } else if (!processor.execute(source, qualifiedState)) {
                return false;
            }
            if (columnQualifier == null || columnQualifier == prevQualifier) continue;
            prevQualifier = columnQualifier;
            if (!SqlImplUtil.hasAcceptedCompletionSuggestions(processor) || !SqlImplUtil.isQualifiedContext(place)) {
                processor.execute(columnQualifier, state2);
            }
            if (SqlImplUtil.hasAcceptedCompletionSuggestions(processor) || !(columnQualifier instanceof DasTable) || SqlImplUtil.processAlterStatements(processor, state2, place, (DasObject)columnQualifier)) continue;
            return false;
        }
        return SqlImplUtil.getSqlDialectSafe(place).processTypeExtra(tableType, processor, state2, place);
    }

    private static boolean isQualifiedContext(@Nullable PsiElement place) {
        return place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getQualifierExpression() != null;
    }

    private static boolean hasAcceptedCompletionSuggestions(@Nullable PsiScopeProcessor processor) {
        return processor instanceof SqlCompletionScopeProcessor && ((SqlCompletionScopeProcessor)processor).hasAcceptedCompletionVariants();
    }

    public static void acceptChildren(SqlElement parent2, SqlVisitor visitor2) {
        for (PsiElement element2 = parent2.getFirstChild(); element2 != null; element2 = element2.getNextSibling()) {
            if (!(element2 instanceof SqlElement)) continue;
            ((SqlElement)element2).accept(visitor2);
        }
    }

    @NotNull
    public static SqlType getSqlType(@NotNull SqlTypedDefinition definition, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement place) {
        SqlType type;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(48);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(49);
        }
        if ((type = definition.getSqlType()) == SqlType.UNKNOWN || type.getCategory() == SqlType.Category.RECORD) {
            SqlType res2 = dialect.getDefinitionType(definition, place);
            SqlType sqlType = res2 == SqlType.UNKNOWN ? type : res2;
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(50);
            }
            return sqlType;
        }
        SqlType sqlType = type;
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(51);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(52);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(53);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(54);
        }
        if (object instanceof SqlTypedDefinition) {
            SqlType sqlType = ((SqlTypedDefinition)object).getSqlType();
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(55);
            }
            return sqlType;
        }
        SqlType sqlType = SqlImplUtil.getSqlType(object.getDataType(), dialect, context);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(56);
        }
        return sqlType;
    }

    @NotNull
    public static DataType getArrayElement(@NotNull DataType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(57);
        }
        if (type.getSpecification().equalsIgnoreCase("anyarray")) {
            DataType dataType = DataTypeFactory.of("anyelement");
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(58);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.of(StringUtil.trimEnd((String)type.getSpecification(), (String)"[]"));
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(59);
        }
        return dataType;
    }

    @NotNull
    public static DataType getArrayTypeOf(@NotNull DataType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(60);
        }
        if (type == DataType.UNKNOWN || type.getSpecification().equalsIgnoreCase("anyelement")) {
            DataType dataType = DataTypeFactory.of("anyarray");
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(61);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.of(type.getSpecification() + "[]");
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(62);
        }
        return dataType;
    }

    @NotNull
    public static SqlType getArrayTypeOf(@NotNull SqlType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(63);
        }
        SqlType sqlType = SqlTypeFactory.of(SqlImplUtil.getArrayTypeOf(type.getDataType()), SqlType.Category.ARRAY);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(64);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasUserDefinedType type, @NotNull PsiElement element2, @NotNull SqlLanguageDialectEx dialect) {
        JBIterable children2;
        List columns;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(65);
        }
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(66);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(67);
        }
        if (!(columns = (children2 = type.getDasChildren(null).filter(DasTypedObject.class)).filter(PsiObject.class).transform(e -> new Column(e.getName(), SqlImplUtil.getSqlType((DasTypedObject)e, dialect, (PsiElement)e), (PsiElement)e, (PsiElement)e)).toList()).isEmpty()) {
            SqlTableType sqlTableType = SqlImplUtil.createType(columns, element2);
            if (sqlTableType == null) {
                SqlImplUtil.$$$reportNull$$$0(68);
            }
            return sqlTableType;
        }
        DataType dataType = DataTypeFactory.of(type.getName());
        SqlType sqlType = type.getKind() == ObjectKind.COLLECTION_TYPE ? SqlTypeFactory.of(dataType, SqlType.Category.COLLECTION) : SqlTypeFactory.of(dataType, dialect);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(69);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(70);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(71);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(72);
        }
        SqlType sqlType = (SqlType)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)context, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.create(p2 -> SqlImplUtil.computeSqlType(context, (DataType)p2.first, (SqlLanguageDialect)p2.second), ContainerUtil::createConcurrentSoftValueMap), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))).get(Pair.create((Object)dataType, (Object)((Object)dialect)));
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(73);
        }
        return sqlType;
    }

    @NotNull
    private static SqlType computeSqlType(@NotNull PsiElement context, DataType dataType, SqlLanguageDialect language) {
        SqlTypeElement unwrapped;
        SqlTypeElement type;
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(74);
        }
        if ((type = SqlPsiElementFactory.createDataTypeFromText(dataType.getSpecification(), language, context, true)) != null) {
            SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)type.getContainingFile(), (Object)true);
        }
        Object object = (unwrapped = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)type, SqlTypeElement.class)) == null ? SqlType.UNKNOWN : unwrapped.findSqlType();
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(75);
        }
        return object;
    }

    public static boolean processDeclarationsDefault(SqlElement element2, boolean processChildrenDeclarations, PsiScopeProcessor processor, ResolveState state2, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault(element2, SqlImplUtil.childrenTreeIt((PsiElement)element2), processChildrenDeclarations, processor, state2, lastParent, place, !(element2 instanceof SqlExpression) && !(element2 instanceof SqlFromClause));
    }

    public static boolean processDeclarationsDefault(SqlElement element2, JBIterable<? extends PsiElement> notableChildren, boolean processChildrenDeclarations, PsiScopeProcessor processor, ResolveState state2, PsiElement lastParent, PsiElement place, boolean allowForwardReferences) {
        if (lastParent instanceof SqlWithClause || lastParent instanceof SqlOnTargetClauseImpl) {
            return true;
        }
        ObjectKind kind = element2 instanceof DasObject ? ((DasObject)element2).getKind() : ObjectKind.NONE;
        boolean checkLastParent = kind != ObjectKind.PACKAGE && kind != ObjectKind.OBJECT_TYPE && kind != ObjectKind.BODY && !(element2 instanceof SqlAlterInstruction);
        for (PsiElement psiElement : notableChildren) {
            PsiElement scope;
            if (checkLastParent && psiElement == lastParent) {
                if (allowForwardReferences) continue;
                break;
            }
            PsiElement psiElement2 = scope = psiElement instanceof SqlLocalDefinition ? ((SqlLocalDefinition)psiElement).getDefinitionScope() : null;
            if (scope != null && !PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)place, (boolean)true) || psiElement instanceof SqlQueryExpression) continue;
            if (psiElement instanceof PsiNamedElement ? !processor.execute(psiElement, state2) : (psiElement instanceof SqlDeclareStatementImpl || processChildrenDeclarations && (!(psiElement instanceof SqlStatement) || psiElement instanceof SqlDefinitionHolder)) && !psiElement.processDeclarations(processor, state2, lastParent, place)) {
                return false;
            }
            if (!(psiElement instanceof SqlExtraDeclarationsProvider)) continue;
            ((SqlExtraDeclarationsProvider)psiElement).processExtraDeclarations(processor, state2, lastParent, place);
        }
        if (element2 instanceof SqlImplicitDeclarationsProvider && lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)element2, (PsiElement)lastParent, (boolean)true)) {
            SqlImplicitDeclarationsProvider provider = (SqlImplicitDeclarationsProvider)element2;
            processor.handleEvent(SqlScopeProcessor.RESOLVE_CONTEXT, (Object)element2);
            SqlScopeProcessor proc = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class);
            boolean stopIfFound = proc != null && proc.referenceName != null && proc.isResultEmpty() && provider.stopProcessingIfFoundInImplicitContext();
            boolean resume = provider.processImplicitContextDeclarations(processor, state2, lastParent, place);
            return resume &= !stopIfFound || proc.isResultEmpty();
        }
        return true;
    }

    @NotNull
    public static <T> T[] toArray(@Nullable Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            SqlImplUtil.$$$reportNull$$$0(76);
        }
        Object[] objectArray = c2 != null ? c2.toArray(factory.create(c2.size())) : factory.create(0);
        if (objectArray == null) {
            SqlImplUtil.$$$reportNull$$$0(77);
        }
        return objectArray;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlReferenceList list) {
        List list2 = list == null ? Collections.emptyList() : list.getReferenceList();
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(78);
        }
        return list2;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlTableColumnsList list) {
        List<SqlReferenceExpression> list2 = list == null ? Collections.emptyList() : SqlImplUtil.getReferenceList(list.getColumnsReferenceList());
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(79);
        }
        return list2;
    }

    @NotNull
    public static List<DbDataSource> getDataSources(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(80);
        }
        PsiFile containingFile = element2.getContainingFile();
        List<DbDataSource> list = SqlDataSourceMappings.getInstance(containingFile.getProject()).getDataSources(containingFile);
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(81);
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialectSafe(@Nullable PsiElement element2) {
        SqlLanguageDialect dialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.getSqlDialect(element2), (Object)SqlDialectMappings.getDefaultSqlDialect());
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)dialect;
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(82);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static BasicMetaObject getMetaObject(@Nullable DasObject object) {
        DasObject unw = (DasObject)ObjectUtils.tryCast((Object)DbImplUtil.unwrap(object), DasObject.class);
        if (unw == null) {
            return null;
        }
        if (unw instanceof BasicElement) {
            return ((BasicElement)unw).getMetaObject();
        }
        if (unw instanceof SqlStubbedDefinitionImpl) {
            return ((SqlStubbedDefinitionImpl)unw).getMetaObject();
        }
        if (unw instanceof PsiElement) {
            ObjectKind kind;
            Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)unw).getDbms();
            BasicMetaModel metaModel = (BasicMetaModel)DbImplUtil.getMetaModel(dbms);
            ArrayList objects2 = ContainerUtil.newArrayList(metaModel.findMetaObjects(kind = unw.getKind()));
            if (objects2.size() <= 1) {
                return (BasicMetaObject)ContainerUtil.getFirstItem((List)objects2);
            }
            BasicMetaObject pMeta = SqlImplUtil.getMetaObject(unw.getDasParent());
            return BasicMetaUtils.findChild(pMeta, kind);
        }
        return null;
    }

    @NotNull
    public static JBIterable<Version> getDbVersions(@NotNull SqlFile file) {
        DbDataSource ds;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(83);
        }
        if ((ds = DbImplUtil.getForcedDataSource((PsiFile)file)) != null) {
            JBIterable jBIterable = JBIterable.of((Object)ds.getVersion());
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(84);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)file)).filterMap(DasDataSource::getVersion);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(85);
        }
        return jBIterable;
    }

    @NotNull
    public static ObjectKind getKindSynonymAware(@Nullable DasObject obj2) {
        if (obj2 instanceof SqlSynonymDefinition) {
            ObjectKind synonymTargetType;
            SqlReferenceExpression ref = ((SqlSynonymDefinition)obj2).getTargetReference();
            ObjectKind objectKind = synonymTargetType = ref != null ? ref.getReferenceElementType().getTargetKind() : null;
            if (synonymTargetType != null && synonymTargetType != SqlDbElementType.ANY) {
                ObjectKind objectKind2 = synonymTargetType;
                if (objectKind2 == null) {
                    SqlImplUtil.$$$reportNull$$$0(86);
                }
                return objectKind2;
            }
        } else if (obj2 instanceof SqlAsExpression) {
            SqlType type = ((SqlAsExpression)obj2).getSqlType();
            boolean isTable = type instanceof SqlTableType;
            if (type == SqlType.UNKNOWN) {
                PsiElement parent2 = ((SqlAsExpression)obj2).getParent();
                isTable = parent2 instanceof SqlJoinExpression || parent2 instanceof SqlFromClause;
            }
            ObjectKind objectKind = isTable ? ObjectKind.TABLE : ObjectKind.COLUMN;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(87);
            }
            return objectKind;
        }
        DasObject target2 = obj2 instanceof DasSynonym ? DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)obj2)) : obj2;
        ObjectKind objectKind = target2 == null ? SqlDbElementType.ANY : target2.getKind();
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(88);
        }
        return objectKind;
    }

    public static JBIterable<? extends PsiElement> childrenStubIt(StubElement<?> element2) {
        return JBIterable.from((Iterable)element2.getChildrenStubs()).transform(STUB_TO_PSI);
    }

    public static JBIterable<? extends PsiElement> childrenTreeIt(PsiElement element2) {
        return SqlImplUtil.sqlChildren(element2).filter(SqlCompositeElement.class);
    }

    public static JBIterable<? extends PsiElement> childrenIt(PsiElement element2) {
        StubElement stub;
        Object object = element2 instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element2).getStub() : (stub = element2 instanceof PsiFileImpl ? ((PsiFileImpl)element2).getStub() : null);
        if (stub != null) {
            return SqlImplUtil.childrenStubIt(stub);
        }
        return SqlImplUtil.childrenTreeIt(element2);
    }

    @NotNull
    static List<SqlLabelDefinitionImpl> getLabels(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(89);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)element2, () -> CachedValueProvider.Result.create(SqlImplUtil.calcLabels(element2), (Object[])new Object[]{element2}));
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(90);
        }
        return list;
    }

    @NotNull
    private static List<SqlLabelDefinitionImpl> calcLabels(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(91);
        }
        List list = SqlImplUtil.sqlTraverser(element2).filter(SqlLabelDefinitionImpl.class).toList();
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(92);
        }
        return list;
    }

    static boolean processSchemaMajorChildren(SqlScopeProcessor processor, Processor<? super DbElement> wrapper, DbElement schemaElement) {
        if (DbImplUtil.isExpandable((DasObject)schemaElement, DbImplUtil.getIntrospectionScope((DasDataSource)schemaElement.getDataSource()))) {
            Condition majorChildCondition = element2 -> processor.dialect.isMajorChild(element2.getKind());
            for (DbTable child : schemaElement.getDasChildren(ObjectKind.TABLE).filter(DbTable.class)) {
                if (ContainerUtil.process((Iterable)child.getDasChildren(null).filter(majorChildCondition), wrapper)) continue;
                return false;
            }
        }
        return true;
    }

    public static void quoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        String newName;
        PsiElement target2 = SqlAnnotator.getTargetByIdElement((PsiElement)identifier);
        if (target2 instanceof DbElement) {
            newName = ((DbElement)target2).getName();
        } else {
            newName = identifier.getName();
            if (target2 instanceof DasObject && dialect instanceof SqlLanguageDialectEx) {
                DasObject dasTarget = (DasObject)target2;
                newName = ((SqlLanguageDialectEx)dialect).getCasing((ObjectKind)dasTarget.getKind(), (DasObject)dasTarget).plain.apply(newName);
            }
        }
        String quotedName = dialect.getDatabaseDialect().quoteIdentifier(newName, true, false);
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{identifier.getContainingFile()}).run(() -> identifier.setName(quotedName));
    }

    public static void unquoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{identifier.getContainingFile()}).run(() -> {
            SqlIdentifier newId = SqlPsiElementFactory.createIdentifierFromText(identifier.getName(), dialect, project);
            if (newId != null) {
                identifier.replace((PsiElement)newId);
            }
        });
    }

    public static boolean canUnquote(@NotNull String newText, @NotNull DatabaseDialect dialect) {
        if (newText == null) {
            SqlImplUtil.$$$reportNull$$$0(93);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(94);
        }
        return StringUtil.equals((CharSequence)dialect.quoteIdentifier(newText, false, false), (CharSequence)newText);
    }

    @Nullable
    public static PsiElement getResolveScope(@Nullable PsiFile tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        PsiFile file = SqlImplUtil.getTopLevelSqlFile(tmpFile);
        PsiElement context = file.getContext();
        return context instanceof DbElement ? ((DbElement)context).getDataSource() : file;
    }

    public static PsiFile getTopLevelSqlFile(@NotNull PsiFile tmpFile) {
        PsiFile topLevelFile;
        boolean sql;
        PsiFile contextFile;
        if (tmpFile == null) {
            SqlImplUtil.$$$reportNull$$$0(95);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)tmpFile)) {
            PsiElement context = tmpFile.getContext();
            PsiFile contextFile2 = context == null ? null : context.getContainingFile();
            return contextFile2 == null ? tmpFile : contextFile2;
        }
        if (tmpFile.getContext() != null && SqlImplUtil.isSameSqlFileDialect(tmpFile, contextFile = tmpFile.getContext().getContainingFile())) {
            tmpFile = contextFile;
        }
        if (sql = SqlImplUtil.isSameSqlFileDialect(tmpFile, topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile))) {
            return topLevelFile;
        }
        return tmpFile;
    }

    private static boolean isSameSqlFileDialect(@NotNull PsiFile child, @Nullable PsiFile parent2) {
        if (child == null) {
            SqlImplUtil.$$$reportNull$$$0(96);
        }
        SqlLanguageDialect fileDialect = parent2 instanceof SqlFile ? ((SqlFile)parent2).getSqlLanguage() : null;
        return fileDialect != null && fileDialect.getClass().isInstance((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)child));
    }

    @Nullable
    public static VirtualFile getTopLevelFile(@NotNull PsiFile file) {
        PsiFile tmpFile;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(97);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)(tmpFile = file))) {
            PsiElement context = tmpFile.getContext();
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)(context == null ? null : context.getContainingFile()), (Object)tmpFile);
        } else {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile);
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)topLevelFile, (Object)tmpFile);
        }
        return tmpFile.getOriginalFile().getVirtualFile();
    }

    @NotNull
    public static String getCasedPart(@Nullable SqlReferenceExpression tableRef, @NotNull ObjectKind kind) {
        if (kind == null) {
            SqlImplUtil.$$$reportNull$$$0(98);
        }
        if (tableRef == null) {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(99);
            }
            return string;
        }
        ArrayList<Trinity<ObjectKind, Boolean, String>> parts = new ArrayList<Trinity<ObjectKind, Boolean, String>>();
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.tryCast((Object)tableRef.getContainingFile(), SqlFile.class);
        if (casingProvider == null) {
            casingProvider = SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef).getDatabaseDialect();
        }
        SqlFileImpl.splitRef(SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef), tableRef, parts);
        for (Trinity trinity : parts) {
            if (trinity.first != kind) continue;
            String string = casingProvider.getCasing(kind, null).choose((Boolean)trinity.second == false).apply((String)trinity.third);
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(100);
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(101);
        }
        return string;
    }

    @NotNull
    public static ObjectKind getQualifierKind(@NotNull PsiElement element2) {
        PsiElement target2;
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(102);
        }
        SqlExpression qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        PsiElement psiElement = target2 = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
        if (qualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element2, SqlQueryClause.class) != null) {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(103);
            }
            return objectKind;
        }
        ObjectKind objectKind = target2 instanceof DasObject ? SqlImplUtil.getKindSynonymAware((DasObject)target2) : ObjectKind.NONE;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(104);
        }
        return objectKind;
    }

    @NotNull
    public static SqlType getQualifierType(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(105);
        }
        SqlExpression qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        Object object = qualifier != null ? qualifier.getSqlType() : SqlType.UNKNOWN;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(106);
        }
        return object;
    }

    public static boolean isAutoVal(@NotNull SqlColumnDefinition col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(107);
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)col).isAutoIncrementColumn((DasColumn)col);
    }

    public static boolean isAutoVal(@NotNull PsiColumn col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(108);
        }
        return col instanceof SqlColumnDefinition ? SqlImplUtil.isAutoVal((SqlColumnDefinition)col) : DasUtil.isAutoGenerated((DasColumn)col);
    }

    public static boolean isComputedVal(@NotNull SqlColumnDefinition col) {
        SqlColumnStub stub;
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(109);
        }
        SqlColumnStub sqlColumnStub = stub = col instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)col).getStub() : null;
        if (stub != null) {
            return stub.isComputed();
        }
        ASTNode node = col.getNode();
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE) != null;
    }

    public static boolean isComputedVal(@NotNull PsiColumn col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(110);
        }
        return col instanceof SqlColumnDefinition ? SqlImplUtil.isComputedVal((SqlColumnDefinition)col) : DasUtil.isComputed((DasColumn)col);
    }

    @NotNull
    public static JBIterable<SqlStatement> iterateStatementsBackward(@NotNull PsiFile file, int offset) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(111);
        }
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)file)).expand(element2 -> element2.getTextRange().getStartOffset() < offset && (!(element2 instanceof SqlStatement) || element2.getTextRange().getEndOffset() >= offset))).postOrderDfsTraversal().filter(SqlStatement.class).filter(stmt -> stmt.getTextRange().getEndOffset() <= offset);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(112);
        }
        return jBIterable;
    }

    @NotNull
    public static List<PsiColumn> mergeColumnListInto(@NotNull List<PsiColumn> a, @NotNull List<? extends PsiColumn> b2, boolean caseSensitive, @Nullable PairFunction<? super PsiColumn, ? super PsiColumn, Boolean> mergeCheck) {
        if (a == null) {
            SqlImplUtil.$$$reportNull$$$0(113);
        }
        if (b2 == null) {
            SqlImplUtil.$$$reportNull$$$0(114);
        }
        a.addAll(SqlImplUtil.processColumnList(b2, a, caseSensitive, mergeCheck, true));
        List<PsiColumn> list = a;
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(115);
        }
        return list;
    }

    @NotNull
    public static List<PsiColumn> processColumnList(@NotNull List<? extends PsiColumn> tgt, @NotNull List<? extends PsiColumn> src, boolean caseSensitive, @Nullable PairFunction<? super PsiColumn, ? super PsiColumn, Boolean> check, boolean skip) {
        if (tgt == null) {
            SqlImplUtil.$$$reportNull$$$0(116);
        }
        if (src == null) {
            SqlImplUtil.$$$reportNull$$$0(117);
        }
        ArrayList<PsiColumn> result2 = new ArrayList<PsiColumn>(tgt.size());
        Map tgtMap = DasUtil.newCaseAwareMap((boolean)caseSensitive);
        for (PsiColumn psiColumn : src) {
            tgtMap.put(psiColumn.getName(), psiColumn);
        }
        for (PsiColumn psiColumn : tgt) {
            boolean matched;
            PsiColumn old = (PsiColumn)tgtMap.remove(psiColumn.getName());
            boolean bl = matched = old != null && (check == null || (Boolean)check.fun((Object)old, (Object)psiColumn) != false);
            if (matched && skip) continue;
            result2.add(matched ? old : psiColumn);
        }
        ArrayList<PsiColumn> arrayList = result2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(118);
        }
        return arrayList;
    }

    public static boolean hasSameTypes(@Nullable PsiColumn a, @Nullable PsiColumn b2) {
        if (a == null || b2 == null) {
            return a == b2;
        }
        return a.getDataType().equals(b2.getDataType());
    }

    public static ObjectKind getBodyParentKind(@Nullable SqlDefinition o) {
        SqlNameElement nameElement = o != null ? o.getNameElement() : null;
        PsiElement lastChild = nameElement == null ? null : nameElement.getLastChild();
        return lastChild instanceof SqlReferenceExpression ? ((SqlReferenceExpression)lastChild).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
    }

    public static boolean equalsInsensitiveOrTrue(@Nullable String a, @Nullable String b2, boolean compare) {
        return !compare || Comparing.strEqual((String)a, (String)b2, (boolean)false);
    }

    public static boolean forbidGlobalTablesResolve(PsiElement place) {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
        if (ref == null) {
            return false;
        }
        if (SqlImplUtil.getSqlDialectSafe(place).allowGlobalTableResolve(place)) {
            return false;
        }
        if (ref.getReferenceElementType().getTargetKind() == ObjectKind.COLUMN) {
            return true;
        }
        SqlReferenceExpression parentRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getParent(), SqlReferenceExpression.class);
        if (parentRef == null) {
            return false;
        }
        if (parentRef.getParent() instanceof SqlTypeElement) {
            return false;
        }
        return parentRef.getReferenceElementType().getTargetKind() == ObjectKind.COLUMN;
    }

    @NotNull
    public static PsiElement[] getRelatedElements(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(119);
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)definition, () -> CachedValueProvider.Result.create((Object)SqlImplUtil.calcRelatedElements(definition), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiElementArray == null) {
            SqlImplUtil.$$$reportNull$$$0(120);
        }
        return psiElementArray;
    }

    @NotNull
    private static PsiElement[] calcRelatedElements(@NotNull SqlDefinition definition) {
        SqlReferenceExpression ref;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(121);
        }
        if ((ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)definition.getNameElement(), SqlReferenceExpression.class)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(122);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(ref.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)definition), ref.getReferenceElementType(), (PsiElement)definition);
        if (newRef == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(123);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResolveResult[] results2 = newRef.multiResolve(false);
        if (results2.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(124);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] related = new PsiElement[results2.length];
        for (int i2 = 0; i2 < results2.length; ++i2) {
            related[i2] = results2[i2].getElement();
        }
        if (related == null) {
            SqlImplUtil.$$$reportNull$$$0(125);
        }
        return related;
    }

    public static boolean isProcessingOneOf(@NotNull PsiScopeProcessor processor, ObjectKind ... kinds) {
        SqlScopeProcessor sqlProcessor;
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(126);
        }
        if (kinds == null) {
            SqlImplUtil.$$$reportNull$$$0(127);
        }
        if ((sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class)) == null) {
            return true;
        }
        for (ObjectKind kind : kinds) {
            if (kind != SqlDbElementType.ANY && !sqlProcessor.mayAccept(kind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProcessingChildOf(@NotNull PsiScopeProcessor processor, @NotNull ObjectKind parent2) {
        SqlScopeProcessor sqlProcessor;
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(128);
        }
        if (parent2 == null) {
            SqlImplUtil.$$$reportNull$$$0(129);
        }
        if ((sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class)) == null || parent2 == SqlDbElementType.ANY) {
            return true;
        }
        return sqlProcessor.mayAcceptParent(parent2);
    }

    public static boolean ignoreKinds(@NotNull PsiScopeProcessor processor, @NotNull Collection<ObjectKind> types) {
        SqlScopeProcessor sqlProcessor;
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(130);
        }
        if (types == null) {
            SqlImplUtil.$$$reportNull$$$0(131);
        }
        if ((sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class)) == null) {
            return true;
        }
        sqlProcessor.handleEvent(SqlScopeProcessor.IGNORE_TYPE, types);
        return !sqlProcessor.getExpectedTypes().isEmpty();
    }

    public static boolean canResolveToPgFunctionColumn(@Nullable PsiElement expr) {
        if (!(expr instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expr).getQualifierExpression() == null) {
            return false;
        }
        if (expr.getParent() instanceof SqlFunctionCallExpression) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expr, SqlSelectClause.class) != null;
    }

    @Nullable
    public static PomTarget getPomTarget(@Nullable Object element2) {
        return element2 instanceof PomTargetPsiElement ? ((PomTargetPsiElement)element2).getTarget() : null;
    }

    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement e, @Nullable IElementType type) {
        if (e == null || type == null) {
            return null;
        }
        PsiElement child = e.getFirstChild();
        return child == null ? null : PsiTreeUtil.findSiblingForward((PsiElement)child, (IElementType)type, (boolean)false, null);
    }

    @Nullable
    public static PsiReference getReference(@NotNull PsiElement element2, @Nullable SqlIdentifier nameElement) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(132);
        }
        if (nameElement == null) {
            return null;
        }
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)element2, (PsiElement)element2);
        ref.setRangeInElement(nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent()));
        return ref;
    }

    public static SqlTableType getTableTypeOfColumnList(@NotNull List<? extends SqlReferenceExpression> colList, @Nullable SqlExpression tableExpression) {
        PsiElement psiElement;
        if (colList == null) {
            SqlImplUtil.$$$reportNull$$$0(133);
        }
        if (colList.isEmpty()) {
            SqlType type;
            SqlType sqlType = type = tableExpression == null ? null : tableExpression.getSqlType();
            if (type instanceof SqlTableType) {
                return (SqlTableType)type;
            }
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (SqlReferenceExpression sqlReferenceExpression : colList) {
            PsiElement element2 = sqlReferenceExpression.resolve();
            if (element2 instanceof SqlColumnDefinition) {
                columns.add(new Column(((SqlColumnDefinition)element2).getName(), ((SqlColumnDefinition)element2).getSqlType(), (PsiElement)sqlReferenceExpression, element2));
                continue;
            }
            if (element2 instanceof DbColumnImpl) {
                DbColumnImpl column2 = (DbColumnImpl)element2;
                SqlType sqlType = SqlImplUtil.getSqlType(column2.getDataType(), SqlImplUtil.getSqlDialectSafe(element2), (PsiElement)tableExpression);
                columns.add(new Column(column2.getName(), sqlType, (PsiElement)sqlReferenceExpression, element2));
                continue;
            }
            columns.add(new Column(sqlReferenceExpression.getName(), (SqlType)SqlType.UNKNOWN, (PsiElement)sqlReferenceExpression, null));
        }
        PsiElement qualifier = null;
        if (tableExpression instanceof SqlReferenceExpression && (psiElement = ((SqlReferenceExpression)tableExpression).resolve()) instanceof SqlCreateTableStatement) {
            qualifier = psiElement;
        }
        return SqlImplUtil.createType(columns, qualifier);
    }

    @Nullable
    private static TrigEvent getEvent(IElementType e) {
        if (e == SqlCommonKeywords.SQL_SELECT) {
            return TrigEvent.SELECT;
        }
        if (e == SqlCommonKeywords.SQL_INSERT) {
            return TrigEvent.INSERT;
        }
        if (e == SqlCommonKeywords.SQL_UPDATE) {
            return TrigEvent.UPDATE;
        }
        if (e == SqlCommonKeywords.SQL_DELETE) {
            return TrigEvent.DELETE;
        }
        return null;
    }

    @Nullable
    private static TrigEvent getEvent(PsiElement element2) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (TrigEvent)api.children((Object)element2).transform(api.TO_TYPE).transform(e -> SqlImplUtil.getEvent(e)).filter(Conditions.notNull()).first();
    }

    @NotNull
    public static Set<TrigEvent> getTriggerEvents(@NotNull SqlElement element2) {
        SyntaxTraverser.ApiEx api;
        JBIterable events;
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(134);
        }
        if ((events = (api = SyntaxTraverser.psiApi()).children((Object)element2).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE)).isEmpty()) {
            Set<TrigEvent> set = Collections.emptySet();
            if (set == null) {
                SqlImplUtil.$$$reportNull$$$0(135);
            }
            return set;
        }
        Set set = events.transform(e -> SqlImplUtil.getEvent(e)).filter(Conditions.notNull()).toSet();
        if (set == null) {
            SqlImplUtil.$$$reportNull$$$0(136);
        }
        return set;
    }

    @NotNull
    public static SqlType getTupleType(SqlExpressionList expressionList) {
        boolean tableTypeExpected;
        List list = expressionList.getExpressionList();
        boolean bl = tableTypeExpected = expressionList.getParent() instanceof SqlValuesExpression || PsiUtilCore.getElementType((PsiElement)expressionList.getFirstChild()) == SqlCommonKeywords.SQL_ROW;
        if (list.size() == 0) {
            Object object = tableTypeExpected ? SqlTableTypeBase.EMPTY_TABLE : SqlType.UNKNOWN;
            if (object == null) {
                SqlImplUtil.$$$reportNull$$$0(137);
            }
            return object;
        }
        if (list.size() == 1 && !tableTypeExpected) {
            SqlType sqlType = ((SqlExpression)list.get(0)).getSqlType();
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(138);
            }
            return sqlType;
        }
        ValuesTableType valuesTableType = new ValuesTableType(expressionList);
        if (valuesTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(139);
        }
        return valuesTableType;
    }

    public static short calcPosition(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(140);
        }
        short count2 = 1;
        for (PsiElement element2 : SqlImplUtil.childrenIt(SqlImplUtil.sqlParent((PsiElement)definition))) {
            if (element2 == definition) {
                return count2;
            }
            count2 = (short)(count2 + 1);
        }
        return 0;
    }

    public static boolean isBodyLazyBlock(@Nullable PsiElement e) {
        return e instanceof LazyParseablePsiElement && !(e instanceof SqlLazyParseablePsiElement) || e instanceof SqlCodeBlockElement;
    }

    @NotNull
    private static IntRange indicesOfImmediateSource(@NotNull SqlTableType type, @NotNull PsiElement source) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(141);
        }
        if (source == null) {
            SqlImplUtil.$$$reportNull$$$0(142);
        }
        int columnCount = type.getColumnCount();
        int from = -1;
        int to = columnCount;
        for (int i2 = 0; i2 < columnCount; ++i2) {
            boolean isMatched;
            PsiElement actualSource = type.getImmediateSourceColumnElement(i2);
            PomTarget pomTarget = SqlImplUtil.getPomTarget(actualSource);
            if (pomTarget instanceof SqlImplicitTarget) {
                actualSource = ((SqlImplicitTarget)pomTarget).getContext();
            }
            boolean bl = isMatched = actualSource == source || source instanceof SqlReferenceExpression && actualSource == ((SqlReferenceExpression)source).resolve();
            if (isMatched && from < 0) {
                from = i2;
                continue;
            }
            if (isMatched || from < 0) continue;
            to = i2;
            break;
        }
        IntRange intRange = new IntRange(from, to - 1);
        if (intRange == null) {
            SqlImplUtil.$$$reportNull$$$0(143);
        }
        return intRange;
    }

    private static boolean inColumnProvidingContext(@NotNull SqlQueryExpression query) {
        SqlInsertDmlInstruction dmlInstruction;
        if (query == null) {
            SqlImplUtil.$$$reportNull$$$0(144);
        }
        if ((dmlInstruction = (SqlInsertDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)query, SqlInsertDmlInstruction.class)) != null && dmlInstruction.getQueryExpression() == query) {
            return true;
        }
        SqlCreateViewStatement createView = (SqlCreateViewStatement)PsiTreeUtil.getParentOfType((PsiElement)query, SqlCreateViewStatement.class);
        return createView != null && createView.getQueryExpression() == query && createView.getColumnAliases().length > 0;
    }

    @Nullable
    private static SqlExpression getSelectExpression(@NotNull SqlSelectClause selectClause, @NotNull PsiElement element2) {
        if (selectClause == null) {
            SqlImplUtil.$$$reportNull$$$0(145);
        }
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(146);
        }
        for (SqlExpression expression : selectClause.getExpressions()) {
            if (!expression.getTextRange().contains(element2.getTextRange().getStartOffset())) continue;
            return expression;
        }
        return null;
    }

    @Nullable
    private static SqlElement getResultSetExpressionList(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        SqlExpressionList list = SqlValuesParameterInfoHandler.findExpressions(element2);
        if (list != null) {
            return list;
        }
        SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlSelectClause.class);
        if (selectClause != null) {
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)selectClause, SqlQueryExpression.class);
            return query != null && SqlImplUtil.inColumnProvidingContext(query) ? selectClause : null;
        }
        return null;
    }

    @Nullable
    public static IntRange getImmediateColumnSourceIndices(@Nullable PsiElement element2, @Nullable SqlElement anExpressionList) {
        SqlElement expressionList;
        if (element2 == null) {
            return null;
        }
        SqlElement sqlElement = expressionList = anExpressionList != null ? anExpressionList : SqlImplUtil.getResultSetExpressionList(element2);
        if (expressionList instanceof SqlExpressionList) {
            int index2 = SqlValuesParameterInfoHandler.getCurrentParameterIndex((SqlExpressionList)expressionList, element2.getTextRange().getStartOffset());
            return index2 >= 0 ? new IntRange(index2, index2) : null;
        }
        if (expressionList instanceof SqlSelectClause) {
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expressionList, SqlQueryExpression.class);
            if (query == null) {
                return null;
            }
            SqlType type = query.getSqlType();
            if (!(type instanceof SqlTableType)) {
                return null;
            }
            SqlExpression expression = SqlImplUtil.getSelectExpression((SqlSelectClause)expressionList, element2);
            if (expression == null) {
                return null;
            }
            IntRange indices = SqlImplUtil.indicesOfImmediateSource((SqlTableType)type, (PsiElement)expression);
            return indices.getStart() >= 0 ? indices : null;
        }
        return null;
    }

    public static boolean isAsteriskRef(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(147);
        }
        return SqlImplUtil.getAsterisk(element2) != null;
    }

    @Nullable
    public static PsiElement getAsterisk(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(148);
        }
        if (!(element2 instanceof SqlReferenceExpression)) {
            return null;
        }
        for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != SqlCommonTokens.SQL_ASTERISK) continue;
            return child;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 80: 
            case 83: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 80: 
            case 83: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 3: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 26: 
            case 28: 
            case 49: 
            case 53: 
            case 67: 
            case 71: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 48: 
            case 119: 
            case 121: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 54: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 66: 
            case 80: 
            case 89: 
            case 91: 
            case 102: 
            case 105: 
            case 132: 
            case 134: 
            case 146: 
            case 147: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 83: 
            case 97: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpFile";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 126: 
            case 128: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colList";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectClause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTraverser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevTraverser";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 80: 
            case 83: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "byElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlParents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "revSiblings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedState";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setQualifier";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setImmediateQualifier";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "setImmediateTarget";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualified";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeLateralAware";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectType";
                break;
            }
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 68: 
            case 69: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElement";
                break;
            }
            case 61: 
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeOf";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSqlType";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceList";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectSafe";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbVersions";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindSynonymAware";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabels";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLabels";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasedPart";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierKind";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateStatementsBackward";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeColumnListInto";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "processColumnList";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedElements";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRelatedElements";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "getTriggerEvents";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleType";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "indicesOfImmediateSource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "byElementType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "revSiblings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBlockContentElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModifiedState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setImmediateQualifier";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateTarget";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateQualifier";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setImmediateTarget";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheLeftOfType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheRightOfType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedElements";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processQualifierImpl";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTypeLateralAware";
                break;
            }
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getSelectType";
                break;
            }
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElement";
                break;
            }
            case 60: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeOf";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "computeSqlType";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getDbVersions";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getLabels";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "calcLabels";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "canUnquote";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelSqlFile";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isSameSqlFileDialect";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getCasedPart";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierKind";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierType";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isAutoVal";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isComputedVal";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "iterateStatementsBackward";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "mergeColumnListInto";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "processColumnList";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedElements";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "calcRelatedElements";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingOneOf";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingChildOf";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "ignoreKinds";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getTableTypeOfColumnList";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "getTriggerEvents";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "calcPosition";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "indicesOfImmediateSource";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "inColumnProvidingContext";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getSelectExpression";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "isAsteriskRef";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "getAsterisk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 80: 
            case 83: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 121: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ValuesTableType
    extends SqlTableTypeBase {
        private final SqlExpressionList myExpressionList;

        private ValuesTableType(SqlExpressionList list) {
            this.myExpressionList = list;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                ValuesTableType.$$$reportNull$$$0(0);
            }
            return dataType;
        }

        @NotNull
        public List<PsiObject> getMethods() {
            List<PsiObject> list = Collections.emptyList();
            if (list == null) {
                ValuesTableType.$$$reportNull$$$0(1);
            }
            return list;
        }

        public int getColumnCount() {
            return this.myExpressionList.getExpressionList().size();
        }

        public String getColumnName(int i2) {
            return String.valueOf(i2);
        }

        public boolean isColumnQuoted(int i2) {
            return false;
        }

        public SqlType getColumnType(int i2) {
            return ((SqlExpression)this.myExpressionList.getExpressionList().get(i2)).getSqlType();
        }

        @Nullable
        public PsiElement getColumnQualifier(int i2) {
            return this.myExpressionList;
        }

        @NotNull
        public PsiElement getColumnElement(int i2) {
            PsiElement psiElement = (PsiElement)this.myExpressionList.getExpressionList().get(i2);
            if (psiElement == null) {
                ValuesTableType.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @Nullable
        public PsiElement getSourceColumnElement(int i2) {
            return (PsiElement)this.myExpressionList.getExpressionList().get(i2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethods";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class EmptyTable
    implements DasTable {
        private EmptyTable() {
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                EmptyTable.$$$reportNull$$$0(0);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                EmptyTable.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c2) {
            if (c2 instanceof PsiElement && SqlImplUtil.getSqlDialectSafe((PsiElement)c2).isAutoIncrementColumn(c2)) {
                EnumSet<DasColumn.Attribute> enumSet = EnumSet.of(DasColumn.Attribute.AUTO_GENERATED);
                if (enumSet == null) {
                    EmptyTable.$$$reportNull$$$0(2);
                }
                return enumSet;
            }
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                EmptyTable.$$$reportNull$$$0(3);
            }
            return set;
        }

        @NotNull
        public JBIterable<? extends DasObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyTable.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Nullable
        public DasObject getDasParent() {
            return null;
        }

        @Nullable
        public String getComment() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Column {
        public final String name;
        public final SqlType type;
        public final PsiElement element;
        public final PsiElement sourceElement;

        public Column(String name2, SqlType type, @NotNull PsiElement element2, PsiElement sourceElement) {
            if (element2 == null) {
                Column.$$$reportNull$$$0(0);
            }
            this.name = name2;
            this.type = type;
            this.element = element2;
            this.sourceElement = sourceElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$Column", "<init>"));
        }
    }

    private static class MyColumnInfo
    extends RenameableFakePsiElement
    implements PsiColumn,
    SqlTypedDefinition {
        final DasTable myTableInfo;
        final int myIndex;
        final SqlTableType myTableType;
        final DasObject myInfo;

        MyColumnInfo(@NotNull DasTable parent2, int index2, @NotNull SqlTableType tableType) {
            if (parent2 == null) {
                MyColumnInfo.$$$reportNull$$$0(0);
            }
            if (tableType == null) {
                MyColumnInfo.$$$reportNull$$$0(1);
            }
            super((PsiElement)((PsiElement)parent2).getContainingFile());
            this.myTableInfo = parent2;
            this.myIndex = index2;
            this.myTableType = tableType;
            PsiElement columnElement = tableType.getSourceColumnElement(index2);
            this.myInfo = (DasObject)ObjectUtils.tryCast((Object)columnElement, DasObject.class);
        }

        public boolean isNameQuoted() {
            return DbSqlUtil.isQuoted((SqlNameElement)ObjectUtils.tryCast((Object)this.myTableType.getColumnElement(this.myIndex), SqlNameElement.class));
        }

        public String getTableName() {
            return this.myTableInfo.getName();
        }

        public DasTable getTable() {
            return this.myTableInfo;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyColumnInfo.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myTableType.getColumnName(this.myIndex), (String)DasUtil.NO_NAME);
            if (string == null) {
                MyColumnInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String getComment() {
            return this.myInfo == null ? null : this.myInfo.getComment();
        }

        public DasObject getDasParent() {
            return this.getTable();
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDataType() : DataTypeFactory.of(this.myTableType.getColumnType(this.myIndex).getDisplayName());
            if (dataType == null) {
                MyColumnInfo.$$$reportNull$$$0(4);
            }
            return dataType;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = this.myTableType.getColumnType(this.myIndex);
            if (sqlType == null) {
                MyColumnInfo.$$$reportNull$$$0(5);
            }
            return sqlType;
        }

        public boolean isNotNull() {
            return this.myInfo instanceof DasTypedObject && ((DasTypedObject)this.myInfo).isNotNull();
        }

        public String getDefault() {
            return this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDefault() : null;
        }

        public PsiElement getParent() {
            return (PsiElement)this.myTableInfo;
        }

        public String getTypeName() {
            return DbPresentation.getPresentableName(this.getKind(), DatabaseDialects.getGenericDialect());
        }

        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myTableType.getColumnElement(this.myIndex);
            if (psiElement == null) {
                MyColumnInfo.$$$reportNull$$$0(6);
            }
            return psiElement;
        }

        public short getPosition() {
            return (short)(this.myIndex + 1);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return null;
        }

        public void accept(SqlVisitor visitor2) {
            visitor2.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor2) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
        }

        public boolean isEquivalentTo(PsiElement another) {
            if (!(another instanceof MyColumnInfo)) {
                return false;
            }
            MyColumnInfo info = (MyColumnInfo)another;
            return this.myIndex == info.myIndex && Objects.equals(this.myTableInfo, info.myTableInfo) && Objects.equals(this.myInfo, info.myInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

