/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlLazyElementType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLazyElementTypeImpl
extends SqlLazyElementType {
    private static final Key<PsiElement> CHAMELEON_ELEMENT = Key.create((String)"CHAMELEON_ELEMENT");
    private final PairFunction<? super IElementType, ? super CharSequence, ? extends ASTNode> myFac;
    private final ReparseType myReparseType;

    public static PsiElement getContextElement(@NotNull PsiBuilder builder) {
        if (builder == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(0);
        }
        return SqlLazyElementTypeImpl.getContextElement((PsiElement)CHAMELEON_ELEMENT.get((UserDataHolder)builder));
    }

    @Nullable
    public static PsiElement getContextElement(PsiElement element2) {
        DummyHolder holder = element2 == null ? null : (DummyHolder)ObjectUtils.tryCast((Object)element2.getParent(), DummyHolder.class);
        return holder != null ? holder.getContext() : element2;
    }

    public SqlLazyElementTypeImpl(@NotNull String debugName, @NotNull PairFunction<? super IElementType, ? super CharSequence, ? extends ASTNode> fac, @Nullable ReparseType reparseType) {
        if (debugName == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(1);
        }
        if (fac == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(2);
        }
        super(debugName);
        this.myFac = fac;
        this.myReparseType = reparseType;
    }

    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        if (chameleon == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(3);
        }
        return this.parseLight(chameleon).getTreeBuilt().getFirstChildNode();
    }

    public PsiBuilder parseLight(ASTNode chameleon) {
        return SqlLazyElementTypeImpl.parseLight(chameleon, (ILazyParseableElementType)this);
    }

    @NotNull
    public static PsiBuilder parseLight(ASTNode chameleon, ILazyParseableElementType root2) {
        PsiElement psi = chameleon.getPsi();
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe(psi);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        Project project = psi.getProject();
        Lexer lexer = SqlLazyElementTypeImpl.createLexer(project, psi, parserDefinition);
        LightPsiParser parser = (LightPsiParser)parserDefinition.createParser(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, lexer, (Language)language, chameleon.getChars());
        SqlLazyElementTypeImpl.setChameleonElement(psi, builder);
        parser.parseLight((IElementType)root2, builder);
        if (!builder.eof()) {
            throw new AssertionError();
        }
        PsiBuilder psiBuilder = builder;
        if (psiBuilder == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(4);
        }
        return psiBuilder;
    }

    public static Lexer createLexer(@NotNull PsiElement psi) {
        if (psi == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(5);
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe(psi);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        return SqlLazyElementTypeImpl.createLexer(psi.getProject(), psi, parserDefinition);
    }

    @NotNull
    protected static Lexer createLexer(@NotNull Project project, @Nullable PsiElement psi, @NotNull ParserDefinition parserDefinition) {
        if (project == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(6);
        }
        if (parserDefinition == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(7);
        }
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)psi);
        Language hostLanguage = SqlPreprocessingLexer.getHostLanguage((PsiElement)host);
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(project, parserDefinition, hostLanguage);
        if (lexer == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(8);
        }
        return lexer;
    }

    public static void setChameleonElement(PsiElement psi, PsiBuilder builder) {
        CHAMELEON_ELEMENT.set((UserDataHolder)builder, (Object)psi);
    }

    @NotNull
    public ASTNode createNode(CharSequence text2) {
        ASTNode aSTNode = (ASTNode)this.myFac.fun((Object)this, (Object)text2);
        if (aSTNode == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(9);
        }
        return aSTNode;
    }

    public boolean reuseCollapsedTokens() {
        return true;
    }

    public boolean isParsable(@Nullable ASTNode parent2, @NotNull CharSequence buffer, @NotNull Language fileLanguage, @NotNull Project project) {
        if (buffer == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(10);
        }
        if (fileLanguage == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(11);
        }
        if (project == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(12);
        }
        if (this.myReparseType == null) {
            return false;
        }
        if (this.myReparseType == ReparseType.PARSE) {
            return true;
        }
        return this.checkParens(parent2, project, fileLanguage, buffer);
    }

    public boolean isValidReparse(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(13);
        }
        if (newNode == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(14);
        }
        for (ASTNode tmp = newNode.getLastChildNode(); tmp != null; tmp = tmp.getLastChildNode()) {
            if (PsiUtilCore.getElementType((ASTNode)tmp) == TokenType.ERROR_ELEMENT) {
                return false;
            }
            if (tmp instanceof LazyParseableElement && !((LazyParseableElement)tmp).isParsed()) break;
        }
        return true;
    }

    protected boolean checkParens(@Nullable ASTNode parent2, @NotNull Project project, @NotNull Language fileLanguage, final @NotNull CharSequence buffer) {
        if (project == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(15);
        }
        if (fileLanguage == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(16);
        }
        if (buffer == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(17);
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(fileLanguage);
        Lexer lexer = SqlLazyElementTypeImpl.createLexer(project, parent2 == null ? null : parent2.getPsi(), parserDefinition);
        CharSequence text2 = this.myReparseType == ReparseType.PARENS ? buffer : new CharSequence(){
            private final int myLength;
            {
                this.myLength = buffer.length() + 2;
            }

            @Override
            public int length() {
                return this.myLength;
            }

            @Override
            public char charAt(int index2) {
                return (char)(index2 == 0 ? 40 : (index2 == this.myLength - 1 ? 41 : (int)buffer.charAt(index2 - 1)));
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new CharSequenceSubSequence((CharSequence)this, start, end);
            }
        };
        return SqlLazyElementTypeImpl.hasProperBraceBalance(text2, lexer);
    }

    private static boolean hasProperBraceBalance(@NotNull CharSequence text2, @NotNull Lexer lexer) {
        if (text2 == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(18);
        }
        if (lexer == null) {
            SqlLazyElementTypeImpl.$$$reportNull$$$0(19);
        }
        lexer.start(text2);
        if (lexer.getTokenType() != SqlCommonTokens.SQL_LEFT_PAREN) {
            return false;
        }
        lexer.advance();
        int balance = 1;
        while (true) {
            ProgressManager.checkCanceled();
            IElementType type = lexer.getTokenType();
            if (type == SqlCommonTokens.SQL_SEMICOLON) {
                return false;
            }
            if (type == null) {
                return balance == 0;
            }
            if (balance == 0) {
                return false;
            }
            if (type == SqlCommonTokens.SQL_LEFT_PAREN) {
                ++balance;
            } else if (type == SqlCommonTokens.SQL_RIGHT_PAREN) {
                --balance;
            }
            lexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fac";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlLazyElementTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlLazyElementTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLight";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseContents";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isParsable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValidReparse";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkParens";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasProperBraceBalance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ReparseType {
        PARENS_INNER,
        PARENS,
        PARSE;

    }
}

