/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsType;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ResourceUtil;
import java.io.InputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/settings/SqlPreviewExamples;", "", "()V", "read", "", "dialect", "Lcom/intellij/lang/Language;", "type", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettingsType;", "exampleName", "intellij.database.sql.impl"})
public final class SqlPreviewExamples {
    public static final SqlPreviewExamples INSTANCE;

    @JvmStatic
    @Deprecated(message="Use read(dialect, type)")
    @NotNull
    public static final String read(@NotNull String exampleName) {
        Intrinsics.checkParameterIsNotNull((Object)exampleName, (String)"exampleName");
        String fileName = "preview." + exampleName + ".template";
        String string = CodeStyleAbstractPanel.readFromFile(SqlPreviewExamples.class, (String)fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CodeStyleAbstractPanel.r\u2026es::class.java, fileName)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String read(@NotNull Language dialect, @NotNull SqlCodeStyleSettingsType type) {
        SqlLanguageDialect sqlLanguageDialect;
        Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Language language = dialect;
        if (language instanceof SqlLanguage) {
            sqlLanguageDialect = SqlCodeStyles.getGenericDialect();
            if (sqlLanguageDialect == null) {
                return "-- Generic dialect is not initialized";
            }
        } else if (language instanceof SqlLanguageDialect) {
            sqlLanguageDialect = (SqlLanguageDialect)dialect;
        } else {
            return "-- No preview file for " + dialect;
        }
        SqlLanguageDialect d2 = sqlLanguageDialect;
        String string = type.code;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.code");
        String code = string;
        Class<?> dialectClass = d2.getClass();
        StringBuilder stringBuilder = new StringBuilder();
        Package package_ = dialectClass.getPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"dialectClass.`package`");
        String string2 = package_.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dialectClass.`package`.name");
        String path = stringBuilder.append(StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null)).append("/preview").toString();
        String resourceName = "preview-" + code + ".sql";
        InputStream inputStream = ResourceUtil.getResourceAsStream((ClassLoader)dialectClass.getClassLoader(), (String)path, (String)resourceName);
        if (inputStream == null) {
            return "-- no preview text resource " + path + '/' + resourceName;
        }
        InputStream resourceStream = inputStream;
        String string3 = ResourceUtil.loadText((InputStream)resourceStream);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ResourceUtil.loadText(resourceStream)");
        String text2 = string3;
        return text2;
    }

    private SqlPreviewExamples() {
    }

    static {
        SqlPreviewExamples sqlPreviewExamples;
        INSTANCE = sqlPreviewExamples = new SqlPreviewExamples();
    }
}

