/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.RegularSqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsType;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    protected static final CodeStyleGroup SQL_STYLE_GROUP = new CodeStyleGroup("sql.code.style.group", "SQL", "code.styles.for.SQL");
    @NotNull
    protected final Language myDialect;
    @NotNull
    protected final Class<? extends SqlCodeStyleSettings> mySettingsClass;

    protected SqlLanguageCodeStyleSettingsProvider(@NotNull Language dialect, @NotNull Class<? extends SqlCodeStyleSettings> settingsClass) {
        if (dialect == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (settingsClass == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        this.myDialect = dialect;
        this.mySettingsClass = settingsClass;
    }

    public CodeStyleGroup getGroup() {
        return SQL_STYLE_GROUP;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myDialect;
        if (language == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return language;
    }

    @Nullable
    public String getLanguageName() {
        return this.getLanguage().getDisplayName();
    }

    @Nullable
    public final String getConfigurableDisplayName() {
        return this.getLanguageName();
    }

    @NotNull
    public Class<? extends SqlCodeStyleSettings> getSettingsClass() {
        Class<? extends SqlCodeStyleSettings> clazz = this.mySettingsClass;
        if (clazz == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text2) {
        return SqlCodeStyleSettingsUtil.createSqlFileForCodeStyleSettingsPreview(project, text2, (SqlLanguageDialect)this.myDialect);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer2, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer2 == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (settingsType == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer2.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
        }
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        return "-- something goes wrong";
    }

    public abstract SqlCodeStyleSettings createCustomSettings(CodeStyleSettings var1);

    @NotNull
    protected String getPreviewTextsPath() {
        if ("codeStyle/preview" == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        return "codeStyle/preview";
    }

    @NotNull
    protected Map<SqlCodeStyleSettingsType, String> loadPreviewTexts() {
        String path = this.getPreviewTextsPath();
        HashMap<SqlCodeStyleSettingsType, String> texts = new HashMap<SqlCodeStyleSettingsType, String>();
        for (SqlCodeStyleSettingsType type : SqlCodeStyleSettingsType.values()) {
            String resourceName = "preview." + type.code + ".template";
            InputStream resourceStream = ResourceUtil.getResourceAsStream((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)path, (String)resourceName);
            if (resourceStream == null) continue;
            try {
                String text2 = ResourceUtil.loadText((InputStream)resourceStream);
                texts.put(type, text2);
            }
            catch (IOException e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).error((Throwable)e);
            }
        }
        HashMap<SqlCodeStyleSettingsType, String> hashMap = texts;
        if (hashMap == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @NotNull
    protected SqlCodeStyleMainPanel createSettingsPanel(CodeStyleSettings theSettings, CodeStyleSettings currentSettings) {
        RegularSqlCodeStyleMainPanel regularSqlCodeStyleMainPanel = new RegularSqlCodeStyleMainPanel(this.myDialect, currentSettings, theSettings);
        if (regularSqlCodeStyleMainPanel == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        return regularSqlCodeStyleMainPanel;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        if (settings == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        if (modelSettings == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        CodeStyleAbstractConfigurable codeStyleAbstractConfigurable = new CodeStyleAbstractConfigurable(settings, modelSettings, this.getConfigurableDisplayName()){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings theSettings) {
                return SqlLanguageCodeStyleSettingsProvider.this.createSettingsPanel(theSettings, this.getCurrentSettings());
            }

            public String getHelpTopic() {
                return "code.styles.for.SQL";
            }
        };
        if (codeStyleAbstractConfigurable == null) {
            SqlLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        return codeStyleAbstractConfigurable;
    }

    public List<Language> getApplicableLanguages() {
        return SqlCodeStyles.getSettingsDialects().filter(d2 -> d2 != this.myDialect).filter(Language.class).toList();
    }

    public boolean supportsExternalFormats() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewTextsPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPreviewTexts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ShortLowercaseCodeStyle
    extends PredefinedCodeStyle {
        ShortLowercaseCodeStyle() {
            super("Short with Lowercase", (Language)SqlLanguage.INSTANCE);
        }

        public void apply(CodeStyleSettings settings) {
            SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlLanguageCodeStyleSettingsProvider.this.getSettingsClass());
            sqlSettings.KEYWORD_CASE = 1;
        }
    }

    private class ShortUppercaseCodeStyle
    extends PredefinedCodeStyle {
        ShortUppercaseCodeStyle() {
            super("Short with Uppercase", (Language)SqlLanguage.INSTANCE);
        }

        public void apply(CodeStyleSettings settings) {
            SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlLanguageCodeStyleSettingsProvider.this.getSettingsClass());
            sqlSettings.KEYWORD_CASE = 0;
        }
    }
}

