/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u001a\u0010\u0018\u001a\u00020\f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u001a9\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001a*\u0004\u0018\u00010\u00152\u001e\u0010\u001b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00150\u001c0\u001a\"\b\u0012\u0004\u0012\u00020\u00150\u001c\u00a2\u0006\u0002\u0010\u001d\u001a\u0014\u0010\u001e\u001a\u00020\f*\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0013H\u0002\u00a8\u0006 "}, d2={"intersects", "", "range", "Lcom/intellij/openapi/util/TextRange;", "rangesToCheck", "", "isQuoted", "node", "Lcom/intellij/lang/ASTNode;", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "performModificationInBulk", "", "documentManager", "Lcom/intellij/psi/PsiDocumentManager;", "document", "Lcom/intellij/openapi/editor/Document;", "changes", "", "Lcom/intellij/sql/formatter/Change;", "skipSpaces", "Lcom/intellij/psi/PsiElement;", "element", "whetherKeywordsUpper", "applyChangesInReversedOrder", "findSubSequence", "", "predicates", "Ljava/util/function/Predicate;", "(Lcom/intellij/psi/PsiElement;[Ljava/util/function/Predicate;)[Lcom/intellij/psi/PsiElement;", "performOneReplacement", "change", "intellij.database.sql.impl"})
@JvmName(name="SqlPreFormatHelper")
public final class SqlPreFormatHelper {
    public static final void performModificationInBulk(@NotNull PsiDocumentManager documentManager, @NotNull Document document, @NotNull Collection<Change> changes) {
        Intrinsics.checkParameterIsNotNull((Object)documentManager, (String)"documentManager");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        DocumentUtil.executeInBulk((Document)document, (boolean)true, (Runnable)new Runnable(document, changes){
            final /* synthetic */ Document $document;
            final /* synthetic */ Collection $changes;

            public final void run() {
                SqlPreFormatHelper.access$applyChangesInReversedOrder(this.$document, this.$changes);
            }
            {
                this.$document = document;
                this.$changes = collection;
            }
        });
        if (documentManager.isUncommited(document)) {
            documentManager.commitDocument(document);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void applyChangesInReversedOrder(@NotNull Document $this$applyChangesInReversedOrder, Collection<Change> changes) {
        int n = changes.size();
        if (n == 0) {
            return;
        }
        ArrayList<Change> theChanges = new ArrayList<Change>(changes);
        if (n > 1) {
            CollectionsKt.sort((List)theChanges);
        }
        int n2 = n - 1;
        boolean bl = false;
        while (n2 >= 0) {
            void i2;
            Change change = theChanges.get((int)i2);
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"theChanges[i]");
            SqlPreFormatHelper.performOneReplacement($this$applyChangesInReversedOrder, change);
            --i2;
        }
    }

    private static final void performOneReplacement(@NotNull Document $this$performOneReplacement, Change change) {
        int p2;
        TextRange range = change.range();
        String string = $this$performOneReplacement.getText(range);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getText(range)");
        String text2 = string;
        String replacement = change.getReplacement();
        if (Intrinsics.areEqual((Object)text2, (Object)replacement)) {
            return;
        }
        int p1 = range.getStartOffset();
        if ($this$performOneReplacement.getRangeGuard(p1, p2 = range.getEndOffset()) == null) {
            $this$performOneReplacement.replaceString(p1, p2, (CharSequence)replacement);
        }
    }

    public static final boolean intersects(@NotNull TextRange range, @Nullable List<? extends TextRange> rangesToCheck) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        if (rangesToCheck == null) {
            return false;
        }
        for (TextRange textRange : rangesToCheck) {
            if (!range.intersects(textRange)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isQuoted(@NotNull ASTNode node, @NotNull DatabaseDialectEx dialect) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
        PsiElement element2 = node.getPsi();
        return element2 instanceof SqlNameElement ? ((SqlNameElement)element2).isQuotedIdentifier() : dialect.isQuotedIdentifier(node.getText());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiElement[] findSubSequence(@Nullable PsiElement $this$findSubSequence, Predicate<PsiElement> ... predicates) {
        Intrinsics.checkParameterIsNotNull(predicates, (String)"predicates");
        int n = predicates.length;
        PsiElement[] found = new PsiElement[n];
        PsiElement p2 = SqlPreFormatHelper.skipSpaces($this$findSubSequence);
        while (p2 != null) {
            PsiElement q = p2;
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                void i2;
                boolean ok = predicates[i2].test(q);
                if (!ok) break;
                found[i2] = q;
                if (i2 == n - 1) {
                    return found;
                }
                if ((q = SqlPreFormatHelper.skipSpaces(q.getNextSibling())) == null) break;
                ++i2;
            }
            p2 = SqlPreFormatHelper.skipSpaces(p2.getNextSibling());
        }
        return null;
    }

    private static final PsiElement skipSpaces(PsiElement element2) {
        PsiElement e = element2;
        while (e instanceof PsiWhiteSpace) {
            e = ((PsiWhiteSpace)e).getNextSibling();
        }
        return e;
    }

    public static final boolean whetherKeywordsUpper(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement kw = element2;
        while (kw.getFirstChild() != null) {
            PsiElement e;
            kw = e;
        }
        String text2 = kw.getText();
        return text2 == null || text2.length() < 2 ? false : Character.isUpperCase(text2.charAt(1));
    }

    public static final /* synthetic */ void access$applyChangesInReversedOrder(Document $this$access_u24applyChangesInReversedOrder, Collection changes) {
        SqlPreFormatHelper.applyChangesInReversedOrder($this$access_u24applyChangesInReversedOrder, changes);
    }
}

