/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.editor.SqlColors;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            SqlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SqlAnnotator.$$$reportNull$$$0(1);
        }
        if (element2 instanceof IsExternal) {
            holder.createInfoAnnotation(element2, null).setTextAttributes(SqlColors.SQL_EXTERNAL_TOOL);
        } else if (element2 instanceof SqlElement) {
            ((SqlElement)element2).accept((SqlVisitor)new Visitor(holder));
        }
    }

    @Nullable
    public static PsiElement getTargetByIdElement(PsiElement o) {
        PsiElement parent2 = o.getParent();
        PsiElement candidate = parent2 instanceof SqlDefinition && ((SqlDefinition)parent2).getNameElement() == o ? parent2 : (parent2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent2).resolve() : null);
        return SqlAnnotator.getTargetElement(candidate);
    }

    private static PsiElement getTargetElement(PsiElement candidate) {
        DasObject result2;
        if (candidate instanceof DasSynonym && ((DasSynonym)candidate).getKind() == SqlDbElementType.SYNONYM && ((result2 = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)candidate))) == null || result2 instanceof PsiElement)) {
            return (PsiElement)result2;
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/editor/SqlAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends SqlVisitor {
        private final AnnotationHolder myHolder;

        Visitor(AnnotationHolder holder) {
            this.myHolder = holder;
        }

        protected final void setHighlighting(@NotNull PsiElement element2, TextAttributesKey key2) {
            if (element2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.setHighlighting(element2, key2, null);
        }

        protected final void setHighlighting(@NotNull PsiElement element2, TextAttributesKey key2, @Nullable String message2) {
            ASTNode node;
            ASTNode firstChild;
            if (element2 == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            ASTNode aSTNode = firstChild = (node = element2.getNode()) == null ? null : node.getFirstChildNode();
            if (firstChild != null && firstChild.getElementType() instanceof SqlKeywordTokenType) {
                this.myHolder.createInfoAnnotation(element2, message2).setEnforcedTextAttributes(TextAttributes.ERASE_MARKER);
            }
            this.myHolder.createInfoAnnotation(element2, message2).setTextAttributes(key2);
        }

        public void visitSqlIdentifier(SqlIdentifier o) {
            this.highlightDefinitionElement(SqlAnnotator.getTargetByIdElement((PsiElement)o), (SqlElement)o);
        }

        public void visitSqlTypeElement(SqlTypeElement o) {
            for (ASTNode node : o.getNode().getChildren(null)) {
                if (node.getElementType() == SqlTokens.SQL_LEFT_PAREN) break;
                if (!(node.getElementType() instanceof SqlKeywordTokenType)) continue;
                PsiElement psi = node.getPsi();
                this.myHolder.createInfoAnnotation(psi, null).setEnforcedTextAttributes(TextAttributes.ERASE_MARKER);
                this.setHighlighting(psi, SqlColors.SQL_TYPE);
            }
        }

        public void visitSqlReferenceExpression(SqlReferenceExpression o) {
            SqlIdentifier identifier = o.getIdentifier();
            SqlExpression qualifier = o.getQualifierExpression();
            if (identifier == null && qualifier == null) {
                this.highlightDefinitionElement(SqlAnnotator.getTargetElement(o.resolve()), (SqlElement)o);
            }
        }

        public void visitSqlStringLiteralExpression(SqlStringLiteralExpression o) {
            PsiReference ref = o.getReference();
            if (ref != null) {
                this.highlightDefinitionElement(ref.resolve(), (SqlElement)o);
            }
        }

        public void visitSqlParameter(SqlParameter o) {
            this.highlightDefinitionElement((PsiElement)o, (SqlElement)o);
        }

        private static boolean isOuterQueryColumn(SqlElement elementToHighlight) {
            SqlTableExpression tableExpression;
            if (!(elementToHighlight instanceof SqlIdentifier)) {
                return false;
            }
            PsiElement ref = elementToHighlight.getParent();
            if (!(ref instanceof SqlReferenceExpression)) {
                return false;
            }
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlQueryExpression.class);
            SqlTableExpression sqlTableExpression = tableExpression = query != null ? query.getTableExpression() : null;
            if (tableExpression == null) {
                return false;
            }
            ResolveResult result2 = ((SqlReferenceExpression)ref).getReference().resolveSingle();
            PsiElement qualifier = result2 instanceof SqlResolveResult ? ((SqlResolveResult)result2).getImmediateQualifier() : null;
            return qualifier instanceof SqlExpression && !PsiTreeUtil.isAncestor((PsiElement)tableExpression, (PsiElement)qualifier, (boolean)true);
        }

        private void setColumnHighlighting(SqlElement elementToHighlight) {
            boolean isOuterQueryColumn = Visitor.isOuterQueryColumn(elementToHighlight);
            TextAttributesKey key2 = isOuterQueryColumn ? SqlColors.SQL_OUTER_QUERY_COLUMN : SqlColors.SQL_COLUMN;
            String message2 = isOuterQueryColumn ? "Outer query column" : null;
            this.setHighlighting((PsiElement)elementToHighlight, key2, message2);
        }

        private void highlightDefinitionElement(PsiElement target2, SqlElement elementToHighlight) {
            if (target2 == null) {
                return;
            }
            if (target2 instanceof SqlReferenceExpression) {
                if (elementToHighlight.getParent() == target2 || elementToHighlight == target2 && SqlImplUtil.isAsteriskRef(target2)) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_SYNTHETIC_ENTITY);
                } else if (DbImplUtil.isRoutine(((SqlReferenceExpression)target2).getReferenceElementType().getTargetKind()) || DbImplUtil.isRoutine(SqlScopeProcessor.getElementType(((SqlReferenceExpression)target2).resolve()))) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
                } else {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_DATABASE_OBJECT);
                }
            } else if (target2 instanceof PomTargetPsiElement) {
                PomTarget t = ((PomTargetPsiElement)target2).getTarget();
                if (t instanceof BuiltinFunction) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
                } else {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_DATABASE_OBJECT);
                }
            } else if (target2 instanceof SqlDefinition) {
                ObjectKind definitionType = ((SqlDefinition)target2).getKind();
                if (definitionType == SqlDbElementType.SCHEMA) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_SCHEMA);
                } else if (definitionType == SqlDbElementType.TABLE) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_TABLE);
                } else if (definitionType == SqlDbElementType.COLUMN) {
                    this.setColumnHighlighting(elementToHighlight);
                } else if (definitionType == SqlDbElementType.LOCAL_ALIAS) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_LOCAL_ALIAS);
                } else if (definitionType == SqlDbElementType.QUERY_PARAMETER) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PARAMETER);
                } else if (definitionType == SqlDbElementType.ARGUMENT) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_VARIABLE);
                } else if (definitionType == SqlDbElementType.VARIABLE) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_VARIABLE);
                } else if (definitionType == SqlDbElementType.LABEL) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_LABEL);
                } else if (DbImplUtil.isRoutine(definitionType)) {
                    this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
                }
            } else if (target2 instanceof SqlFunctionCallExpression) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
            } else if (target2 instanceof SqlParameter) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PARAMETER);
            } else if (target2 instanceof DasColumn) {
                this.setColumnHighlighting(elementToHighlight);
            } else if (target2 instanceof DasTable) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_TABLE);
            } else if (target2 instanceof DasRoutine) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_PROCEDURE);
            } else if (target2 instanceof DasNamespace) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_SCHEMA);
            } else if (target2 instanceof DasUserDefinedType) {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_TYPE);
            } else {
                this.setHighlighting((PsiElement)elementToHighlight, SqlColors.SQL_DATABASE_OBJECT);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/editor/SqlAnnotator$Visitor", "setHighlighting"));
        }
    }
}

