/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.Pg83Dialect;
import com.intellij.sql.dialects.postgres.PgElementFactory;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgDialect
extends Pg83Dialect {
    public static final PgDialect INSTANCE = new PgDialect();

    public PgDialect() {
        super("PostgreSQL");
    }

    protected PgDialect(@NonNls @NotNull String id) {
        if (id == null) {
            PgDialect.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.POSTGRES;
        if (dbms == null) {
            PgDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            PgDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            PgDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            PgDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            PgDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            PgDialect.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    private static Condition<PsiElement> isType(IElementType type) {
        Condition condition = Conditions.compose((Function)SyntaxTraverser.psiApi().TO_TYPE, (Condition)Conditions.is((Object)type));
        if (condition == null) {
            PgDialect.$$$reportNull$$$0(7);
        }
        return condition;
    }

    @Override
    @NotNull
    public JBIterable<ObjectKind> getExtraKindsStrict(@NotNull SqlReferenceImpl reference) {
        if (reference == null) {
            PgDialect.$$$reportNull$$$0(8);
        }
        if (reference.getReferenceElementType().getTargetKind() == ObjectKind.COLUMN && reference.getElement().getParent() instanceof SqlCommentStatementImpl) {
            JBIterable jBIterable = JBIterable.of((Object)ObjectKind.OBJECT_ATTRIBUTE);
            if (jBIterable == null) {
                PgDialect.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            PgDialect.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        SqlDmlInstruction insert;
        SqlPrimitiveType type;
        SyntaxTraverser.ApiEx api;
        PsiElement conflictAction;
        if (element2 == null) {
            PgDialect.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            PgDialect.$$$reportNull$$$0(12);
        }
        if (!super.processReservedEntitiesWithType(name2, element2, resolve, processor)) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_EXCLUDED.name, resolve) && (conflictAction = (PsiElement)(api = SyntaxTraverser.psiApi()).parents((Object)element2).filter(PgDialect.isType((IElementType)PgElementTypes.Misc.PG_CONFLICT_ACTION_CLAUSE)).first()) != null && !api.children((Object)conflictAction).filter(PgDialect.isType((IElementType)SqlTokens.SQL_UPDATE)).isEmpty() && !processor.executeTarget(LazyData.RE_EXCLUDED, element2, (SqlType)((type = (insert = (SqlDmlInstruction)api.parents((Object)element2).filter(SqlDmlInstruction.class).first()) == null ? SqlType.UNKNOWN : insert.getTargetExpression().getSqlType()) == SqlType.UNKNOWN ? SqlTableTypeBase.EMPTY_TABLE : type), null, ResolveState.initial())) {
            return false;
        }
        if (PgDialect.isSamplingMethodRef(element2)) {
            for (ReservedEntity sm : LazyData.RE_SAMPLING_METHODS) {
                if (PgDialect.processReservedEntitiesWithTypeSimple(sm, SqlTypeFactory.REFERENCE, name2, element2, resolve, processor, false, null)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean isSamplingMethodRef(@Nullable PsiElement place) {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
        SqlReferenceElementType refType = ref == null ? null : ref.getReferenceElementType();
        return refType == PgElementTypes.Extra.PG_SAMPLING_METHOD_REFERENCE;
    }

    public boolean isResolveTargetNotAccepted(@Nullable Object element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            PgDialect.$$$reportNull$$$0(13);
        }
        if (expectedTypes.contains(SqlDbElementType.ROUTINE) && element2 != null && PgDialect.isSamplingMethodRef(place) && !PgDialect.isSamplingMethod(element2)) {
            return true;
        }
        return super.isResolveTargetNotAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            PgDialect.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Override
    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            PgDialect.$$$reportNull$$$0(15);
        }
        return super.shouldSkipFromQualification(kind) || kind == SqlDbElementType.FOREIGN_DATA_WRAPPER;
    }

    @Override
    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        IElementType res2;
        if (name2 == null) {
            PgDialect.$$$reportNull$$$0(16);
        }
        return (res2 = PgElementFactory.findComposite(name2)) == null ? super.getFunctionParserExtension(name2) : res2;
    }

    private static boolean isSamplingMethod(Object element2) {
        if (element2 instanceof ReservedEntity && LazyData.RE_SAMPLING_METHODS.contains((ReservedEntity)element2)) {
            return true;
        }
        DasRoutine foo = (DasRoutine)ObjectUtils.tryCast((Object)element2, DasRoutine.class);
        if (foo == null) {
            return false;
        }
        DasArgument arg = (DasArgument)SqlFunctionsUtil.getAcceptedArguments((DasObject)foo).single();
        DasArgument ret = foo.getReturnArgument();
        if (arg == null || ret == null || foo.getRoutineKind() != DasRoutine.Kind.FUNCTION) {
            return false;
        }
        return "internal".equalsIgnoreCase(arg.getDataType().getSpecification()) && "tsm_handler".equalsIgnoreCase(ret.getDataType().getSpecification());
    }

    @Override
    @NotNull
    protected List<ReservedEntity> getReservedObjects() {
        List<ReservedEntity> list = LazyData.ourObjects;
        if (list == null) {
            PgDialect.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PgDialect";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PgDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "isType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraKindsStrict";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExtraKindsStrict";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(PgTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final ObjectName PUBLIC_NAME = ObjectName.quoted((String)"public");
        static final Set<String> ourSystemVars;
        static final Set<String> ourExceptionNames;
        static final List<ReservedEntity> ourObjects;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final ReservedEntity RE_EXCLUDED;
        static final List<ReservedEntity> RE_SAMPLING_METHODS;
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtil.loadTokens(INSTANCE, "exceptions.txt"));
            ourObjects = SqlDialectImplUtil.loadObjects(INSTANCE, "fallback.txt");
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_ABS, SqlTokens.SQL_OP_NOT2, SqlTokens.PG_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.PG_OP_PRIME, SqlTokens.PG_OP_CUSTOM, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_PLUS_EQ, SqlTokens.SQL_OP_MINUS_EQ, SqlTokens.SQL_OP_MUL_EQ, SqlTokens.SQL_OP_DIV_EQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_MODULO_EQ, SqlTokens.SQL_OP_BITWISE_AND_EQ, SqlTokens.SQL_OP_BITWISE_OR_EQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2});
            RE_EXCLUDED = new ReservedEntity("excluded", SqlDbElementType.TABLE);
            RE_SAMPLING_METHODS = Arrays.asList(new ReservedEntity("bernoulli", SqlDbElementType.ROUTINE), new ReservedEntity("system", SqlDbElementType.ROUTINE));
            MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX, SqlDbElementType.TRIGGER, SqlDbElementType.RULE, SqlDbElementType.POLICY, SqlDbElementType.SERVER);
        }
    }
}

