/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.h2.H2OptionalKeywords;
import com.intellij.sql.dialects.h2.H2Tokens;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2Dialect
extends SqlLanguageDialectEx {
    public static final H2Dialect INSTANCE = new H2Dialect();

    public H2Dialect() {
        super("H2");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.H2;
        if (dbms == null) {
            H2Dialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            H2Dialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            H2Dialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            H2Dialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            H2Dialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            H2Dialect.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            H2Dialect.$$$reportNull$$$0(6);
        }
        if (!H2Dialect.processReservedEntitiesWithTypeDual(name2, element2, resolve, processor)) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, element2, resolve, processor);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectName[] dbAndSc = H2Dialect.getDatabaseAndSchema(dataSource);
        DasNamespace namespace = H2Dialect.getDefaultNamespace(dataSource, dbAndSc[0]);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(dbAndSc[1], ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                H2Dialect.$$$reportNull$$$0(7);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbAndSc[0], TreePatternUtils.create(dbAndSc[1], ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
        if (treePattern == null) {
            H2Dialect.$$$reportNull$$$0(8);
        }
        return treePattern;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            H2Dialect.$$$reportNull$$$0(9);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "array";
            }
            case TABLE: {
                return "table";
            }
            case COLLECTION: {
                return "array";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            H2Dialect.$$$reportNull$$$0(10);
        }
        if ("INT2".equals(name2 = super.getNormalizedTypeName(name2))) {
            if ("SMALLINT" == null) {
                H2Dialect.$$$reportNull$$$0(11);
            }
            return "SMALLINT";
        }
        if ("MEDIUMINT".equals(name2)) {
            if ("INTEGER" == null) {
                H2Dialect.$$$reportNull$$$0(12);
            }
            return "INTEGER";
        }
        if ("INT4".equals(name2)) {
            if ("INTEGER" == null) {
                H2Dialect.$$$reportNull$$$0(13);
            }
            return "INTEGER";
        }
        if ("SIGNED".equals(name2)) {
            if ("INTEGER" == null) {
                H2Dialect.$$$reportNull$$$0(14);
            }
            return "INTEGER";
        }
        if ("BIT".equals(name2)) {
            if ("BOOLEAN" == null) {
                H2Dialect.$$$reportNull$$$0(15);
            }
            return "BOOLEAN";
        }
        if ("BOOL".equals(name2)) {
            if ("BOOLEAN" == null) {
                H2Dialect.$$$reportNull$$$0(16);
            }
            return "BOOLEAN";
        }
        if ("INT8".equals(name2)) {
            if ("BIGINT" == null) {
                H2Dialect.$$$reportNull$$$0(17);
            }
            return "BIGINT";
        }
        if ("YEAR".equals(name2)) {
            if ("SMALLINT" == null) {
                H2Dialect.$$$reportNull$$$0(18);
            }
            return "SMALLINT";
        }
        if ("INT".equals(name2)) {
            if ("INTEGER" == null) {
                H2Dialect.$$$reportNull$$$0(19);
            }
            return "INTEGER";
        }
        if ("IDENTITY".equals(name2)) {
            if ("BIGINT" == null) {
                H2Dialect.$$$reportNull$$$0(20);
            }
            return "BIGINT";
        }
        if ("DEC".equals(name2)) {
            if ("DECIMAL" == null) {
                H2Dialect.$$$reportNull$$$0(21);
            }
            return "DECIMAL";
        }
        if ("NUMERIC".equals(name2)) {
            if ("DECIMAL" == null) {
                H2Dialect.$$$reportNull$$$0(22);
            }
            return "DECIMAL";
        }
        if ("NUMBER".equals(name2)) {
            if ("DECIMAL" == null) {
                H2Dialect.$$$reportNull$$$0(23);
            }
            return "DECIMAL";
        }
        if ("DOUBLE PRECISION".equals(name2)) {
            if ("DOUBLE" == null) {
                H2Dialect.$$$reportNull$$$0(24);
            }
            return "DOUBLE";
        }
        if ("FLOAT4".equals(name2)) {
            if ("REAL" == null) {
                H2Dialect.$$$reportNull$$$0(25);
            }
            return "REAL";
        }
        if ("FLOAT8".equals(name2)) {
            if ("DOUBLE" == null) {
                H2Dialect.$$$reportNull$$$0(26);
            }
            return "DOUBLE";
        }
        if ("FLOAT".equals(name2)) {
            if ("DOUBLE" == null) {
                H2Dialect.$$$reportNull$$$0(27);
            }
            return "DOUBLE";
        }
        if ("DATETIME".equals(name2)) {
            if ("TIMESTAMP" == null) {
                H2Dialect.$$$reportNull$$$0(28);
            }
            return "TIMESTAMP";
        }
        if ("SMALLDATETIME".equals(name2)) {
            if ("TIMESTAMP" == null) {
                H2Dialect.$$$reportNull$$$0(29);
            }
            return "TIMESTAMP";
        }
        if ("BINARY".equals(name2)) {
            if ("VARBINARY" == null) {
                H2Dialect.$$$reportNull$$$0(30);
            }
            return "VARBINARY";
        }
        if ("LONGVARBINARY".equals(name2)) {
            if ("VARBINARY" == null) {
                H2Dialect.$$$reportNull$$$0(31);
            }
            return "VARBINARY";
        }
        if ("RAW".equals(name2)) {
            if ("VARBINARY" == null) {
                H2Dialect.$$$reportNull$$$0(32);
            }
            return "VARBINARY";
        }
        if ("BYTEA".equals(name2)) {
            if ("VARBINARY" == null) {
                H2Dialect.$$$reportNull$$$0(33);
            }
            return "VARBINARY";
        }
        if ("VARCHAR2".equals(name2)) {
            if ("VARCHAR" == null) {
                H2Dialect.$$$reportNull$$$0(34);
            }
            return "VARCHAR";
        }
        if ("LONGVARCHAR".equals(name2)) {
            if ("VARCHAR" == null) {
                H2Dialect.$$$reportNull$$$0(35);
            }
            return "VARCHAR";
        }
        if ("VARCHAR_CASESENSITIVE".equals(name2)) {
            if ("VARCHAR" == null) {
                H2Dialect.$$$reportNull$$$0(36);
            }
            return "VARCHAR";
        }
        if ("NVARCHAR2".equals(name2)) {
            if ("VARCHAR" == null) {
                H2Dialect.$$$reportNull$$$0(37);
            }
            return "VARCHAR";
        }
        if ("NVARCHAR".equals(name2)) {
            if ("VARCHAR" == null) {
                H2Dialect.$$$reportNull$$$0(38);
            }
            return "VARCHAR";
        }
        if ("CHARACTER".equals(name2)) {
            if ("CHAR" == null) {
                H2Dialect.$$$reportNull$$$0(39);
            }
            return "CHAR";
        }
        if ("NCHAR".equals(name2)) {
            if ("CHAR" == null) {
                H2Dialect.$$$reportNull$$$0(40);
            }
            return "CHAR";
        }
        if ("TINYBLOB".equals(name2)) {
            if ("BLOB" == null) {
                H2Dialect.$$$reportNull$$$0(41);
            }
            return "BLOB";
        }
        if ("MEDIUMBLOB".equals(name2)) {
            if ("BLOB" == null) {
                H2Dialect.$$$reportNull$$$0(42);
            }
            return "BLOB";
        }
        if ("LONGBLOB".equals(name2)) {
            if ("BLOB" == null) {
                H2Dialect.$$$reportNull$$$0(43);
            }
            return "BLOB";
        }
        if ("IMAGE".equals(name2)) {
            if ("BLOB" == null) {
                H2Dialect.$$$reportNull$$$0(44);
            }
            return "BLOB";
        }
        if ("OID".equals(name2)) {
            if ("BLOB" == null) {
                H2Dialect.$$$reportNull$$$0(45);
            }
            return "BLOB";
        }
        if ("TINYTEXT".equals(name2)) {
            if ("CLOB" == null) {
                H2Dialect.$$$reportNull$$$0(46);
            }
            return "CLOB";
        }
        if ("TEXT".equals(name2)) {
            if ("CLOB" == null) {
                H2Dialect.$$$reportNull$$$0(47);
            }
            return "CLOB";
        }
        if ("MEDIUMTEXT".equals(name2)) {
            if ("CLOB" == null) {
                H2Dialect.$$$reportNull$$$0(48);
            }
            return "CLOB";
        }
        if ("LONGTEXT".equals(name2)) {
            if ("CLOB" == null) {
                H2Dialect.$$$reportNull$$$0(49);
            }
            return "CLOB";
        }
        if ("NTEXT".equals(name2)) {
            if ("CLOB" == null) {
                H2Dialect.$$$reportNull$$$0(50);
            }
            return "CLOB";
        }
        if ("NCLOB".equals(name2)) {
            if ("CLOB" == null) {
                H2Dialect.$$$reportNull$$$0(51);
            }
            return "CLOB";
        }
        String string = name2;
        if (string == null) {
            H2Dialect.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    private static ObjectName[] getDatabaseAndSchema(@Nullable DbDataSource dataSource) {
        ObjectName[] dbAndSc = new ObjectName[2];
        JdbcUrlParser parsed = SqlDialectImplUtil.getParsed(SqlImportUtil.getConnectionConfig(dataSource));
        if (parsed != null) {
            dbAndSc[0] = ObjectName.plain((String)StringUtil.nullize((String)parsed.getParameter("database")));
            if (dbAndSc[0] == null) {
                String path = StringUtil.nullize((String)parsed.getParameter("file"));
                if (path == null) {
                    path = StringUtil.nullize((String)parsed.getParameter("path"));
                }
                if (path != null) {
                    dbAndSc[0] = ObjectName.plain((String)new File(path).getName());
                }
            }
            dbAndSc[1] = ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)parsed.findProperty("schema"), (Object)parsed.getParameter("schema"))));
        }
        if (dbAndSc[1] == null) {
            dbAndSc[1] = ObjectName.plain((String)"public");
        }
        if (dbAndSc == null) {
            H2Dialect.$$$reportNull$$$0(53);
        }
        return dbAndSc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/h2/H2Dialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/h2/H2Dialect";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseAndSchema";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(H2Tokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_MODULO, H2OptionalKeywords.H2_REGEXP});
        }
    }
}

