/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.SqlModelBuilderUtils;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.database.SqlTxModelWrapper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilder {
    private final Project myProject;
    private final BasicModModel myModel;
    private final SqlObjectBuilder myObjectBuilder;
    private final Map<DasObject, BasicElement> mySources;
    private Map<BasicElement, SmartPsiElementPointer<SqlElement>> myMapping;
    private SqlTxModelWrapper myStagingModel;
    private SqlFileProcessor myProcessor;
    private boolean myApplied;

    public SqlModelBuilder(@NotNull Project project, @NotNull SqlObjectBuilder objectBuilder, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(0);
        }
        if (objectBuilder == null) {
            SqlModelBuilder.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(2);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(3);
        }
        this.mySources = new HashMap<DasObject, BasicElement>();
        this.myApplied = false;
        this.myProject = project;
        this.myModel = model;
        this.myMapping = mapping;
        this.myObjectBuilder = objectBuilder;
    }

    public SqlModelBuilder(@NotNull Project project, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(4);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(5);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(6);
        }
        this(project, (SqlObjectBuilder)SqlObjectBuilder.EP.forDbms(model.getDbms()), model, mapping);
    }

    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myModel;
        if (basicModModel == null) {
            SqlModelBuilder.$$$reportNull$$$0(7);
        }
        return basicModModel;
    }

    public void begin(boolean saveSources) {
        this.myStagingModel = new SqlTxModelWrapper(this.myModel, this.mySources, saveSources);
        this.myProcessor = new SqlFileProcessor(this.myProject, this.myStagingModel, this.myObjectBuilder);
        this.myApplied = false;
    }

    public int introspect(@NotNull List<SqlFile> files, int start, boolean clear2, long syncTimeout) {
        if (files == null) {
            SqlModelBuilder.$$$reportNull$$$0(8);
        }
        if (this.mySources.isEmpty() && !this.myMapping.isEmpty()) {
            for (Map.Entry<BasicElement, SmartPsiElementPointer<SqlElement>> entry : this.myMapping.entrySet()) {
                DasObject object = (DasObject)ObjectUtils.tryCast((Object)entry.getValue().getElement(), DasObject.class);
                if (object == null) continue;
                this.mySources.put(object, entry.getKey());
            }
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        long time = System.currentTimeMillis();
        for (int i2 = start; i2 < files.size(); ++i2) {
            SqlFile file = files.get(i2);
            if (indicator != null) {
                indicator.setFraction(((double)i2 + 0.0) / (double)files.size());
                indicator.setText2(file.getName());
            }
            this.myStagingModel.modify(() -> this.myProcessor.process(file));
            long cur = System.currentTimeMillis();
            if ((syncTimeout == -1L || cur - time <= syncTimeout) && i2 + 1 != files.size()) continue;
            this.myMapping = this.apply(this.myProcessor, clear2);
            this.myApplied = true;
            return i2 + 1;
        }
        return files.size();
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> getMapping() {
        Map<BasicElement, SmartPsiElementPointer<SqlElement>> map2 = this.myMapping;
        if (map2 == null) {
            SqlModelBuilder.$$$reportNull$$$0(9);
        }
        return map2;
    }

    public void end() {
        if (this.myApplied) {
            this.myModel.modify(BasicModRoot.class, r -> this.finish());
        }
        this.myStagingModel = null;
        this.myProcessor = null;
        this.myApplied = false;
        this.mySources.clear();
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> apply(SqlFileProcessor processor, boolean clear2) {
        final Map<BasicElement, SmartPsiElementPointer<SqlElement>> tmp = processor.reverseMap();
        this.myModel.modify(BasicModRoot.class, r -> {
            if (clear2) {
                this.prepare();
            }
            processor.apply();
        });
        final HashMap<BasicElement, SmartPsiElementPointer<SqlElement>> result2 = new HashMap<BasicElement, SmartPsiElementPointer<SqlElement>>(this.myMapping);
        new SqlTxModelWrapper.TwoModelVisitor(){

            @Override
            public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
                if (guide == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (guided == null) {
                    1.$$$reportNull$$$0(1);
                }
                ContainerUtil.putIfNotNull((Object)guide, tmp.get(guided), (Map)result2);
                super.visit(guide, guided);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guide";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guided";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/database/SqlModelBuilder$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(this.myModel.getRoot(), processor.getRoot());
        HashMap<BasicElement, SmartPsiElementPointer<SqlElement>> hashMap = result2;
        if (hashMap == null) {
            SqlModelBuilder.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    public void prepare() {
        for (BasicModElement element2 : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : element2.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        }
    }

    public void finish() {
        for (BasicModElement element2 : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : element2.getFamilies()) {
                modFamily.removeSyncPendingChildren();
                modFamily.sort();
            }
        }
        this.finalizeObjects();
    }

    public void finalizeObjects() {
        for (BasicModElement element2 : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            this.myObjectBuilder.finalize((DasObject)element2);
        }
    }

    public static boolean isIgnored(Dbms dbms, ObjectKind p2, ObjectKind c2) {
        if (c2 == SqlDbElementType.ANY) {
            return true;
        }
        if (p2 == ObjectKind.SCHEMA && c2 == ObjectKind.ROLE) {
            return true;
        }
        if (dbms.isOracle()) {
            if (p2 == ObjectKind.BODY) {
                return true;
            }
            if (p2 == ObjectKind.SCHEMA) {
                return c2 == ObjectKind.OPERATOR || c2 == ObjectKind.EXCEPTION || "library".equals(c2.name()) || "INDEX TYPE".equals(c2.name());
            }
        }
        if (p2 == ObjectKind.OBJECT_TYPE) {
            return c2 == SqlDbElementType.CONSTRAINT;
        }
        return false;
    }

    protected void buildObject(@NotNull BasicModElement target2, @NotNull DasObject obj2) {
        if (target2 == null) {
            SqlModelBuilder.$$$reportNull$$$0(11);
        }
        if (obj2 == null) {
            SqlModelBuilder.$$$reportNull$$$0(12);
        }
        if (obj2 instanceof BasicElement) {
            BasicMetaUtils.copyMatchedProperties((BasicElement)obj2, target2, false, true);
        } else {
            this.myObjectBuilder.build((DasObject)target2, obj2);
        }
    }

    private static DasObject unwrapFake(DasObject obj2) {
        SqlDefinition delegate;
        if (obj2 instanceof SqlFileImpl.FakeDefinition && (delegate = (SqlDefinition)((SqlFileImpl.FakeDefinition)obj2).delegates().first()) != null) {
            return delegate;
        }
        if (obj2 instanceof DbElement) {
            return (DasObject)((DbElement)obj2).getDelegate();
        }
        return obj2;
    }

    private static boolean isAppendable(BasicModElement target2) {
        return target2 instanceof DasNamespace || target2.getKind() == ObjectKind.PACKAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectBuilder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "introspect";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SqlFileProcessor {
        private final Project myProject;
        private final Map<ObjectPath, BasicModElement> myObjects;
        private final Map<DasObject, BasicModElement> myProcessed;
        private final Set<DasObject> myDelayed;
        private final SqlTxModelWrapper myModel;
        private SqlLanguageDialectEx myLanguage;
        private final SqlObjectBuilder myObjectBuilder;
        private final Dbms myDbms;
        private final Map<DasObject, PsiElement> myOraPackageRestarter;

        SqlFileProcessor(@NotNull Project project, @NotNull SqlTxModelWrapper model, SqlObjectBuilder objectBuilder) {
            if (project == null) {
                SqlFileProcessor.$$$reportNull$$$0(0);
            }
            if (model == null) {
                SqlFileProcessor.$$$reportNull$$$0(1);
            }
            if (objectBuilder == null) {
                SqlFileProcessor.$$$reportNull$$$0(2);
            }
            this.myObjects = new HashMap<ObjectPath, BasicModElement>();
            this.myProcessed = new LinkedHashMap<DasObject, BasicModElement>();
            this.myDelayed = new LinkedHashSet<DasObject>();
            this.myOraPackageRestarter = new HashMap<DasObject, PsiElement>();
            this.myProject = project;
            this.myModel = model;
            this.myObjectBuilder = objectBuilder;
            this.myDbms = this.myModel.getDbms();
        }

        public void processDelayed() {
            while (!this.myDelayed.isEmpty()) {
                Iterator<DasObject> it2 = this.myDelayed.iterator();
                DasObject d2 = it2.next();
                it2.remove();
                d2.getDasChildren(null).forEach(o -> this.process((DasObject)o));
            }
        }

        public void process(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(3);
            }
            this.myLanguage = (SqlLanguageDialectEx)file.getSqlLanguage();
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            for (DasObject obj2 : file.traverser().preOrderDfsTraversal()) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                this.process(obj2);
            }
            for (SqlAlterStatement stmt : SqlImplUtil.sqlElements((PsiElement)file).filter(SqlAlterStatement.class)) {
                if (stmt instanceof SqlCommentStatementImpl) {
                    SqlCommentStatementImpl commentStatement2 = (SqlCommentStatementImpl)stmt;
                    IElementType type = commentStatement2.getElementType();
                    if (type != SqlCompositeElementTypes.SQL_COMMENT_STATEMENT) continue;
                    this.processCommentStmt(commentStatement2);
                    continue;
                }
                SqlReferenceExpression reference = stmt.getAlterTargetReference();
                DasObject resolved = reference == null ? null : (DasObject)ObjectUtils.tryCast((Object)reference.resolve(), DasObject.class);
                BasicModElement element2 = resolved == null ? null : this.process(resolved);
                if (element2 == null) continue;
                this.myObjectBuilder.build((DasObject)element2, (SqlElement)stmt);
            }
            this.processDelayed();
        }

        private void processCommentStmt(@NotNull SqlCommentStatementImpl stmt) {
            if (stmt == null) {
                SqlFileProcessor.$$$reportNull$$$0(4);
            }
            SqlReferenceExpression tgt = stmt.getAlterTargetReference();
            for (SqlClause clause : SqlImplUtil.sqlChildren((PsiElement)stmt).filter(SqlClause.class)) {
                BasicModNamedElement processed;
                SqlExpression comment;
                SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)clause, SqlReferenceExpression.class);
                SqlExpression sqlExpression = comment = ref == null ? (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)clause, SqlExpression.class) : (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)ref, SqlExpression.class);
                if (ref == null) {
                    ref = tgt;
                }
                if (ref == null || comment == null) continue;
                DasObject target2 = (DasObject)ObjectUtils.tryCast((Object)ref.resolve(), DasObject.class);
                BasicModNamedElement basicModNamedElement = processed = target2 == null ? null : (BasicModNamedElement)ObjectUtils.tryCast((Object)this.process(target2), BasicModNamedElement.class);
                if (processed == null) continue;
                this.myObjectBuilder.build((DasObject)processed, (SqlElement)comment);
            }
        }

        @Nullable
        private BasicModElement process(@NotNull DasObject obj2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(5);
            }
            if (obj2 instanceof SqlRenameToClause || obj2 instanceof PsiElement && !(obj2 instanceof FakePsiElement) && !(obj2 instanceof SqlStubbedElement)) {
                return null;
            }
            obj2 = SqlModelBuilder.unwrapFake(obj2);
            ObjectPath path = ObjectPaths.of(obj2);
            if (this.myProcessed.containsKey(obj2)) {
                return this.myModel.nullize(this.getProcessed(obj2, path));
            }
            BasicModElement parent2 = this.getParent(obj2);
            return this.processSingle(obj2, path, parent2);
        }

        @Nullable
        private BasicModElement getProcessed(@NotNull DasObject obj2, @NotNull ObjectPath path) {
            BasicModElement target2;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(6);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(7);
            }
            if ((target2 = this.myProcessed.get(obj2)) != null) {
                return target2;
            }
            if (obj2 instanceof DasConstraint && obj2.getName().isEmpty()) {
                return null;
            }
            target2 = this.myObjects.get(path);
            ContainerUtil.putIfNotNull((Object)obj2, (Object)target2, this.myProcessed);
            return target2;
        }

        private void processSingle(@NotNull DasObject obj2, @Nullable BasicModElement parent2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(8);
            }
            this.processSingle(obj2, ObjectPaths.of(SqlModelBuilder.unwrapFake(obj2)), parent2);
        }

        @Nullable
        private BasicModElement processSingle(@NotNull DasObject obj2, @NotNull ObjectPath path, @Nullable BasicModElement parent2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(9);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(10);
            }
            ObjectKind kind = this.getKind(obj2);
            if (this.myModel.getMetaModel().findKind(kind.code()) == null) {
                this.markObjectReady(path, obj2, null);
                return null;
            }
            this.processOddities(obj2, parent2, kind);
            BasicModElement target2 = this.myModel.createOrGet(obj2, parent2, path, kind);
            this.markObjectReady(path, obj2, target2);
            if (target2 == null) {
                ObjectKind parentKind;
                boolean ignored = false;
                ObjectPath p2 = path;
                while (p2.parent != null && !ignored) {
                    if (SqlModelBuilder.isIgnored(this.myDbms, p2.parent.kind, p2.kind)) {
                        ignored = true;
                    }
                    p2 = p2.parent;
                }
                ObjectKind objectKind = parentKind = parent2 == null ? ObjectKind.NONE : parent2.getKind();
                if (!ignored && !SqlModelBuilder.isIgnored(this.myDbms, parentKind, obj2.getKind())) {
                    boolean ignore;
                    SqlLanguageDialect lang = DbSqlUtil.getSqlDialect((PsiElement)ObjectUtils.tryCast((Object)obj2, PsiElement.class));
                    boolean bl = ignore = lang != null && lang.getDbms() != this.myModel.getDbms() || parent2 == null && obj2.getDasParent() instanceof SqlRenameToClause;
                    if (!ignore) {
                        SqlModelBuilderUtils.hardWarning("No family " + kind.code() + " in " + parentKind.code());
                    }
                }
            } else {
                if (!SqlModelBuilder.isAppendable(target2)) {
                    target2.getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
                }
                this.processRequiredChildren(obj2, target2);
                SqlModelBuilder.this.buildObject(target2, obj2);
            }
            return target2;
        }

        @NotNull
        private ObjectKind getKind(@NotNull DasObject obj2) {
            DasObject p2;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(11);
            }
            if (this.myLanguage.getDbms().isOracle() && obj2.getKind() == ObjectKind.OBJECT_TYPE && (p2 = obj2.getDasParent()) != null && p2.getKind() == ObjectKind.PACKAGE) {
                ObjectKind objectKind = ObjectKind.ALIAS_TYPE;
                if (objectKind == null) {
                    SqlFileProcessor.$$$reportNull$$$0(12);
                }
                return objectKind;
            }
            ObjectKind objectKind = this.myLanguage.unaliased(obj2.getKind());
            if (objectKind == null) {
                SqlFileProcessor.$$$reportNull$$$0(13);
            }
            return objectKind;
        }

        private void processRequiredChildren(@NotNull DasObject obj2, @NotNull BasicModElement target2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(14);
            }
            if (target2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(15);
            }
            if (target2 instanceof BasicTable) {
                for (DasObject column2 : obj2.getDasChildren(ObjectKind.COLUMN)) {
                    this.processSingle(column2, target2);
                }
            }
            if (target2 instanceof BasicModRoutine) {
                for (DasObject argument : obj2.getDasChildren(ObjectKind.ARGUMENT)) {
                    this.processSingle(argument, target2);
                }
            }
        }

        private void markObjectReady(ObjectPath path, @NotNull DasObject obj2, @Nullable BasicModElement target2) {
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(16);
            }
            BasicModElement nnTarget = this.myModel.notNullize(target2);
            this.myObjects.put(path, nnTarget);
            this.myProcessed.put(obj2, nnTarget);
        }

        private void processOddities(@NotNull DasObject obj2, @Nullable BasicModElement parent2, @NotNull ObjectKind kind) {
            PsiElement element2;
            PsiObject pkg;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(17);
            }
            if (kind == null) {
                SqlFileProcessor.$$$reportNull$$$0(18);
            }
            if (this.myDbms.isOracle() && parent2 != null && parent2.getKind() == ObjectKind.PACKAGE && kind != ObjectKind.BODY && (pkg = (PsiObject)JBIterable.generate((Object)ObjectUtils.tryCast((Object)obj2, PsiElement.class), x -> x.getContext()).filter(PsiObject.class).skip(1).first()) != null && pkg.getKind() == ObjectKind.PACKAGE && ((element2 = this.myOraPackageRestarter.get(parent2)) == null || element2 != pkg)) {
                this.myOraPackageRestarter.put(parent2, (PsiElement)pkg);
                JBIterable.from(parent2.getFamilyKinds()).filter(x -> x != ObjectKind.BODY).transform(parent2::familyOf).forEach(ModFamily::markChildrenAsSyncPending);
            }
        }

        @Nullable
        private BasicModElement getParent(@NotNull DasObject obj2) {
            ObjectKind kind;
            DasObject parent2;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(19);
            }
            if ((parent2 = SqlModelBuilder.unwrapFake(obj2.getDasParent())) != null && !this.isValidParent(parent2, obj2)) {
                parent2 = null;
            }
            ObjectKind objectKind = kind = parent2 == null ? ObjectKind.NONE : parent2.getKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.ROOT) {
                return this.myModel.getEmptyParent(this.getKind(obj2));
            }
            ObjectPath parentPath = ObjectPaths.of(parent2);
            BasicModElement element2 = this.getProcessed(parent2, parentPath);
            if (element2 != null) {
                return this.myModel.nullize(element2);
            }
            if (!(parent2 instanceof BasicElement) && !(parent2 instanceof DasNamespace)) {
                this.myDelayed.add(parent2);
            }
            return this.process(parent2);
        }

        private boolean isValidParent(DasObject parent2, @NotNull DasObject obj2) {
            ObjectKind pk;
            if (obj2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(20);
            }
            if ((pk = this.getKind(parent2)) == ObjectKind.NONE) {
                pk = ObjectKind.ROOT;
            }
            ObjectKind ck = this.getKind(obj2);
            if (pk == ObjectKind.BODY) {
                return true;
            }
            return this.myModel.getMetaModel().getChildKinds(pk).contains((Object)ck);
        }

        @NotNull
        public Map<BasicElement, SmartPsiElementPointer<SqlElement>> reverseMap() {
            LinkedHashMap<BasicElement, SmartPsiElementPointer<SqlElement>> res2 = new LinkedHashMap<BasicElement, SmartPsiElementPointer<SqlElement>>();
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            for (Map.Entry<DasObject, BasicModElement> pair : this.myProcessed.entrySet()) {
                BasicModElement target2;
                SqlElement object = (SqlElement)ObjectUtils.tryCast((Object)pair.getKey(), SqlElement.class);
                if (object == null || this.myModel.nullize(target2 = pair.getValue()) == null) continue;
                res2.put(target2, (SmartPsiElementPointer<SqlElement>)pointerManager.createSmartPsiElementPointer((PsiElement)object));
            }
            LinkedHashMap<BasicElement, SmartPsiElementPointer<SqlElement>> linkedHashMap = res2;
            if (linkedHashMap == null) {
                SqlFileProcessor.$$$reportNull$$$0(21);
            }
            return linkedHashMap;
        }

        public void apply() {
            this.myModel.getDirty().forEach(arg_0 -> ((SqlObjectBuilder)this.myObjectBuilder).finalize(arg_0));
            this.myModel.apply();
        }

        @NotNull
        public BasicElement getRoot() {
            BasicModElement basicModElement = this.myModel.getRoot();
            if (basicModElement == null) {
                SqlFileProcessor.$$$reportNull$$$0(22);
            }
            return basicModElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 12: 
                case 13: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 12: 
                case 13: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stmt";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 14: 
                case 16: 
                case 17: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 12: 
                case 13: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reverseMap";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processCommentStmt";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getProcessed";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "processSingle";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getKind";
                    break;
                }
                case 12: 
                case 13: 
                case 21: 
                case 22: {
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "processRequiredChildren";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "markObjectReady";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "processOddities";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 12: 
                case 13: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

