/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCommonTestUtils {
    private static final PluginDescriptor ourDescriptor = new DefaultPluginDescriptor(PluginId.getId((String)"database.tests"), SqlCommonTestUtils.class.getClassLoader());

    @NotNull
    public static JBIterable<DbmsExtension.Bean<SqlLanguageDialect>> loadSqlDialectBeans() {
        JBIterable jBIterable = SqlCommonTestUtils.loadDbmsExtensionBeans(SqlLanguageDialect.EP);
        if (jBIterable == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbmsExtension.Bean<DatabaseDialect>> loadDatabaseDialectBeans() {
        JBIterable jBIterable = SqlCommonTestUtils.loadDbmsExtensionBeans(DatabaseDialect.EP);
        if (jBIterable == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @NotNull
    public static <T> JBIterable<DbmsExtension.Bean<T>> loadDbmsExtensionBeans(@NotNull DbmsExtension<T> ep) {
        if (ep == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(2);
        }
        String epName = ep.getName();
        boolean isInstance = ep == SqlLanguageDialect.EP;
        boolean isSql = epName.contains(".sql.") || ep == DatabaseDialect.EP;
        Class clazz = isInstance ? DbmsExtension.InstanceBean.class : DbmsExtension.Bean.class;
        JBIterable<DbmsExtension.InstanceBean> jBIterable = SqlCommonTestUtils.loadBeans(epName, clazz, isSql);
        if (jBIterable == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public static List<URL> loadConfigUrls(@NotNull ExtensionPointName<DatabaseDriverManagerImpl.ConfigUrlBean> ep) {
        if (ep == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(4);
        }
        List<URL> list = DatabaseDriverManagerImpl.ConfigUrlBean.getUrls(SqlCommonTestUtils.loadConfigUrlBeans(ep));
        if (list == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<DatabaseDriverManagerImpl.ConfigUrlBean> loadConfigUrlBeans(@NotNull ExtensionPointName<DatabaseDriverManagerImpl.ConfigUrlBean> ep) {
        if (ep == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(6);
        }
        List list = SqlCommonTestUtils.loadBeans(ep.getName(), DatabaseDriverManagerImpl.ConfigUrlBean.class, false).toList();
        if (list == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(7);
        }
        return list;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static <T extends AbstractExtensionPointBean> JBIterable<T> loadBeans(String epName, Class<? extends T> clazz, boolean isSql) {
        class MyOrderable
        implements LoadingOrder.Orderable {
            final T bean;
            final String orderId;
            final LoadingOrder order;
            final /* synthetic */ Class val$clazz;

            MyOrderable(Element element2) {
                this.val$clazz = element2;
                this.bean = (AbstractExtensionPointBean)XmlSerializer.deserialize((Element)e, (Class)this.val$clazz);
                this.bean.setPluginDescriptor(ourDescriptor);
                this.orderId = e.getAttributeValue("id");
                this.order = LoadingOrder.readOrder((String)e.getAttributeValue("order"));
            }

            @Nullable
            public String getOrderId() {
                return this.orderId;
            }

            public LoadingOrder getOrder() {
                return this.order;
            }
        }
        String shortName = StringUtil.getShortName((String)epName);
        String descriptorPath = isSql ? "/META-INF/SqlDialects.xml" : "/META-INF/DatabaseDialects.xml";
        URL xml = DbmsExtension.class.getClassLoader().getResource(descriptorPath);
        if (xml == null) {
            throw new AssertionError((Object)("descriptor not found: " + descriptorPath));
        }
        InputStream stream = xml.openStream();
        Throwable throwable = null;
        List contents = JDOMXIncluder.resolve((Element)JDOMUtil.load((InputStream)stream), (URL)xml);
        List list = (List)JBIterable.from((Iterable)contents).filter(Element.class).flatten(e -> e.getChildren("extensions")).flatten(e -> e.getChildren()).filter(e -> e.getName().endsWith(shortName)).filter(e -> epName.equals(StringUtil.getQualifiedName((String)e.getParentElement().getAttributeValue("defaultExtensionNs"), (String)e.getName()))).map(x$0 -> new MyOrderable(x$0, clazz)).addAllTo(new ArrayList());
        LoadingOrder.sort((List)list);
        JBIterable result2 = JBIterable.from((Iterable)list).map(o -> o.bean).collect();
        if (result2.isEmpty()) {
            throw new AssertionError((Object)(epName + " is empty in " + descriptorPath));
        }
        JBIterable jBIterable = result2;
        JBIterable jBIterable2 = jBIterable;
        if (jBIterable2 == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(8);
        }
        return jBIterable2;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            {
                catch (Exception e2) {
                    throw new AssertionError("Failed to load '" + epName + "' list", e2);
                }
            }
        }
    }

    @NotNull
    public static <T> T getDialectClass(@NotNull String dialectClass, @NotNull String suffix) {
        Object object;
        if (dialectClass == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(9);
        }
        if (suffix == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(10);
        }
        String path = dialectClass.replace("Dialect", suffix);
        try {
            object = ReflectionUtil.newInstance(Class.forName(path));
        }
        catch (ClassNotFoundException e) {
            Object object2;
            String basePath = SqlCommonTestUtils.getBaseDialectClass(path);
            if (basePath == null) {
                throw new AssertionError((Object)e);
            }
            try {
                object2 = ReflectionUtil.newInstance(Class.forName(basePath));
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionError((Object)e2);
            }
            if (object2 == null) {
                SqlCommonTestUtils.$$$reportNull$$$0(12);
            }
            return (T)object2;
        }
        if (object == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(11);
        }
        return (T)object;
    }

    private static String getBaseDialectClass(String path) {
        if (path.contains(".mysql.Mysql")) {
            return path.replace(".mysql.Mysql", ".mysqlbase.MysqlBase");
        }
        if (path.contains(".maria.Maria")) {
            return path.replace(".maria.Maria", ".mysqlbase.MysqlBase");
        }
        if (path.contains(".db2.Db2LUW")) {
            return path.replace(".db2.Db2LUW", ".db2.Db2Base");
        }
        if (path.contains(".db2.Db2")) {
            return path.replace(".db2.Db2", ".db2.Db2Base");
        }
        return null;
    }

    public static Map<BasicElement, SmartPsiElementPointer<SqlElement>> fillModelOnPooledThread(@NotNull Project project, DasModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(13);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(14);
        }
        Ref res2 = Ref.create();
        DbUIUtil.invokeOnPooledThreadSync(() -> DbImplUtil.performSrcOperation(project, model, null, false, () -> ReadAction.run(() -> res2.set(SqlCommonTestUtils.fillModel(project, (BasicModModel)model, saveSources, useReadOnlyPsi, texts)))));
        return (Map)res2.get();
    }

    private static Map<BasicElement, SmartPsiElementPointer<SqlElement>> fillModel(@NotNull Project project, @NotNull BasicModModel model, boolean saveSources, boolean useReadOnlyPsi, String ... texts) {
        PsiErrorElement error2;
        if (project == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(15);
        }
        if (model == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(16);
        }
        if (texts == null) {
            SqlCommonTestUtils.$$$reportNull$$$0(17);
        }
        SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect(model.getDbms());
        List files = JBIterable.of((Object[])texts).map(text2 -> useReadOnlyPsi ? SqlPsiFacade.getInstance((Project)project).createROFile(sqlDialect, (CharSequence)text2) : (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlDialect, (CharSequence)text2)).toList();
        if (!useReadOnlyPsi && (error2 = (PsiErrorElement)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)files)).filter(PsiErrorElement.class).first()) != null) {
            throw new AssertionError((Object)(error2.getContainingFile().getName() + ": " + error2.getErrorDescription()));
        }
        SqlModelBuilder builder = new SqlModelBuilder(project, model, new HashMap<BasicElement, SmartPsiElementPointer<SqlElement>>());
        builder.begin(saveSources);
        builder.introspect(files, 0, true, -1L);
        builder.end();
        return builder.getMapping();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlCommonTestUtils";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSqlDialectBeans";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDatabaseDialectBeans";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlCommonTestUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDbmsExtensionBeans";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfigUrls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfigUrlBeans";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBeans";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadDbmsExtensionBeans";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigUrls";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigUrlBeans";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDialectClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillModelOnPooledThread";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

