/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseRefactoringHandler
extends AbstractDatabaseModifier {
    private static final String INDICATOR_TITLE = "Updating Database...";
    @NotNull
    private final RefactoringExecutor myRefactoringExecutor;

    public DatabaseRefactoringHandler(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable SearchPath searchPath) {
        if (project == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(1);
        }
        super(project, dataSource, searchPath, DGDepartment.REFACTORING, INDICATOR_TITLE);
        this.myRefactoringExecutor = new RefactoringExecutor(project, dataSource);
    }

    @NotNull
    public DatabaseRefactoringHandler setStatement(@NotNull String statement) {
        if (statement == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(2);
        }
        this.myRefactoringExecutor.setStatement(statement);
        DatabaseRefactoringHandler databaseRefactoringHandler = this;
        if (databaseRefactoringHandler == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(3);
        }
        return databaseRefactoringHandler;
    }

    @NotNull
    public String getStatement() {
        String string = this.myRefactoringExecutor.getStatement();
        if (string == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        RefactoringExecutor refactoringExecutor = this.myRefactoringExecutor;
        if (refactoringExecutor == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(5);
        }
        return refactoringExecutor;
    }

    private static int executeQueries(@NotNull Project project, @NotNull DatabaseConnection connection2, @NotNull List<String> queries, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(6);
        }
        if (connection2 == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(7);
        }
        if (queries == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(9);
        }
        int totalCount = queries.size();
        int count2 = 0;
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        try (ReusableSmartStatement<String> statement = SmartStatements.poweredBy(connection2).simple().reuse();){
            for (String query : queries) {
                if (StringUtil.isEmptyOrSpaces((String)query)) {
                    ++count2;
                    continue;
                }
                indicator.checkCanceled();
                try {
                    statement.barren().execute(query, StandardExecutionMode.UPDATE);
                    indicator.setFraction((double)(++count2) / (double)totalCount);
                }
                catch (Exception e) {
                    int n = count2;
                    if (statement != null) {
                        if (var7_7 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                    return n;
                }
            }
        }
        indicator.setIndeterminate(true);
        return count2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseRefactoringHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseRefactoringHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setStatement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RefactoringExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        @NotNull
        private String myStatement;
        private final Project myProject;
        @NotNull
        private final LocalDataSource myDataSource;

        RefactoringExecutor(@NotNull Project project, @NotNull LocalDataSource dataSource) {
            if (project == null) {
                RefactoringExecutor.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                RefactoringExecutor.$$$reportNull$$$0(1);
            }
            this.myStatement = "";
            this.myProject = project;
            this.myDataSource = dataSource;
        }

        public void setStatement(@NotNull String statement) {
            if (statement == null) {
                RefactoringExecutor.$$$reportNull$$$0(2);
            }
            this.myStatement = statement;
        }

        @NotNull
        public String getStatement() {
            String string = this.myStatement;
            if (string == null) {
                RefactoringExecutor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public CompletionStage<?> execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseSessionManager.Facade facade, @NotNull ErrorHandler errorHandler) {
            if (indicator == null) {
                RefactoringExecutor.$$$reportNull$$$0(4);
            }
            if (facade == null) {
                RefactoringExecutor.$$$reportNull$$$0(5);
            }
            if (errorHandler == null) {
                RefactoringExecutor.$$$reportNull$$$0(6);
            }
            return facade.runAsync(SessionsUtil.consumer(connection2 -> {
                indicator.setText("Updating database...");
                this.execute(indicator, (DatabaseConnection)connection2);
            }));
        }

        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseConnection connection2) {
            List<String> queries;
            if (indicator == null) {
                RefactoringExecutor.$$$reportNull$$$0(7);
            }
            if (connection2 == null) {
                RefactoringExecutor.$$$reportNull$$$0(8);
            }
            return (queries = DbSqlUtil.getQueries(this.myStatement, this.myProject, (Language)DbSqlUtil.getSqlDialect(this.myDataSource))).size() == DatabaseRefactoringHandler.executeQueries(this.myProject, connection2, queries, indicator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setStatement";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

