/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.Dbms;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbStorageFileType
extends UserBinaryFileType {
    private final Dbms myDbms;
    private final String[] myPrefixes;

    protected DbStorageFileType(@NotNull Dbms id, String ... prefixes) {
        if (id == null) {
            DbStorageFileType.$$$reportNull$$$0(0);
        }
        if (prefixes == null) {
            DbStorageFileType.$$$reportNull$$$0(1);
        }
        this.myDbms = id;
        this.myPrefixes = prefixes;
    }

    @NotNull
    public String getName() {
        String string = this.getDbms().getDisplayName() + " Database";
        if (string == null) {
            DbStorageFileType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.getDbms().getDisplayName() + " storage";
        if (string == null) {
            DbStorageFileType.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIcon() {
        return DatabaseIcons.Dbms;
    }

    @NotNull
    public final Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            DbStorageFileType.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    public boolean isReadOnly() {
        return true;
    }

    @NotNull
    final String[] getFilePrefixes() {
        if (this.myPrefixes == null) {
            DbStorageFileType.$$$reportNull$$$0(5);
        }
        return this.myPrefixes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DbStorageFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DbStorageFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePrefixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Detector
    implements FileTypeRegistry.FileTypeDetector {
        private final AtomicNotNullLazyValue<List<DbStorageFileType>> myFileTypes = AtomicNotNullLazyValue.createValue(() -> ContainerUtil.findAll((Object[])FileTypeManager.getInstance().getRegisteredFileTypes(), DbStorageFileType.class));

        Detector() {
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file == null) {
                Detector.$$$reportNull$$$0(0);
            }
            if (firstBytes == null) {
                Detector.$$$reportNull$$$0(1);
            }
            for (DbStorageFileType fileType : (List)this.myFileTypes.getValue()) {
                for (String prefix : fileType.getFilePrefixes()) {
                    if (!Detector.prefixMatches(prefix, firstBytes)) continue;
                    return fileType;
                }
            }
            return null;
        }

        private static boolean prefixMatches(@NotNull String prefix, @NotNull ByteSequence bytes) {
            int length;
            if (prefix == null) {
                Detector.$$$reportNull$$$0(2);
            }
            if (bytes == null) {
                Detector.$$$reportNull$$$0(3);
            }
            if ((length = prefix.length()) == 0) {
                return false;
            }
            if (bytes.length() < length) {
                return false;
            }
            for (int i2 = 0; i2 < length; ++i2) {
                if (prefix.charAt(i2) == (char)bytes.byteAt(i2)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public Collection<? extends FileType> getDetectedFileTypes() {
            Collection collection = (Collection)this.myFileTypes.getValue();
            if (collection == null) {
                Detector.$$$reportNull$$$0(4);
            }
            return collection;
        }

        public int getVersion() {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstBytes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/vfs/DbStorageFileType$Detector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/vfs/DbStorageFileType$Detector";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDetectedFileTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detect";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "prefixMatches";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class H2Storage
    extends DbStorageFileType {
        public static final H2Storage INSTANCE = new H2Storage();

        private H2Storage() {
            super(Dbms.H2, "-- H2 0.5/B --", "H:2");
        }

        @NotNull
        public String getDefaultExtension() {
            if ("h2.db" == null) {
                H2Storage.$$$reportNull$$$0(0);
            }
            return "h2.db";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType$H2Storage", "getDefaultExtension"));
        }
    }

    public static class SqliteStorage
    extends DbStorageFileType {
        public static final SqliteStorage INSTANCE = new SqliteStorage();

        private SqliteStorage() {
            super(Dbms.SQLITE, "SQLite format ");
        }
    }
}

